/*
 * @(#)DestinationUpdateHandler.java	1.3 03/18/05
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import java.io.*;
import java.util.Hashtable;
import com.sun.messaging.jmq.util.*;
import com.sun.messaging.jmq.jmsserver.util.*;
import com.sun.messaging.jmq.io.*;
import com.sun.messaging.jmq.jmsserver.core.*;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.*;

public class DestinationUpdateHandler extends GPacketHandler {
    public static boolean DEBUG = false;

    public DestinationUpdateHandler(RaptorProtocol p) {
        super(p);
    }

    public void handle(BrokerAddress sender, GPacket pkt) {
        if (pkt.getType() == ProtocolGlobals.G_UPDATE_DESTINATION) {
            handleUpdateDestination(sender, pkt);
        }
        else if (pkt.getType() == ProtocolGlobals.G_REM_DESTINATION) {
            handleRemDestination(sender, pkt);
        }
        else if (pkt.getType() == ProtocolGlobals.G_UPDATE_DESTINATION_REPLY ||
            pkt.getType() == ProtocolGlobals.G_REM_DESTINATION_REPLY) {
            handleReply(sender, pkt);
        }
        else {
            logger.log(logger.WARNING, "DestinationUpdateHandler " +
                "Internal error : Cannot handle this packet :" +
                pkt.toLongString());
        }
    }

    public void handleUpdateDestination(BrokerAddress sender, GPacket pkt) {
        ClusterDestInfo cdi = ClusterDestInfo.newInstance(pkt);
        DestinationUID duid = cdi.getDestUID(); 

        try {
            Hashtable props = cdi.getDestProps();

            Destination d = Destination.getDestination(duid);
            if (d == null) {
                d = Destination.createDestination(cdi.getDestName(), cdi.getDestType(),
                    ! DestType.isTemporary(cdi.getDestType()), false, selfAddress);
                d.setDestinationProperties(props);
                cbDispatcher.notifyCreateDestination(d);
            }
            else {
                cbDispatcher.notifyUpdateDestination(duid, props);
            }
        }
        catch (Exception e) {
            logger.logStack(logger.INFO,
                "Internal Exception, unable to process message " +
                pkt, e);
            return;
        }
    }

    public void handleRemDestination(BrokerAddress sender, GPacket pkt) {
        ClusterDestInfo cdi = ClusterDestInfo.newInstance(pkt);
        DestinationUID duid = cdi.getDestUID(); 

        cbDispatcher.notifyDestroyDestination(duid);
    }

    public void handleReply(BrokerAddress sender, GPacket pkt) {
    }
}


/*
 * EOF
 */
