
/*
 * @(#)GetInterestUpdateHandler.java	1.1 06/16/03
 *
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import java.io.*;
import com.sun.messaging.jmq.util.*;
import com.sun.messaging.jmq.jmsserver.util.*;
import com.sun.messaging.jmq.io.*;
import com.sun.messaging.jmq.jmsserver.core.*;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.*;

public class GetInterestUpdateHandler extends GPacketHandler {
    public static boolean DEBUG = false;

    public GetInterestUpdateHandler(RaptorProtocol p) {
        super(p);
    }

    public void handle(BrokerAddress sender, GPacket pkt) {
        if (DEBUG)
            logger.log(logger.DEBUG, "GetInterestUpdateHandler");

        if (pkt.getType() == ProtocolGlobals.G_GET_INTEREST_UPDATE) {
            handleGetInterestUpdate(sender, pkt);
        }
        else if (pkt.getType() ==
            ProtocolGlobals.G_GET_INTEREST_UPDATE_REPLY) {
            handleGetInterestUpdateReply(sender, pkt);
        }
        else {
            logger.log(logger.WARNING, "GetInterestUpdateHandler " +
                "Internal error : Cannot handle this packet :" +
                pkt.toLongString());
        }
    }

    public void handleGetInterestUpdate(BrokerAddress sender, GPacket pkt) {
        p.receiveGetInterestUpdate(sender);

        if (pkt.getBit(pkt.A_BIT)) {
            GPacket gp = GPacket.getInstance();
            gp.setType(ProtocolGlobals.G_GET_INTEREST_UPDATE_REPLY);
            gp.putProp("S", new Integer(ProtocolGlobals.G_SUCCESS));

            try {
                c.unicast(sender, gp);
            }
            catch (IOException e) {}
        }
    }

    public void handleGetInterestUpdateReply(BrokerAddress sender,
        GPacket pkt) {
        logger.log(logger.DEBUG,
            "MessageBus: Received G_GET_INTEREST_UPDATE_REPLY " +
            "from {0} : STATUS = {1}",
            sender, ((Integer) pkt.getProp("S")));
    }
}


/*
 * EOF
 */
