/*
 * @(#)GoodbyeHandler.java	1.5 08/08/05
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import java.io.*;
import java.util.Hashtable;
import com.sun.messaging.jmq.util.*;
import com.sun.messaging.jmq.jmsserver.util.*;
import com.sun.messaging.jmq.io.*;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.*;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.*;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;

public class GoodbyeHandler extends GPacketHandler {
    public static boolean DEBUG = false;

    public GoodbyeHandler(RaptorProtocol p) {
        super(p);
    }

    public void handle(BrokerAddress sender, GPacket pkt) {
        if (pkt.getType() == ProtocolGlobals.G_GOODBYE) {
            handleGoodbye(sender, pkt);
        }
        else if (pkt.getType() == ProtocolGlobals.G_GOODBYE_REPLY) {
            handleGoodbyeReply(sender, pkt);
        }
        else {
            logger.log(logger.WARNING, br.E_INTERNAL_BROKER_ERROR,
                       "Cannot handle this packet :" + pkt.toLongString());
        }
    }

    public void handleGoodbye(BrokerAddress sender, GPacket pkt) {
         
        try {
            ClusterGoodbyeInfo cgi = ClusterGoodbyeInfo.newInstance(pkt, c);
            p.goodbyeReceived(sender, cgi);
            p.sendGoodbye(sender);
            cbDispatcher.processGoodbye(sender, cgi);
            if (cgi.needReply()) {
                GPacket gp = cgi.getReplyGPacket(ProtocolGlobals.G_SUCCESS);
                try {
                c.unicastAndClose(sender, gp);
                p.goodbyeReplySent(sender);
                } catch (IOException e) {
                  logger.logStack(logger.WARNING, 
                    Globals.getBrokerResources().getKString(
                    BrokerResources.W_CLUSTER_UNICAST_FAILED, 
                    ProtocolGlobals.getPacketTypeDisplayString(gp.getType()), sender), e);  
                }
            }
        }
        catch (Exception e) {
            logger.logStack(logger.INFO, br.E_INTERNAL_BROKER_ERROR,
                            "Unable to process packet: " + pkt, e);
            return;
        }
    }

    public void handleGoodbyeReply(BrokerAddress sender, GPacket pkt) {
        cbDispatcher.processGoodbyeReply(sender);
        p.goodbyeReplyReceived(sender);
    }

}
