/*
 * @(#)MessageDataHandler.java	1.13 06/22/05
 *
 * Copyright 2003-2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import java.io.*;
import java.util.*;
import com.sun.messaging.jmq.util.*;
import com.sun.messaging.jmq.util.log.*;
import com.sun.messaging.jmq.io.*;
import com.sun.messaging.jmq.jmsserver.util.*;
import com.sun.messaging.jmq.jmsserver.util.lists.*;
import com.sun.messaging.jmq.jmsserver.core.*;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.*;
import com.sun.messaging.jmq.jmsserver.multibroker.MessageBusCallback;

public class MessageDataHandler extends GPacketHandler {
    public static boolean DEBUG = false;

    public MessageDataHandler(RaptorProtocol p) {
        super(p);
    }

    public void handle(MessageBusCallback cb, BrokerAddress sender, GPacket gp) {
        if (DEBUG)
            logger.log(logger.DEBUG, "MessageDataHandler");

        if (gp.getType() == ProtocolGlobals.G_MESSAGE_DATA) {
            handleMessageData(cb, sender, gp);
        }
        else if (gp.getType() == ProtocolGlobals.G_MESSAGE_DATA_REPLY) {
            handleMessageDataReply(sender, gp);
        }
        else {
            logger.log(logger.WARNING, "MessageDataHandler " +
                "Internal error : Cannot handle this packet :" +
                gp.toLongString());
        }
    }

    public void handleMessageData(MessageBusCallback cb, BrokerAddress sender, GPacket pkt) {

        ClusterMessageInfo cmi =  ClusterMessageInfo.newInstance(pkt, c);
        boolean sendMsgDeliveredAck = cmi.getSendMessageDeliveredAck();

        ArrayList cuidVector = new ArrayList();

        Packet roPkt;

        if (DEBUG) {
            logger.log(logger.DEBUGMED, "MessageBus: receiving message.");
        }


        try {
            cmi.initPayloadRead();
            Iterator itr = cmi.readPayloadConsumerUIDs();
            while (itr.hasNext()) {
                ConsumerUID intid = (ConsumerUID)itr.next();
                cuidVector.add(intid);
            }
            roPkt = cmi.readPayloadMessage();
            BrokerAddress home = cmi.getHomeBrokerAddress();
            if (home ==  null) home = sender;
            cb.processRemoteMessage(roPkt, cuidVector, home, sendMsgDeliveredAck);
        } catch (Exception e) {
            logger.log(logger.ERROR,"Internal Exception, unable to process message " +
                       pkt, e);
        }

        if (cmi.needReply()) {
            try {
                c.unicast(sender, cmi.getReplyGPacket(ProtocolGlobals.G_SUCCESS));
            }
            catch (IOException e) {}
        }
    }


    public void handleMessageDataReply(BrokerAddress sender, GPacket gp) {
        logger.log(logger.DEBUG,
"MessageBus: Received reset G_MESSAGE_DATA_REPLY from {0} : STATUS = {1}",
            sender, ((Integer) gp.getProp("S")));
    }
}


/*
 * EOF
 */
