/*
 * @(#)PingHandler.java	1.2 08/30/05
 *
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import java.io.*;
import com.sun.messaging.jmq.util.*;
import com.sun.messaging.jmq.jmsserver.util.*;
import com.sun.messaging.jmq.io.*;
import com.sun.messaging.jmq.jmsserver.core.*;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.*;

public class PingHandler extends GPacketHandler {
    public static boolean DEBUG = false;

    public PingHandler(RaptorProtocol p) {
        super(p);
    }

    public void handle(BrokerAddress sender, GPacket pkt) {
        if (pkt.getType() == ProtocolGlobals.G_PING) {
            if (DEBUG) {
                logger.log(logger.DEBUG, "Received PING from: "+ sender);
            }

            if (pkt.getBit(pkt.A_BIT)) {
                GPacket gp = GPacket.getInstance();
                gp.setType(ProtocolGlobals.G_PING_REPLY);
                gp.putProp("S", new Integer(ProtocolGlobals.G_SUCCESS));

                try {
                    c.unicast(sender, gp);
                }
                catch (IOException e) {}
            }
        }
        else if (pkt.getType() == ProtocolGlobals.G_PING_REPLY) {
            logger.log(logger.DEBUG,
                "PingHandler. G_PING_REPLY from : " + sender);
        }
        else {
            logger.log(logger.WARNING, "PingHandler " +
                "Internal error : Cannot handle this packet :" +
                pkt.toLongString());
        }
    }
}


/*
 * EOF
 */
