/*
 * @(#)ReloadClusterHandler.java	1.1 06/16/03
 *
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import java.io.*;
import com.sun.messaging.jmq.util.*;
import com.sun.messaging.jmq.jmsserver.util.*;
import com.sun.messaging.jmq.io.*;
import com.sun.messaging.jmq.jmsserver.core.*;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.*;

public class ReloadClusterHandler extends GPacketHandler {
    public static boolean DEBUG = false;

    public ReloadClusterHandler(RaptorProtocol p) {
        super(p);
    }

    public void handle(BrokerAddress sender, GPacket pkt) {
        if (pkt.getType() == ProtocolGlobals.G_RELOAD_CLUSTER) {
            if (DEBUG) {
                logger.log(logger.DEBUG,
"MessageBus: Received reset cluster notification from {0}.",
                    sender);
            }

            if (pkt.getBit(pkt.A_BIT)) {
                GPacket gp = GPacket.getInstance();
                gp.setType(ProtocolGlobals.G_RELOAD_CLUSTER_REPLY);
                gp.putProp("S", new Integer(ProtocolGlobals.G_SUCCESS));

                try {
                    c.unicast(sender, gp);
                }
                catch (IOException e) {}
            }

            c.reloadCluster();
        }
        else if (pkt.getType() == ProtocolGlobals.G_RELOAD_CLUSTER_REPLY) {
            logger.log(logger.DEBUG,
"MessageBus: Received reset cluster reply from {0} : STATUS = {1}",
                sender, ((Integer) pkt.getProp("S")));
        }
        else {
            logger.log(logger.WARNING, "ReloadClusterHandler " +
                "Internal error : Cannot handle this packet :" +
                pkt.toLongString());
        }
    }
}


/*
 * EOF
 */
