/*
 * @(#)TakeoverCompleteHandler.java	1.3 08/08/05
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import java.io.*;
import java.util.Hashtable;
import com.sun.messaging.jmq.util.*;
import com.sun.messaging.jmq.jmsserver.util.*;
import com.sun.messaging.jmq.io.*;
import com.sun.messaging.jmq.jmsserver.core.*;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.*;

public class TakeoverCompleteHandler extends GPacketHandler {
    public static boolean DEBUG = false;

    public TakeoverCompleteHandler(RaptorProtocol p) {
        super(p);
    }

    public void handle(BrokerAddress sender, GPacket pkt) {
        if (pkt.getType() == ProtocolGlobals.G_TAKEOVER_COMPLETE) {
            if (!Globals.getHAEnabled()) {
            logger.log(logger.ERROR, BrokerResources.E_INTERNAL_BROKER_ERROR, 
                       "Received Unexpected TAKEOVER_COMPLETE from "+sender);
            return;
            }

            handleTakeoverComplete(sender, pkt);
        }
        else {
            logger.log(logger.ERROR,  BrokerResources.E_INTERNAL_BROKER_ERROR,
                       "Cannot handle this packet :" + pkt.toLongString());
        }
    }

    public void handleTakeoverComplete(BrokerAddress sender, GPacket pkt) {
        ClusterTakeoverInfo cti = ClusterTakeoverInfo.newInstance(pkt);
         
        try {
            p.receivedTakeoverComplete(sender, cti);
        }
        catch (Exception e) {
            logger.logStack(logger.INFO, BrokerResources.E_INTERNAL_BROKER_ERROR,
                            "Unable to process packet: " + pkt, e);
            return;
        }
    }

}
