/*
 * @(#)StoreInfo.java	1.4 03/31/05
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 */

package com.sun.messaging.jmq.jmsserver.persist;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.*;

/**
 * A utility class for printing usage information of the persistence store.
 * Should be used when the broker is not running.
 */

public class StoreInfo {

    /**
     * Initiate the Globals using the passed in properties.
     * Instantiate a singleton Store instance using StoreManager.getStore().
     * Generate two messages to be used for testing.
     */
    public static void main(String args[]) throws Exception {

        Globals.init(System.getProperties(), false);
	Store store = StoreManager.getStore();

	if (args.length > 0 && args[0].equals("-cleanup")) {
	    store.close();
	} else {
	    store.close(false);
	}
    }
}

