/*
 * @(#)MsgStore200.java	1.4 06/19/03
 *
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.util.*;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.persist.Store;

import java.io.*;
import java.util.*;

/**
 * MsgStore200 is a simple class to load and return messages and the
 * associated interest lists from a version 200 message store.
 *
 * A version 200 message store is
 * - a directory of files, one message per file with numeric file names
 *
 * usage:
 * MsgStore200 oldmsgstore = new MsgStore200(File msgdir);
 * while (oldmsgstore.hasMoreMessages()) {
 *     Packet msg = oldmsgstore.nextMessage();
 *     ConsumerUID[] iids = oldmsgstore.nextCUIDs();
 *     int[] states = oldmsgstore.nextStates();
 *
 *     // do something with the message and it's interest list
 * }
 * oldmsgstore.close();
 *
 * @version	1.4
 */
class MsgStore200 extends RandomAccessStore {

    // if hasMoreMessages() returns true, the following variables
    // holds the next message and it's interest list
    private Packet msgToReturn = null;
    private ConsumerUID[] iidsToReturn = null;
    private int[] statesToReturn = null;

    private Enumeration msgenum = null;

    // accept everything
    private static FilenameFilter filenameFilter = new FilenameFilter() {
	public boolean accept(File dir, String name) {
	    return true;
	}
    };

    /**
     * When instantiated, all messages are loaded.
     */
    MsgStore200(File msgDir) throws BrokerException {

	super(msgDir, 0, 0, 0);
	msgenum = getEnumeration(false);	// false->not peekonly

	if (Store.DEBUG) {
	    logger.log(logger.DEBUG, "Loading version 200 message store");
	}
    }

    //
    //  Implement Enumeration methods
    //
    boolean hasMoreMessages() {
	return msgenum.hasMoreElements();
    }

    Packet nextMessage() {
	return msgToReturn;
    }

    ConsumerUID[] nextCUIDs() {
	return iidsToReturn;
    }

    int[] nextStates() {
	return statesToReturn;
    }

    // implement super class abstract method
    /**
     * parse the message and it's associated interest list from
     * the given buffers.
     * Returns the sysMessageID.
     */
    Object parseData(byte[] data, byte[] attachment) throws IOException {

	// parse message
	ByteArrayInputStream bais = new ByteArrayInputStream(data);
	msgToReturn = new Packet(false);
        msgToReturn.generateTimestamp(false);
        msgToReturn.generateSequenceNumber(false);
	msgToReturn.readPacket(bais);
	bais.close();

	int size = 0;
	// parse interest list
	if (attachment != null && attachment.length > 0) {

	    ByteArrayInputStream bis = new ByteArrayInputStream(attachment);
	    DataInputStream dis = new DataInputStream(bis);

	    // read in number of entries
	    size = dis.readInt();
	    iidsToReturn = new ConsumerUID[size];
	    statesToReturn = new int[size];

	    for (int i = 0; i < size; i++) {
		iidsToReturn[i] = new ConsumerUID(dis.readLong()); 
		statesToReturn[i] = dis.readInt();
	    }
	    dis.close();
	    bis.close();
	}

	SysMessageID mid = msgToReturn.getSysMessageID();

	if (Store.DEBUG) {
	    logger.log(logger.DEBUG,
		"loaded " + mid + " with " + size + " interest states");
	}

	return mid;
    }

    // print out informational message
    protected void close() {
	super.close(true);
    }

    FilenameFilter getFilenameFilter() {
	return filenameFilter;
    }
}

