/*
 * @(#)OracleDAOFactory.java	1.2 06/17/05
 *
 * Copyright 2004 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.util.BrokerException;

/**
 * Factory for Oracle implementation of DAO object.
 *
 * @version	1.2
 */
public class OracleDAOFactory extends GenericDAOFactory {

    public MessageDAO getMessageDAO() throws BrokerException {

        if ( messageDAO == null ) {
            messageDAO = new OracleMessageDAOImpl();
        }
        return messageDAO;
    }
}
