/*
 * @(#)DataEnumeration.java	1.1 03/07/01
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.persist.util;

import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.util.*;

/**
 * DataEnumeration represent an enumeration of some types of data.
 *
 * @version	1.1
 */
public class DataEnumeration implements Enumeration {

    private EnumerationStore store;
    private Object[] ids;
    private int index = 0;
    private Object next = null;

    public DataEnumeration(EnumerationStore store, Object[] ids) {
	if (ids == null)
	    ids = new Object[0];

	this.store = store;
	this.ids = ids;
    }

    public boolean hasMoreElements() {
	if (index >= ids.length)
	    return false;

	for (; index < ids.length && next == null; index++) {
	    try {
		next = store.getData(ids[index]);
	    } catch (BrokerException e) {
		// get as much as we can
		next = null;
	    }
	}

	if (next != null)
	    return true;
	else
	    return false;
    }

    public Object nextElement() {
	Object data = next;
	if (data != null) {
	    next = null;
	    return data;
	} else {
	    throw new NoSuchElementException();
	}
    }
}

