package com.sun.messaging.jmq.jmsserver.service.imq.group;

import java.util.*;
import java.io.*;
import java.nio.channels.spi.*;
import java.nio.channels.*;
import com.sun.messaging.jmq.util.log.*;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.service.imq.*;
import com.sun.messaging.jmq.jmsserver.resources.*;
import com.sun.messaging.jmq.jmsserver.service.*;
import com.sun.messaging.jmq.jmsserver.util.pool.*;


class ReadThread extends SelectThread
{
    int selector_cnt = 0;

    public ReadThread(Service svc, MapEntry entry) 
        throws IOException
    {
        super(svc, entry);

        type = "read";
        INITIAL_KEY=SelectionKey.OP_READ; // none
        POSSIBLE_MASK=SelectionKey.OP_READ; // none
    } 

    public Hashtable getDebugState() {
        Hashtable ht = new Hashtable();
        ht.put("TYPE", "ReadThread");
        ht.put("selector_cnt", new Integer(selector_cnt));
        return ht;
    }


    protected void wakeup() {
        Selector s = selector;
        if (s != null)
            s.wakeup();
    }

    protected void process() 
        throws IOException
    {
       Selector s = selector;
       if (s == null)
          throw new IOException("connection gone");
       int cnt =  0;
       try {
          cnt = s.select(TIMEOUT);
       } catch (java.nio.channels.CancelledKeyException ex) {
         // bug 4944894
         // nio can throw the cancelledKeyException all the
         // way up in some cases, this does not indicate that
         // the selector is closed so the broker should ignore
         // the issue

          return;
       }
       if (cnt > 0) {
           Set keys = s.selectedKeys();
           Iterator keyitr = keys.iterator();
           while (keyitr.hasNext()) {
               SelectionKey key = (SelectionKey)keyitr.next();
               IMQConnection con = (IMQConnection)key.attachment();
               try {
                   int result =  con.readData();
                   // triggers bug 4708106
                   //if (result == Operation.PROCESS_WRITE_INCOMPLETE) {
                       keyitr.remove();
                   //}
               } catch (IOException ex) {
                   String reason = (con.getDestroyReason() == null ?
                        (ex instanceof EOFException ? 
                            Globals.getBrokerResources().getKString(
                    BrokerResources.M_CONNECTION_CLOSE) 
                       : ex.toString()) : con.getDestroyReason());
                   removeConnection(con, reason);
                   keyitr.remove();
               }
           }
       }
    }

}
