/*
 * @(#)KeystoreUtil.java	1.1 07/25/05
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.util;

import java.io.IOException;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.resources.*;
import com.sun.messaging.jmq.util.StringUtil;
import com.sun.messaging.jmq.util.Password;

public class KeystoreUtil {
    public final static String
        KEYSTORE_DIR_PROP          = Globals.IMQ + ".keystore.file.dirpath",
        KEYSTORE_FILE_PROP         = Globals.IMQ + ".keystore.file.name",
        KEYSTORE_PASSWORD_PROP     = Globals.IMQ + ".keystore.password";

    private static String keystore_location = null;
    private static String pass_phrase = null;

    protected static BrokerResources br = Globals.getBrokerResources();

    public static void clear() {
        keystore_location = null;
        String pass_phrase = null;
    }

    public static String getKeystoreLocation() throws IOException {
	if (keystore_location == null)  {
	    BrokerConfig bcfg;
	    bcfg = Globals.getConfig();	    	    

            // Get Keystore Location and  Passphrase here .....
	    
            String dir, file, value, pf_dir, pf_file, pf_value, file_sep;
	    
            file_sep = System.getProperty("file.separator");
	    
            // Get Keystore location by getting the directory and the name
            // of the keystore file.

            if ((value = bcfg.getProperty(KEYSTORE_DIR_PROP)) != null) {
                value = StringUtil.expandVariables(value, bcfg);
                dir = value;
            } else {
                dir = bcfg.getProperty(Globals.IMQ + ".varhome") +
                file_sep + "security";
            }
	    
            keystore_location = dir + file_sep
			+ bcfg.getProperty(KEYSTORE_FILE_PROP);
	
	}

	return (keystore_location);
    }

    public static String getKeystorePassword() throws IOException {
	if (pass_phrase == null)  {
	    BrokerConfig bcfg;
       	    Password pw = null;

	    bcfg = Globals.getConfig();	    	    

            // Get Passphrase from property setting 
            pass_phrase = bcfg.getProperty(KEYSTORE_PASSWORD_PROP);
            // if passphrase is null then get it thro' user interaction
            int retry = 0;
            pw = new Password();
            while ((pass_phrase == null || pass_phrase.equals("")) &&
                retry <= 5) {

                System.err.print(br.getString(
                    BrokerResources.M_ENTER_KEY_PWD,
                    getKeystoreLocation()));
                    System.err.flush();

                if (Broker.getBroker().background) {
                    // We're running in the background and can't
                    // read the password. We still prompt for it
                    // so it's more obvious what's going on
                    // (instead of just silently failing)
                    // See 4451214
                    System.err.print("\n");
                    break;
                }

                pass_phrase = pw.getPassword();
    
                // Limit the number of times we try reading the passwd.
                // If the VM is run in the background the readLine()
                // will always return null and we'd get stuck
                // in the loop
                retry++;
            }
        }
	
	return (pass_phrase);
    }
}
