/*
 * @(#)LoggerManager.java	1.3 02/13/02
 *
 * Copyright 2002 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */


package com.sun.messaging.jmq.jmsserver.util;

import java.util.*;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.resources.*;
import com.sun.messaging.jmq.jmsserver.config.*;

/**
 * Handle dynamically updating the Logger with property changes. This
 * isn't done directly by logger since it is in jmq.util and doesn't
 * know about ConfigListeners.
 */
public class LoggerManager implements ConfigListener
{
    Logger logger = null;
    BrokerConfig config = null;

    public LoggerManager(Logger logger, BrokerConfig config) {
        this.logger = logger;
        this.config = config;

        // Register ourself as the config listener for all properties
        // that the logger can updated dynamically
        String[] props = logger.getUpdateableProperties();
        for (int n = 0; n < props.length; n++) {
            config.addListener(props[n], this);
        }
    }

    public void validate (String name, String value)
        throws PropertyUpdateException {

        // Validate does the update as well. Yuck.
        try {
            logger.updateProperty(name, value);
        } catch (IllegalArgumentException e) {
            throw new PropertyUpdateException(e.getMessage());
        }

    }

    public boolean update (String name, String value) {
        return true;
    }
}
