/*
 * @(#)PacketCompare.java	1.6 06/19/03
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.util;

import java.util.*;
import com.sun.messaging.jmq.io.*;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
/**
 * class which sorts messages based on time/sequence.
 * After sorting with this comparator, messages from a
 * single session are in the order received. It does
 * no guarentee order of message from different sessions
 * (which is OK per spec)
 */

public class PacketCompare implements Comparator
{
    // NOTE .. since messages from different sessions
    // DONT have a global order .. dont worry about connectionID
    // (the order outside of timestamp, sequence doesnt matter)

    public int compare(Object o1, Object o2)
    {
        if (!(o1 instanceof Packet 
               || o1 instanceof PacketReference) || 
             !(o2 instanceof Packet
               || o2 instanceof PacketReference))
            return (o1.hashCode() - o2.hashCode());

        long time1 = (o1 instanceof Packet) ? 
              ((Packet)o1).getTimestamp() :
              ((PacketReference)o1).getTimestamp();

        long time2 = (o2 instanceof Packet) ? 
              ((Packet)o2).getTimestamp() :
              ((PacketReference)o2).getTimestamp();

        long dif = time2 -time1;
        if (dif == 0) {
            long seq1 = (o1 instanceof Packet) ? 
                  ((Packet)o1).getSequence() :
                  ((PacketReference)o1).getSequence();

            long seq2 = (o2 instanceof Packet) ? 
                  ((Packet)o2).getSequence() :
                  ((PacketReference)o2).getSequence();

            dif = seq2 -seq1;
        }
        if (dif < 0) return 1;
        if (dif > 0) return -1;
        return 0;
    }

    public boolean equals(Object o1)
    {
        return super.equals(o1);
    }

    public int hashCode() {
        return super.hashCode();
    }
}
