/*
 * @(#)Orange.java	1.6 04/16/03
 *
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */


package com.sun.messaging.jmq.jmsserver.util.memory.levels;

import com.sun.messaging.jmq.jmsserver.util.memory.*;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.*;
import com.sun.messaging.jmq.jmsserver.resources.*;
import com.sun.messaging.jmq.util.log.*;


public class Orange extends Yellow
{
    protected int GC_DEFAULT=5;
    protected int GC_ITR_DEFAULT=100;
    protected int MessageCount =0;
    protected int GCCount =0;
    protected int GCItrCount =0;

    public Orange(String name) {
        super(name);
        MEMORY_NAME_KEY = BrokerResources.M_MEMORY_ORANGE;
        MessageCount = Globals.getConfig().getIntProperty(
                         Globals.IMQ + "." + name + ".count", 1);
        GCCount = Globals.getConfig().getIntProperty(
                         Globals.IMQ + "." + name + ".gccount", GC_DEFAULT);
        GCItrCount = Globals.getConfig().getIntProperty(
                         Globals.IMQ + "." + name + ".gcitr", GC_ITR_DEFAULT);
    }

    public int getMessageCount(long freeMem, int producers) {
        return MessageCount; // 1
    }

    public long getMemory(long freeMemory, int producers) {
        if (producers >=0) producers = 1; // dont divide by 0
        return (freeMemory - MAX_MEMORY_DELTA) / producers/2;
    }

    public int gcCount() {
        return GCCount;
    }

    public int gcIteration() {
        return GCItrCount;
    }

    public boolean cleanup(int cnt) {
        super.cleanup(cnt);
        return true;
    }

    public boolean enter(boolean fromHigher) {
        super.enter(fromHigher);

        if (fromHigher) return false;

        MemoryGlobals.MEM_FREE_P_NOCON = true;
        MemoryGlobals.MEM_EXPLICITLY_CHECK = true;

        return true; // change cnt/etc
    }

    public boolean leave(boolean toHigher)  {
        super.leave(toHigher);
        if (toHigher) {
            // moving to a new level, dont do anything
            return false;
        }
        // otherwise, reset to previous state
        // memory state varialbles

        MemoryGlobals.MEM_FREE_P_NOCON = false;
        MemoryGlobals.MEM_EXPLICITLY_CHECK = false;

        return false; // dont bother to tell the client that the
                      // counts have changed -> it will fix itsself
    }


}

/*
 * EOF
 */
