/*
 * @(#)MQRMIClientSocketFactory.java	1.3 08/10/05
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.management;

import java.io.IOException;
import java.net.Socket;

import java.rmi.server.RMISocketFactory;

import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.rmi.ssl.SslRMIClientSocketFactory;

public class MQRMIClientSocketFactory extends SslRMIClientSocketFactory {
    boolean debug = false;
    boolean isBrokerHostTrusted = true;
    boolean useSSL = false;
    String hostname = null;

    public MQRMIClientSocketFactory(String hostname, boolean isBrokerHostTrusted,
					boolean useSSL)  {
	this.isBrokerHostTrusted = isBrokerHostTrusted;
	this.hostname = hostname;
	this.useSSL = useSSL;
    }

    public Socket createSocket(String host, int port) throws IOException {
	Socket s = null;
	String socketHost = hostname;

	/*
	 * If the factory is not configured for any specific host, use whatever
	 * is passed in to createSocket.
	 *
	 * The wildcard "*" here is something that could be set on the server
	 * side. It is the constant jmsserver.Globals.HOSTNAME_ALL but we don't
	 * want to introduce any server side compile time dependencies here.
	 * Remember that this factory is created by the server.
	 */
	if ((socketHost == null) || (socketHost.equals("*")))  {
	    socketHost = host;
	}

	try  {
	    if (useSSL)  {
	        s = (Socket)makeSSLSocket(socketHost, port);
	    } else  {
	        s = RMISocketFactory.getDefaultSocketFactory().
			createSocket(socketHost, port);
	    }
	} catch (Exception e)  {
	    throw new IOException(e.toString());
	}

	return (s);
    }

    public String toString()  {
        return ("hostname="
		+ hostname 
		+ ",isBrokerHostTrusted=" 
		+ isBrokerHostTrusted 
		+ ",useSSL=" 
		+ useSSL);
    }

    public boolean equals(Object obj)  {
        if (!(obj instanceof MQRMIClientSocketFactory))  {
            return (false);
        }
    
        MQRMIClientSocketFactory that = (MQRMIClientSocketFactory)obj;

        if (this.hostname != null)  {
            if ((that.hostname == null) || !that.hostname.equals(this.hostname))  {
                return (false);
            }
        } else  {
            if (that.hostname != null)  {
                return (false);
            }
        }

        if (this.isBrokerHostTrusted != that.isBrokerHostTrusted)  {
            return (false);
        }

        if (this.useSSL != that.useSSL)  {
            return (false);
        }

        return (true);
    }

    public int hashCode()  {
        return toString().hashCode();
    }

    private SSLSocket makeSSLSocket(String host, int port) throws Exception {
        SSLSocketFactory sslFactory;

        if (isBrokerHostTrusted) {
            sslFactory = getTrustSocketFactory();

            if ( debug ) {
                System.err.println("Broker is trusted ...");
            }
        } else {
            sslFactory = (SSLSocketFactory) SSLSocketFactory.getDefault();
        }

        //This is here for QA to verify that SSL is used ...
        if ( debug ) {
            System.err.println ("Create connection using SSL protocol ...");
            System.err.println ("Broker Host: " + host);
            System.err.println ("Broker Port: " + port);
        }

        SSLSocket sslSocket = (SSLSocket) sslFactory.createSocket (host, port);

        //tcp no delay flag
        boolean tcpNoDelay = true;
        String prop = System.getProperty("imqTcpNoDelay", "true");
        if ( prop.equals("false") ) {
            tcpNoDelay = false;
        } else {
            sslSocket.setTcpNoDelay(tcpNoDelay);
        }

        return sslSocket;
    }


    private SSLSocketFactory getTrustSocketFactory() throws Exception {
        SSLSocketFactory factory = null;

        SSLContext ctx;
        ctx = SSLContext.getInstance("TLS");
        TrustManager[] tm = new TrustManager [1];
        tm[0] = new DefaultTrustManager();

        ctx.init(null, tm, null);
        factory = ctx.getSocketFactory();

        return factory;
    }

}
