/*
 * @(#)CacheHashMap.java	1.2 03/05/20
 *
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved.
 *
 */

package com.sun.messaging.jmq.util;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * A LinkedHashMap that is bounded by size. Once the HashMap is 
 * full, the oldest entry is discarded as new entries are added.
 *
 * @version @(#)CacheHashMap.java	1.2 03/05/20
 */
public class CacheHashMap extends LinkedHashMap {

    private static int DEFAULT_CAPACITY = 16;
    private int capacity = DEFAULT_CAPACITY;

    /**
     * Create a CacheHashMap with a the specified capacity 
     *
     * @param   capacity    Capacity of the CacheHashMap.
     */
    public CacheHashMap(int capacity) {
        super(capacity);
        this.capacity = capacity;
    }

    /**
     * Create a CacheHashMap with a default capacity (16)
     */
    public CacheHashMap() {
        this(DEFAULT_CAPACITY);
    }

    public int capacity() {
        return capacity();
    }

    protected boolean removeEldestEntry(Map.Entry eldest) {
        return size() > capacity;
    }

    public static void main(String args[]) {

        CacheHashMap c = new CacheHashMap(5);

        for (int i = 0; i < 10; i++) {
            c.put(new Long(i), new String("a" + i));
        }

        System.out.println(c);
    }
}
