/*
 * @(#)DestLimitBehavior.java	1.2 03/09/03
 *
 * Copyright 2002 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.util;


/**
 * Limiting behavior used by the destination when it 
 * becomes full.
 * <P>
 * <B>XXX</B> How should serialization be handled.
 *
 * @since 3.5
 */

public class DestLimitBehavior 
{
    public static final int UNKNOWN = -1;
    public static final int FLOW_CONTROL = 0;
    public static final int REMOVE_OLDEST = 1;
    public static final int REJECT_NEWEST = 2;
    public static final int REMOVE_LOW_PRIORITY = 3;

    public static int getStateFromString(String str) {
        if (str.equals("FLOW_CONTROL")) 
            return FLOW_CONTROL;
        if (str.equals("REMOVE_OLDEST")) 
            return REMOVE_OLDEST;
        if (str.equals("REJECT_NEWEST") )
            return REJECT_NEWEST;
        if (str.equals("REMOVE_LOW_PRIORITY")) 
            return REMOVE_LOW_PRIORITY;
        return UNKNOWN;
    }


    public static String getString(int state)
    {
        switch (state) {
            case FLOW_CONTROL:
                return "FLOW_CONTROL";

            case REMOVE_OLDEST:
                return "REMOVE_OLDEST";

            case REJECT_NEWEST:
                return "REJECT_NEWEST";

            case REMOVE_LOW_PRIORITY:
                return "REMOVE_LOW_PRIORITY";

        }
        return "UNKNOWN";

    }
}
