/*
 * @(#)DestScope.java	1.2 02/12/03
 *
 * Copyright 2002 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.util;


/**
 * Scope of a destination.
 * <P>
 * <B>XXX</B> How should serialization be handled.
 *
 * @since 3.5
 */

public class DestScope 
{
    public static final int UNKNOWN = -1;
    public static final int LOCAL = 0;
    public static final int CLUSTER = 1;
    /**
     * <B>Not supported in 3.5 </B>
     */
    public static final int DISTRIBUTED = 2;

    public static int getStateFromString(String str) {
        if (str.equals("LOCAL")) 
            return LOCAL;
        if (str.equals("CLUSTER")) 
            return CLUSTER;
        if (str.equals("DISTRIBUTED") )
            return DISTRIBUTED;
        return UNKNOWN;
    }


    public static String getString(int state)
    {
        switch (state) {
            case LOCAL:
                return "LOCAL";

            case CLUSTER:
                return "CLUSTER";

            case DISTRIBUTED:
                return "DISTRIBUTED";


        }
        return "UNKNOWN";

    }
}
