
/*
 * @(#)Event.java	1.2 12/18/03
 *
 * Copyright 2002 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.util.lists;

/**
 * Class which represents a event on a list which may
 * generate a notification.
 *
 * @deprecated since 3.0
 * @see EventBroadcaster
 */

public class Event extends java.util.EventObject
{

    /**
     * type of this event
     */
    protected EventType id;

    /**
     * original value before the event occured
     */
    protected Object original_value;

    /**
     * new value after the event occured
     */
    protected Object new_value;

    /**
     * reason the event occured
     */
    protected Reason reason;
    
    /**
     * create a new event without a reason
     */
    public Event(EventType id, Object target, Object original,
           Object newval) 
    {
        this(id, target, original, newval, null);
    }
    
    /**
     * create a new event with a reason
     */
    public Event(EventType id, Object target, Object original,
         Object newval, Reason reason) {
        super(target);
        this.id = id;
        this.reason = reason;
        this.original_value = original;
        this.new_value = newval;
    }
    
    /**
     * @returns the event type for this event
     */
    public EventType getEventType() {
        return id;
    }
   
    
    /**
     * @returns the original object for this event
     *  (may be null)
     */
    public Object getOriginalValue() {
        return original_value;
    }
    
    /**
     * @returns the current object for this event
     *  (may be null)
     */
    public Object getCurrentValue() {
        return new_value;
    }
    
    /**
     * @returns the reasont this event occured
     *  (may be null)
     */
    public Reason getReason() {
        return reason;
    }
    
    
    /**
     * string representation of this event
     * @returns the string of this object
     */
    public String toString() {
        return id.toString() + " target(" +
               getSource() + ") Reason(" +
               getReason() + ") [was,is]=[" +
          original_value + "," + new_value + "]";
    }

    /**
     * compares this object against another object
     * @param o the object to compare
     * @returns true if the objects are the same, false otherwise
     */
    public boolean equals(Object o) {
        // compares reference to the item
        return super.equals(o);
    }


}
