/*
 * @(#)PrefixMessages.java	1.1 01/03/21
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 *
 */

package com.sun.messaging.jmq.util.test;

import java.text.*;
import java.util.*;

/**
 * This class has a method that will take the Object[][] from a ListResourceBundle
 * and appends the given string to all the strings in the messages (not the keys).
 *
 * Notes:
 *   - All of the objects need to be strings<p>
 *
 * @version	1.1 01/03/21
 */

public class PrefixMessages {
    public static Object[][] createPrefixedMessages(Object[][] old, String prefix) {
        Object[][] newContents = new Object[ old.length ][2];

        // loop through and reverse the contents
        for( int i = 0; i < old.length; i++ ) {
            try {
	        newContents[i][0] = old[i][0];
		String tmp = (String)old[i][1];

		newContents[i][1] = prefix + tmp;
            } catch (Exception e)  {
	        System.err.println("Problem encountered when generating new messages. Index="
				+ i
				+ ".\n"
				+ e.toString());

	        // just copy over the originals
	        newContents[i][0] = old[i][0];
	        newContents[i][1] = old[i][1];
	    }
        }

	return (newContents);
    }
}
