
/*
 * @(#)BrokerState.java	1.3 05/10/14
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jms.management.server;

/**
 * Class containing information on broker states.
 *
 * @version     1.3 05/10/14
 * @author      Isa Hashim
 */
public class BrokerState implements java.io.Serializable  {
    /** 
     * Unknown broker state.
     */
    public static final int	     UNKNOWN			= -1;

    /**
     * A broker has started and is operating normally.
     */
    public static final int          OPERATING			= 0;

    /**
     * The broker has started to takeover another broker's message store.
     * This applies to brokers that are part of a HA cluster.
     * 
     */
    public static final int          TAKEOVER_STARTED		= 1;

    /**
     * The broker has completed the takeover another broker's message store.
     * This applies to brokers that are part of a HA cluster.
     */
    public static final int          TAKEOVER_COMPLETE		= 2;

    /**
     * The broker has failed in the attempt to takeover another broker's message store.
     * This applies to brokers that are part of a HA cluster.
     */
    public static final int          TAKEOVER_FAILED		= 3;

    /**
     * The broker has started to quiesce.
     */
    public static final int          QUIESCE_STARTED		= 4;

    /**
     * The broker has finished quiescing.
     */
    public static final int          QUIESCE_COMPLETE		= 5;

    /**
     * The broker is starting to shutdown (either immediately or after a specific grace
     * period) or restart
     */
    public static final int          SHUTDOWN_STARTED		= 6;

    /**
     * The broker is down.
     */
    public static final int          BROKER_DOWN		= 7;

    /*
     * Class cannot be instantiated
     */
    private BrokerState() {
    }

    public static String toString(int state)  {
	switch (state)  {
	case OPERATING:
	    return ("OPERATING");

	case TAKEOVER_STARTED:
	    return ("TAKEOVER_STARTED");

	case TAKEOVER_COMPLETE:
	    return ("TAKEOVER_COMPLETE");

	case TAKEOVER_FAILED:
	    return ("TAKEOVER_FAILED");

	case QUIESCE_STARTED:
	    return ("QUIESCE_STARTED");

	case QUIESCE_COMPLETE:
	    return ("QUIESCE_COMPLETE");

	case SHUTDOWN_STARTED:
	    return ("SHUTDOWN_STARTED");

	case BROKER_DOWN:
	    return ("BROKER_DOWN");

	default:
	    return ("UNKNOWN");
	}
    }
    
}
