
/*
 * @(#)DestinationOperations.java	1.5 06/01/23
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jms.management.server;

/**
 * Class containing information on destination operations.
 *
 * @version     1.5 06/01/23
 * @author      Isa Hashim
 */
public class DestinationOperations {
    /** 
     * Create a destination.
     */
    public static final String		CREATE = "create";

    /** 
     * Compact a destination.
     */
    public static final String		COMPACT = "compact";

    /** 
     * Destroy a destination
     */
    public static final String		DESTROY = "destroy";

    /** 
     * Get active consumers IDs
     */
    public static final String		GET_ACTIVE_CONSUMER_IDS = "getActiveConsumerIDs";

    /** 
     * Get backup consumers IDs
     */
    public static final String		GET_BACKUP_CONSUMER_IDS = "getBackupConsumerIDs";

    /** 
     * Get consumer IDs
     */
    public static final String		GET_CONSUMER_IDS = "getConsumerIDs";

    /** 
     * Get connection - relevant for temporary destinations only.
     */
    public static final String		GET_CONNECTION = "getConnection";

    /** 
     * Get list of destination MBean object names.
     */
    public static final String		GET_DESTINATIONS = "getDestinations";

    /** 
     * Get producer IDs
     */
    public static final String		GET_PRODUCER_IDS = "getProducerIDs";

    /** 
     * Pause a destination.
     */
    public static final String		PAUSE = "pause";

    /** 
     * Purge a destination.
     */
    public static final String		PURGE = "purge";

    /** 
     * Resume a destination.
     */
    public static final String		RESUME = "resume";

    /*
     * Class cannot be instantiated
     */
    private DestinationOperations() {
    }
    
}
