
/*
 * @(#)LogLevel.java	1.3 05/08/08
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jms.management.server;

/**
 * Class containing information on log levels
 *
 * @version     1.3 05/08/08
 * @author      Isa Hashim
 */
public class LogLevel {
    /** 
     * Unknown log level
     */
    public static final String UNKNOWN = "UNKNOWN";

    /** 
     * Log level that will allow messages indicating problems that could cause system failure
     * to be logged.
     */
    public static final String ERROR = "ERROR";

    /** 
     * Log level that will allow alerts that should be heeded (but will not cause system failure)
     * to be logged.
     */
    public static final String WARNING = "WARNING";

    /** 
     * Log level that will allow reporting of metrics and other informational messages
     * to be logged.
     */
    public static final String INFO = "INFO";

    /** 
     * Turn off logging.
     */
    public static final String NONE = "NONE";

    /*
     * Class cannot be instantiated
     */
    private LogLevel() {
    }
}
