
/*
 * @(#)ServiceNotification.java	1.3 05/08/08
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jms.management.server;

import javax.management.Notification;

/**
 * Class containing information on service notifications.
 *
 * <P>
 * The MQ specific fields in this notification is TBD.
 *
 * @version     1.3 05/08/08
 * @author      Isa Hashim
 */
public class ServiceNotification extends MQNotification  {
    /** 
     * A service was paused.
     */
    public static final String		SERVICE_PAUSE = MQNotification.PREFIX + "service.pause";

    /** 
     * A service was resumed.
     */
    public static final String		SERVICE_RESUME = MQNotification.PREFIX + "service.resume";

    /*
     * Service name
     */
    private String name = null;

    
    /**
     * Creates a ServiceNotification object.
     *
     * @param type		The notification type.
     * @param source		The notification source.
     * @param sequenceNumber	The notification sequence number within the source object.
     */
    public ServiceNotification(String type, Object source, long sequenceNumber) {
	super(type, source, sequenceNumber);
    }

    public void setServiceName(String serviceName)  {
	name = serviceName;
    }
    public String getServiceName()  {
	return (name);
    }
    
}
