
/*
 * @(#)ServiceState.java	1.3 05/09/15
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jms.management.server;

/**
 * Class containing information on service states.
 *
 * @version     1.3 05/09/15
 * @author      Isa Hashim
 */
public class ServiceState {
    /** 
     * Unknown service state.
     */
    public static final int UNKNOWN = -1;

    /**
     * Service is up and running.
     */
    public static final int RUNNING = 0;

    /**
     * Service is paused.
     */
    public static final int PAUSED = 1;

    /**
     * Service is quiesced.
     */
    public static final int QUIESCED = 2;


    /*
     * Class cannot be instantiated
     */
    private ServiceState() {
    }
    
    /**
     * Returns a string representation of the specified service state.
     *
     * @param state Service state.
     * @return String representation of the specified service state.
     */
    public static String toString(int state)  {
        switch (state) {
            case RUNNING:
                return "RUNNING";

            case PAUSED:
                return "PAUSED";

            case QUIESCED:
                return "QUIESCED";

	    default:
                return "UNKNOWN";
        }
    }
}
