/*
 * @(#)ConnectionReconnectedEvent.java	1.1 05/03/15
 *
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */
package com.sun.messaging.jms.notification;

import com.sun.messaging.jms.Connection;
import com.sun.messaging.jmq.jmsclient.resources.ClientResources;

/**
 * MQ Connection Reconnected Event is generated and delivered to the event
 * listener if the MQ client runtime reconnected to a broker and an event
 * listener is set to the MQ connection.
 * <p>
 * The application can obtain the current broker's address from the API
 * provided.
 *
 *
 * @author chiaming yang
 * @version 4.0
 */
public class ConnectionReconnectedEvent extends ConnectionEvent {

    /**
     * Connection reconnected event code.
     */
    public static final String CONNECTION_RECONNECTED =
                  ClientResources.E_CONNECTION_RECONNECTED;


    /**
     * Connection reconnect event code - reconnected to the same broker.
     */
    //public static final String CONNECTION_RECONNECTED_SAME_BROKER =
    //              ClientResources.E_CONNECTION_RECONNECTED_SAME_BROKER;
    /**
     * Connection reconnect event code - reconnected to a different broker.
     */
    //public static final String CONNECTION_RECONNECTED_DIFF_BROKER =
    //              ClientResources.E_CONNECTION_RECONNECTED_DIFF_BROKER;

    /**
     * Construct a connection reconnect event.
     *
     * @param conn the connection associated with this event object.
     * @param evCode the event code that represents this event object.
     * @param evMessage the event message that describes this event object.

     */
    public ConnectionReconnectedEvent
        (Connection conn, String evCode, String evMessage) {

        super (conn, evCode, evMessage);
    }

}
