/*
 * @(#)Event.java	1.1 05/03/15
 *
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */
package com.sun.messaging.jms.notification;

/**
 * MQ Event.  This is the super class for all MQ notification
 * events. MQ may notify an application when a specific MQ event is
 * about to occur or occurred.
 * <p>
 *
 * @author chiaming yang
 * @version 4.0
 */
public class Event extends java.util.EventObject {

    /**
     * MQ event code.
     */
    private String eventCode = null;

    /**
     * MQ event message.  An event message describes a MQ specific event.
     */
    private String eventMessage = null;

    /**
     * Construct a MQ event associated with the source specified.
     *
     * @param source the source associated with the event.
     * @param evCode the event code that represents the this event object.
     * @param evMessage the event message that describes this event object.
     */
    public Event (Object source, String evCode, String evMessage) {
        super (source);

        this.eventCode = evCode;
        this.eventMessage = evMessage;
    }

    /**
     * Get the event code associated with the MQ event.
     * @return the event code associated with the MQ event.
     */
    public String getEventCode() {
        return this.eventCode;
    }

    /**
     * Get the event message associated with the connection event.
     * @return the event message associated with the connection event.
     */
    public String getEventMessage() {
        return this.eventMessage;
    }

    /**
    * Returns a MQ event notification event message.  The format is as follows.
    * <p>
    * eventCode + ":" + eventMessage + ", " + source=" + source.toString().
    *
    * @return a String representation of this EventObject.
    */
    public String toString() {
        return this.getEventCode() + ":" + this.getEventMessage() + ", " +
            super.toString();
    }
}
