/*
 * @(#)UnsupportedVersionNumberException.java	1.3 02/02/13
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.naming;

/** 
 * An <code>UnsupportedVersionNumberException</code> is thrown when the
 * <code>getInstance()</code> method of <code>AdministeredObjectFactory</code>
 * finds a Version number for an unsupported format of a iMQ Administered
 * Object in the Reference object.
 *  
 * @see com.sun.messaging.naming.AdministeredObjectFactory com.sun.messaging.naming.AdministeredObjectFactory
 * 
 * @version 1.3 02/02/13 
 * @author George Tharakan 
 */

public class UnsupportedVersionNumberException extends javax.naming.NamingException {

    /**
     * Constructs an UnsupportedVersionNumberException.
     *
     * @param version The unsupported version number that was found.
     */
    public UnsupportedVersionNumberException(String version) {
	super(version);
    }
}

