#!/bin/sh
#
# @(#)imqinit.sh	1.16 01/04/06
#
# Copyright 2003 Sun Microsystems, Inc. All Rights Reserved
# SUN PROPRIETARY/CONFIDENTIAL
# Use is subject to license terms. 
#
# Common initialization script used by all imq wrapper scripts.
# After this script runs the following local shell variables
# are defined (they are not exported):
#
# imq_javahome      Location of Java to use. Calling script must still check
#                   for -javahome command line argument which should override
#                   this value.
#
# imq_javareason    Where the value for javahome came from
#
# We have all of these variables because of the bundled Solaris installation
# which spreads Message Queue out across the disk:
# imq_home              Root of Message Queue installation
# imq_etchome           Root of etc subtree
# imq_libhome           Root of lib subtree
# imq_sharelib_home     Root of share/lib subtree
# imq_sharelibmq_home   Root of share/lib/mq subtree
# imq_varhome           Root of var subtree
#
# imq_servervm      "-server" If the server JVM is available, else ""
# imq_os            Value of `uname`. SunOS or Linux
# imq_osver         Value of `uname -r`.
# imq_proc          Processor type: i386 or sparc
#
# imq_installtype   Destcription of installation type

#
# Check if a server version of the VM is available
#
check_for_servervm() {
PLATFORM=`uname`
    # If the server version of the VM is there use it
#####hpux-dev#####
if [ "$PLATFORM" = HP-UX ] ; then
    if [ -f $imq_javahome/jre/lib/PA_RISC2.0/server/libjvm.sl ] ; then
       imq_servervm=-server
    fi
else
    if [ -f $imq_javahome/jre/lib/"$imq_proc"/server/libjvm.so ] ||
       [ -f $imq_javahome/lib/"$imq_proc"/server/libjvm.so ]; then
	imq_servervm=-server
    fi
fi
}

#
# Search the OS for J2SE in the standard locations. This sets
# the default location for a platform.
#
#####hpux-dev#####
findj2se() {

    case "$imq_os" in
    SunOS)
        if [ "$imq_osver" = "5.9" -o "$imq_osver" = "5.8" -o "$imq_osver" = "5.7" ];  then
            _j2se_locations="\
/usr/jdk/entsys-j2se \
/usr/jdk/latest \
/usr/jdk/jdk1.5.* \
/usr/jdk/j2sdk1.5.* \
/usr/j2se \
"
        else
            # Solaris 10 or newer. /usr/java points to 1.5
            _j2se_locations="\
/usr/jdk/entsys-j2se \
/usr/java \
/usr/jdk/latest \
/usr/j2se \
"
        fi
        ;;

    Linux)
        _j2se_locations="\
/usr/jdk/entsys-j2se \
/usr/java/jre1.5.* \
/usr/java/jdk1.5.* \
/usr/java/j2re1.4.2* \
/usr/java/j2sdk1.4.2* \
/usr/java/j2re1.4* \
/usr/java/j2sdk1.4* \
"
        ;;

    HP-UX)
       _j2se_locations="\
/usr/jdk/entsys-j2se \
/opt/java1.5* \
/opt/java1.4* \
"
        ;;

    Darwin)
            _j2se_locations="\
/usr/jdk/entsys-j2se \
/Library/Java/Home \
/usr \
"
        ;;

    *)
        _j2se_locations="\
/usr/jdk/entsys-j2se \
/usr/j2se \
/usr/java \
/usr/java/jre1.5.* \
/usr/java/jdk1.5.* \
/usr/java/j2re1.4.2* \
/usr/java/j2sdk1.4.2* \
/usr/java/j2re1.4* \
/usr/java/j2sdk1.4* \
$mq_home/jre \
"
        ;;
    esac

    # Scan list and pick first J2SE we find. Note this does not check version
    for f in $_j2se_locations; do
        if [ -x $f/bin/java ] ; then
            imq_javareason="Default location: $_j2se_locations"
            imq_javahome=$f
            break
        fi
    done
}

_bin_home=`/usr/bin/dirname $0`

# Determine the processor type
case "`uname -m`" in
    i[3-6]86  | ia32 | ia64 | i*86*)
        imq_proc=i386
        ;;
    x86*64 | amd64)
        imq_proc=i386
        ;;
    sparc* | sun4*)
        imq_proc=sparc
        ;;
    *)
        if [ `uname` = "HP-UX" ] ; then
                imq_proc="`uname -m`"
        else
                imq_proc="`uname -p`"
        fi
        ;;
esac

# Determine the OS type
imq_os="`uname`"
imq_osver="`uname -r`"

# check if we were installed as part of a solaris package OR
# another (isa_eval, linux) type of installation
imq_installtype=""
if [ -f $_bin_home/../lib/imqbroker.jar ] ; then
# set default locations (not solaris package)
    if [ $imq_os = "Linux" ] ; then
        imq_installtype="Linux compatibility install"
#####hpux-dev##### Bug Id 6256771
    elif [ $imq_os = "HP-UX" ] ; then
        imq_installtype="HP-UX install"
    else
        imq_installtype="Non-package install"
    fi
    imq_home=$_bin_home/..
    imq_etchome=$imq_home/etc
    imq_libhome=$imq_home/lib
    imq_sharelib_home=$imq_libhome
    imq_sharelibimq_home=$imq_sharelib_home
    imq_varhome=$imq_home/var
elif [ -f $_bin_home/../private/share/lib/imqbroker.jar ] ; then
#####hpux-dev#####
     if [ $imq_os = "HP-UX" ] ; then
         # New "standard" HP-UX install location
         imq_installtype="HP-UX standard install"
     else
         # New "standard" Linux install location
         imq_installtype="Linux standard install"
     fi
    imq_home=$_bin_home/..
# Use etc symlink
    imq_etchome=$imq_home/etc
    imq_libhome=$imq_home/lib
    imq_sharelib_home=$imq_home/share/lib
    imq_sharelibimq_home=$imq_home/private/share/lib
# Use var symlink
    imq_varhome=$imq_home/var
else
# solaris install
    imq_installtype="Solaris package install"
    imq_home=$_bin_home/../..
    imq_etchome=$imq_home/etc/imq
    imq_libhome=$imq_home/usr/lib
    imq_sharelib_home=$imq_home/usr/share/lib
    imq_sharelibimq_home=$imq_sharelib_home/imq
    imq_varhome=$imq_home/var/imq
fi

# Locate the default J2SE. This will set imq_javahome to it
findj2se;

# Next load what's in imqenv.conf file. In 3.6 imqenv.conf moved from
# from /etc/imq to /usr/share/lib/imq so we check both places.
_env_files="$imq_etchome/imqenv.conf $imq_sharelibimq_home/imqenv.conf"
for _f in $_env_files; do
    if [ -f "$_f" ] ; then
        if [ -r "$_f" ] ; then
            . "$_f"
            if [ -n "$IMQ_DEFAULT_JAVAHOME" ] ; then
                imq_javahome=$IMQ_DEFAULT_JAVAHOME
                imq_javareason="File $_f"
                IMQ_DEFAULT_JAVAHOME=
            fi
        else
            echo "Warning: Could not read $_f -- ignoring"
        fi
    fi
done
imq_varhome=${IMQ_DEFAULT_VARHOME:-$imq_varhome}
imq_etchome=${IMQ_DEFAULT_ETCHOME:-$imq_etchome}

# Override imq_varhome with the IMQ_VARHOME env variable
imq_varhome=${IMQ_VARHOME:-$imq_varhome}

# Override imq_varhome with -varhome
_varhomenext=false
for _opt in "$@"
do
  if [ $_varhomenext = true ]
  then
    imq_varhome=$_opt
    _varhomenext=false
  elif [ "$_opt" = "-varhome" ]
  then
    _varhomenext=true;
  fi
done

# Override imq_javahome with the IMQ_JAVAHOME env variable
if [ -n "$IMQ_JAVAHOME" ] ; then
    imq_javahome=${IMQ_JAVAHOME:-$imq_javahome}
    imq_javareason="IMQ_JAVAHOME"
fi

# Next override with what's in jdk.env
# jdk.env is deprecated. It has been replace by imqenv.conf
_jdk_env_file=$imq_varhome/jdk.env
if [ -f $_jdk_env_file ] ; then
    if [ -r $_jdk_env_file ] ; then
       _jdk_env_home=`/bin/cat $_jdk_env_file`
       imq_javahome=$_jdk_env_home
       imq_javareason="File $_jdk_env_file"
    else
        echo "Warning: Could not read $_jdk_env_file -- ignoring"
    fi
fi

# Finally check for -javahome. We do this in a fashion that does not
# disrupt the original argument list
_javahomenext=false
for _opt in "$@"
do
  if [ $_javahomenext = true ]
  then
    imq_javahome=$_opt
    imq_javareason="-javahome"
    _javahomenext=false
  fi
  if [ "$_opt" = "-javahome" ] || [ "$_opt" = "-jrehome" ]
  then
    _javahomenext=true;
  elif [ "$_opt" = "-verbose" ] 
  then
    _verbose=true;
  fi
done

if [ -z "$imq_javahome" ]; then
   echo "Error: Could not find a valid J2SE."
   echo "Searched: $_j2se_locations"
   echo "Use IMQ_JAVAHOME or -javahome to specify the location of an alternate J2SE."
   exit 1
fi

if [ ! -x "$imq_javahome/bin/java" ] 
then
   echo "Error: Invalid J2SE location: $imq_javahome"
   echo "J2SE location was specified using: $imq_javareason"
   echo "Exiting"
   exit 1
fi

check_for_servervm;

if [ ! -z "$_verbose" ]; then
    echo ""
    echo "Starting $0"
    echo "Environment is:"
    echo "    j2se location                : $imq_javahome" 
    echo "    j2se specified               : $imq_javareason" 
    echo "    Message Queue install type   : $imq_installtype" 
    echo "    OS                           : $imq_os" 
    echo "    OS Version                   : $imq_osver" 
    echo "    Processor type               : $imq_proc" 
    echo "    Current Directory            : $_bin_home"
    echo "    IMQ_HOME                     : $imq_home" 
    echo "    IMQ_VARHOME                  : $IMQ_VARHOME" 
    echo "    imq_etchome                  : $imq_etchome" 
    echo "    imq_varhome                  : $imq_varhome" 
    echo "    Default J2SE locations       : $_j2se_locations" 
fi

