#include <jni.h>
#include <unistd.h>
#include <stdlib.h>
#include "com_sun_messaging_jmq_util_Password.h"
/* ####hpux-dev##### */
#include <string.h>
#include <sys/termios.h>

/*
 * Class:     Password
 * Method:    getHiddenPassword
 * Signature: ()Ljava/lang/String;
 */

JNIEXPORT jstring JNICALL Java_com_sun_messaging_jmq_util_Password_getHiddenPassword (JNIEnv *env, jobject obj)  {
    char	*buf;

/* #####hpux-dev##### */
#if defined(HPUX)
    struct termios termio;
    int res;
    char pbuf[257];
    if( (res = tcgetattr( 1, &termio)) )
    {
	return NULL;
    }
    termio.c_lflag &= ~ECHO;
    if( (res = tcsetattr( 1, TCSANOW, &termio)) )
    {
        return NULL;
    }
    if (fgets(pbuf,256,stdin) == NULL)
    {
	buf = NULL;
    }
    else
    {
	char *tmp;
        tmp = strchr(pbuf,'\n');
        if (tmp) *tmp = '\0';
        tmp = strchr(pbuf,'\r');
        if (tmp) *tmp = '\0';
        buf = strdup(pbuf);
    }
    if( (res = tcgetattr( 1, &termio)) )
    {
        return NULL;
    }
    termio.c_lflag |= ECHO;
    if( (res = tcsetattr( 1, TCSANOW, &termio)) )
    {
        return NULL;
    }
#else
    buf = (char *)getpassphrase("");
#endif


    return((*env)->NewStringUTF(env, buf));
}


