/*
 * @(#)imqbrokerd.c	1.3 03/05/05
 * 
 * Copyright (c) 1998-2000 Sun Microsystems, Inc.
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */

/*
 * Front-end program to MQ broker. All this does is call
 * 	IMQ_HOME/bin/imqbrokersvc -console
 */

#include <windows.h>
#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <process.h>
#include <direct.h>
#include <errno.h>
#include "mqapp.h"

/*
 * Class path entries. Relative paths are assumed to be relative to
 * $imqhome/lib
 */
char *classpath_entries[] = {
        "dummy.jar"
        };
int nclasspath_entries = 0;

void brokerParseArgs (MqEnv *me, char *argv[], int argc)
{
    argv++; argc--;
    while (argc > 0) {
        /* We don't recognize the option, pass it on to application */
        me->application_argv[me->application_argc] = _strdup(*argv);
        me->application_argc++;
        argv++; argc--;
    }
}


void main(int argc, char** argv)
{
    char cmdLine[1024];
    char brokerCmd[512];
    char *p;
    DWORD exitCode = 0;
    MqEnv	me;
    int i;

    p = getenv("OS");
    if ((p == NULL) || (strcmp(p, "Windows_NT") != 0)) {
	printf("The MQ broker requires Windows NT or Windows 2000\n");
	exit(1);
    }

    MqAppInitMqEnv(&me, "");

    brokerParseArgs (&me, argv, argc);

    if (MqAppInitializeNoJava(&me) < 0) {
	exit (1);
    }

    sprintf(brokerCmd, "\"%s\\bin\\imqbrokersvc\"", me.imqhome);

    /* Copy Java command and command line arguments into command line */
    strcpy(cmdLine, brokerCmd);

    /*
     * Append -console
     */
    strcat(cmdLine, " -console");

    /*
     * Append any other options passed in
     */
    for (i = 0; i < me.application_argc; i++) {
        strcat(cmdLine, " ");
        strcat(cmdLine, "\"");
        strcat(cmdLine, me.application_argv[i]);
        strcat(cmdLine, "\"");
    }

    exitCode = MqAppRunCmd(cmdLine);

    exit(exitCode);
}
