/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.transport.httptunnel.servlet;

import com.sun.messaging.jmq.transport.httptunnel.HttpTunnelDefaults;
import com.sun.messaging.jmq.transport.httptunnel.HttpTunnelPacket;
import com.sun.messaging.jmq.transport.httptunnel.servlet.ServerLinkTable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;

public class HttpTunnelServlet
extends HttpServlet
implements HttpTunnelDefaults {
    private int serviceCounter = 0;
    private Object serviceLock = new Object();
    private boolean servletShuttingDown = false;
    protected String servletName = null;
    protected boolean inService = false;
    protected ServletContext servletContext;
    protected Date startTime = null;
    protected ServerLinkTable linkTable = null;
    protected Throwable initException = null;

    public void init() throws ServletException {
        this.serviceCounter = 0;
        this.servletShuttingDown = false;
        this.servletContext = this.getServletContext();
        this.startTime = new Date();
        this.servletName = "HttpTunnelServlet";
        try {
            this.linkTable = new ServerLinkTable(this.getServletConfig());
            this.inService = true;
        }
        catch (Exception exception) {
            this.initException = exception;
            this.servletContext.log(this.servletName + ": initialization failed, " + exception);
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.doGet(httpServletRequest, httpServletResponse);
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        httpServletResponse.setContentType("application/octet-stream");
        if (this.servletShuttingDown) {
            return;
        }
        String string = httpServletRequest.getQueryString();
        if (string == null) {
            this.handleTest(httpServletRequest, httpServletResponse);
            return;
        }
        if (!this.inService) {
            return;
        }
        Hashtable hashtable = HttpUtils.parseQueryString((String)string);
        String[] stringArray = (String[])hashtable.get("Type");
        String string2 = stringArray[0];
        if (string2 == null) {
            this.handleTest(httpServletRequest, httpServletResponse);
            return;
        }
        String string3 = null;
        String[] stringArray2 = (String[])hashtable.get("ServerName");
        if (stringArray2 != null) {
            string3 = stringArray2[0];
        }
        if (string2.equals("push")) {
            this.handlePush(httpServletRequest, httpServletResponse, string3);
        } else if (string2.equals("pull")) {
            stringArray2 = (String[])hashtable.get("ConnId");
            String string4 = stringArray2[0];
            this.handlePull(httpServletRequest, httpServletResponse, string4, string3);
        } else if (string2.equals("connect")) {
            this.handleConnect(httpServletRequest, httpServletResponse, string3);
        } else {
            this.handleTest(httpServletRequest, httpServletResponse);
        }
    }

    public void handleTest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            httpServletResponse.setContentType("text/html; charset=UTF-8 ");
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.println("<HTML>");
            printWriter.println("<HEAD>");
            printWriter.println("<TITLE> JMQ HTTP Tunneling Servlet </TITLE>");
            printWriter.println("</HEAD>");
            printWriter.println("<BODY>");
            if (this.inService) {
                printWriter.println("HTTP tunneling servlet ready.<BR>");
                printWriter.println("Servlet Start Time : " + this.startTime + " <BR>");
                printWriter.println("Accepting TCP connections from brokers on port : " + this.linkTable.getServletPort() + " <P>");
                Vector vector = this.linkTable.getServerList();
                printWriter.println("Total available brokers = " + vector.size() + "<BR>");
                printWriter.println("Broker List : <BR>");
                printWriter.println("<BLOCKQUOTE><PRE>");
                for (int i = 0; i < vector.size(); ++i) {
                    printWriter.println((String)vector.elementAt(i));
                }
                printWriter.println("</PRE></BLOCKQUOTE>");
            } else {
                printWriter.println(new Date() + "<br>");
                printWriter.println("HTTP Tunneling servlet cannot be started.<br>");
                if (this.initException != null) {
                    printWriter.println("    " + this.initException);
                }
            }
            printWriter.println("</BODY>");
            printWriter.println("</HTML>");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sendNoOp(HttpServletResponse httpServletResponse) {
        try {
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            HttpTunnelPacket httpTunnelPacket = new HttpTunnelPacket();
            httpTunnelPacket.setPacketType(12);
            httpTunnelPacket.setConnId(0);
            httpTunnelPacket.setSequence(0);
            httpTunnelPacket.setWinsize(0);
            httpTunnelPacket.setChecksum(0);
            httpTunnelPacket.setPacketBody(null);
            httpTunnelPacket.writePacket((OutputStream)servletOutputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void handlePull(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2) {
        Vector vector = this.linkTable.waitForPackets(string, string2);
        if (vector == null || vector.size() == 0) {
            this.sendNoOp(httpServletResponse);
            return;
        }
        try {
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            for (int i = 0; i < vector.size(); ++i) {
                HttpTunnelPacket httpTunnelPacket = (HttpTunnelPacket)vector.elementAt(i);
                httpTunnelPacket.writePacket((OutputStream)servletOutputStream);
            }
        }
        catch (Exception exception) {
            this.linkTable.retrySendPackets(vector, string, string2);
        }
    }

    public void handlePush(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) {
        int n = httpServletRequest.getContentLength();
        if (n > 0) {
            try {
                ServletInputStream servletInputStream = httpServletRequest.getInputStream();
                HttpTunnelPacket httpTunnelPacket = new HttpTunnelPacket();
                httpTunnelPacket.readPacket((InputStream)servletInputStream);
                this.linkTable.sendPacket(httpTunnelPacket, string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.sendNoOp(httpServletResponse);
    }

    public void handleConnect(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) {
        int n = httpServletRequest.getContentLength();
        if (n > 0) {
            HttpTunnelPacket httpTunnelPacket = null;
            try {
                ServletInputStream servletInputStream = httpServletRequest.getInputStream();
                httpTunnelPacket = new HttpTunnelPacket();
                httpTunnelPacket.readPacket((InputStream)servletInputStream);
            }
            catch (Exception exception) {
                return;
            }
            if (httpTunnelPacket == null) {
                return;
            }
            if (string == null) {
                string = this.linkTable.getDefaultServer();
            }
            if (string == null) {
                return;
            }
            if (!this.linkTable.getListenState(string)) {
                return;
            }
            int n2 = this.linkTable.createNewConn(string);
            if (n2 == -1) {
                return;
            }
            httpTunnelPacket.setConnId(n2);
            try {
                httpTunnelPacket.setPacketBody(("ServerName=" + string).getBytes("UTF8"));
                ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                httpTunnelPacket.writePacket((OutputStream)servletOutputStream);
                this.linkTable.sendPacket(httpTunnelPacket, string);
            }
            catch (Exception exception) {
                this.servletContext.log(this.servletName + ": client connect: " + exception.getMessage(), (Throwable)exception);
                this.linkTable.destroyConn(n2, string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.enteringServiceMethod();
        try {
            super.service(httpServletRequest, httpServletResponse);
        }
        finally {
            this.leavingServiceMethod();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enteringServiceMethod() {
        Object object = this.serviceLock;
        synchronized (object) {
            ++this.serviceCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void leavingServiceMethod() {
        Object object = this.serviceLock;
        synchronized (object) {
            --this.serviceCounter;
            if (this.serviceCounter == 0 && this.servletShuttingDown) {
                this.serviceLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int numServices() {
        Object object = this.serviceLock;
        synchronized (object) {
            return this.serviceCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            Thread.sleep(1L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object object = this.serviceLock;
        synchronized (object) {
            this.servletShuttingDown = true;
        }
        this.servletContext.log(this.servletName + ": destroy() ...");
        try {
            if (!this.inService) {
                return;
            }
            this.linkTable.shuttingDown();
            object = this.serviceLock;
            synchronized (object) {
                while (this.numServices() > 0) {
                    try {
                        this.serviceLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.linkTable.destroy();
            }
            this.servletContext.log(this.servletName + ": destroy() done");
        }
        finally {
            super.destroy();
        }
    }
}

