/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.logging.Loggable;
import com.sun.messaging.jms.JMSException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExceptionHandler {
    private static final String cname = "com.sun.messaging.jmq.jmsclient.ExceptionHandler";
    public static Logger rootLogger = Logger.getLogger("javax.jms");

    public static void handleConnectException(Exception exception, String string, int n) throws javax.jms.JMSException {
        String string2 = "[" + string + ":" + n + "]";
        ExceptionHandler.throwConnectionException(exception, string2);
    }

    public static void handleConnectException(Exception exception, String string) throws javax.jms.JMSException {
        String string2 = "[" + string + "]";
        ExceptionHandler.throwConnectionException(exception, string2);
    }

    private static void throwConnectionException(Exception exception, String string) throws javax.jms.JMSException {
        if (exception instanceof javax.jms.JMSException && ((javax.jms.JMSException)exception).getErrorCode() != null) {
            ExceptionHandler.throwJMSException((javax.jms.JMSException)exception);
        }
        String string2 = AdministeredObject.cr.getKString("C4003", string);
        String string3 = AdministeredObject.cr.getString("C4038", string2, exception.toString());
        JMSException jMSException = new JMSException(string3, "C4003");
        ((javax.jms.JMSException)jMSException).setLinkedException(exception);
        ExceptionHandler.throwJMSException(jMSException);
    }

    public static void handleException(Exception exception, String string) throws javax.jms.JMSException {
        ExceptionHandler.handleException(exception, string, true);
    }

    public static void handleException(Exception exception, String string, boolean bl) throws javax.jms.JMSException {
        if (exception instanceof javax.jms.JMSException && ((javax.jms.JMSException)exception).getErrorCode() != null) {
            ExceptionHandler.throwJMSException((javax.jms.JMSException)exception);
        }
        ExceptionHandler.handleException(exception, ExceptionHandler.getJMSException(exception, string, bl));
    }

    public static void handleException(Exception exception, javax.jms.JMSException jMSException) throws javax.jms.JMSException {
        jMSException.setLinkedException(exception);
        if (Debug.debug) {
            ExceptionHandler.printStackTrace(exception);
        }
        ExceptionHandler.throwJMSException(jMSException);
    }

    public static void printStackTrace(Exception exception) {
        Debug.printStackTrace(exception);
    }

    public static javax.jms.JMSException getJMSException(Exception exception, String string, boolean bl) {
        String string2 = null;
        string2 = exception == null ? AdministeredObject.cr.getKString(string) : ExceptionHandler.getExceptionMessage(exception, string);
        return new JMSException(string2, string);
    }

    public static String getExceptionMessage(Exception exception, String string) {
        String string2 = null;
        if (string == null) {
            string = "C4038";
        }
        if (string == "C4038") {
            string2 = "[" + "C4038" + "]: " + exception.toString();
        } else {
            String string3 = AdministeredObject.cr.getKString(string);
            string2 = AdministeredObject.cr.getString("C4038", string3, exception.toString());
        }
        return string2;
    }

    public static void throwJMSException(javax.jms.JMSException jMSException) throws javax.jms.JMSException {
        try {
            if (ExceptionHandler.shouldLog(jMSException)) {
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    ExceptionHandler.logCaughtException(exception);
                }
                rootLogger.log(Level.FINER, "I501", jMSException);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        throw jMSException;
    }

    private static boolean shouldLog(javax.jms.JMSException jMSException) {
        boolean bl = true;
        if (jMSException instanceof Loggable) {
            if (((Loggable)((Object)jMSException)).getLogState()) {
                bl = false;
            } else {
                ((Loggable)((Object)jMSException)).setLogState(true);
            }
        }
        return bl;
    }

    public static void logCaughtException(Throwable throwable) {
        if (throwable != null && rootLogger.isLoggable(Level.WARNING)) {
            String string = AdministeredObject.cr.getKString("I500", throwable.toString());
            rootLogger.log(Level.WARNING, string);
        }
    }

    public static void logError(Throwable throwable) {
        if (throwable != null && rootLogger.isLoggable(Level.SEVERE)) {
            String string = throwable.toString();
            rootLogger.log(Level.SEVERE, string, throwable);
        }
    }
}

