/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.auth.jaas;

import com.sun.messaging.jmq.auth.api.server.model.UserRepository;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.jaas.CallbackHandlerImpl;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Destroyable;
import javax.security.auth.Refreshable;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class UserRepositoryImpl
implements UserRepository {
    public static boolean DEBUG = false;
    public static final String TYPE = "jaas";
    public static final String PROP_NAME_SUFFIX = ".name";
    private Logger logger = Globals.getLogger();
    private String authType = null;
    private Properties authProps = null;
    private String name = null;
    private LoginContext lc = null;
    private Object lock = new Object();
    private boolean login = false;
    private boolean logout = false;

    public void JAASUserRepository() {
    }

    public String getType() {
        return TYPE;
    }

    public void open(String string, Properties properties, Refreshable refreshable) throws LoginException {
        this.authType = string;
        this.authProps = properties;
        String string2 = this.authProps.getProperty("imq.authentication." + string + ".user_repository");
        if (string2 == null) {
            throw new LoginException(Globals.getBrokerResources().getKString("B4041", string));
        }
        if (!string2.equals(TYPE)) {
            Object[] objectArray = new String[]{string2, TYPE, this.getClass().getName()};
            throw new LoginException(Globals.getBrokerResources().getKString("B4070", objectArray));
        }
        String string3 = "imq.user_repository." + string2;
        this.name = this.authProps.getProperty(string3 + PROP_NAME_SUFFIX);
        if (this.name == null) {
            throw new LoginException(Globals.getBrokerResources().getKString("B4211"));
        }
        if (DEBUG) {
            this.logger.log(8, "Using JAAS authentication " + this.name);
        }
    }

    public Subject findMatch(String string, Object object, Object object2, String string2) throws LoginException {
        if (string2 != null && string2.equals("basic")) {
            return this.basicFindMatch(string, (String)object);
        }
        String string3 = string2 == null ? "null" : string2;
        Object[] objectArray = new String[]{string3, this.authType, this.getType(), "basic"};
        throw new LoginException(Globals.getBrokerResources().getKString("B4079", objectArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Subject basicFindMatch(String string, String string2) throws LoginException {
        if (DEBUG) {
            this.logger.log(4, "Authentication type basic - " + string + ":" + string2);
        }
        CallbackHandlerImpl callbackHandlerImpl = new CallbackHandlerImpl(this.authProps, string, string2);
        this.lc = new LoginContext(this.name, callbackHandlerImpl);
        Object object = this.lock;
        synchronized (object) {
            if (this.logout) {
                throw new LoginException("XXXI18N Connection closed");
            }
            this.lc.login();
            this.login = true;
            callbackHandlerImpl.destroy();
            Subject subject = this.lc.getSubject();
            Set<Object> set = subject.getPrivateCredentials();
            Iterator<Object> iterator = set.iterator();
            Object object2 = null;
            while (iterator.hasNext()) {
                try {
                    object2 = iterator.next();
                    if (object2 == null || !(object2 instanceof Destroyable) || ((Destroyable)object2).isDestroyed()) continue;
                    ((Destroyable)object2).destroy();
                }
                catch (Exception exception) {
                    this.logger.log(16, "XXX Unable to destroy private credential:" + object2.getClass().getName() + " for " + string);
                }
            }
            return subject;
        }
    }

    public Refreshable getCacheData() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws LoginException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.logout && this.login) {
                this.lc.logout();
                this.logout = true;
            }
        }
    }
}

