/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.core.SessionUID;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.lists.RemoveReason;
import com.sun.messaging.jmq.util.lists.EventBroadcastHelper;
import com.sun.messaging.jmq.util.lists.EventBroadcaster;
import com.sun.messaging.jmq.util.lists.EventListener;
import com.sun.messaging.jmq.util.lists.EventType;
import com.sun.messaging.jmq.util.lists.Filter;
import com.sun.messaging.jmq.util.lists.NFLPriorityFifoSet;
import com.sun.messaging.jmq.util.lists.Prioritized;
import com.sun.messaging.jmq.util.lists.Reason;
import com.sun.messaging.jmq.util.lists.SubSet;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.selector.Selector;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;

public class Consumer
implements EventBroadcaster,
Serializable {
    transient Logger logger = Globals.getLogger();
    static final long serialVersionUID = 3353669107150988952L;
    public static boolean DEBUG;
    private transient boolean useConsumerFlowControl = false;
    private transient int msgsToConsumer = 0;
    transient Destination destination = null;
    private static boolean C_FLOW_CONTROL_ALLOWED;
    long lastAckTime = 0L;
    SessionUID sessionuid = null;
    DestinationUID dest;
    ConsumerUID uid;
    transient ConsumerUID stored_uid;
    ConnectionUID conuid = null;
    transient boolean valid = true;
    transient boolean active = true;
    transient boolean paused = false;
    transient int pauseCnt = 0;
    transient int pauseFlowCnt = 0;
    transient int resumeFlowCnt = 0;
    boolean noLocal = false;
    transient boolean busy = false;
    transient Subscription parent = null;
    transient boolean isSpecialRemote = false;
    transient boolean isFailover = false;
    transient int position = 0;
    transient EventBroadcastHelper evb = null;
    boolean ackMsgsOnDestroy = true;
    transient int flowCount = 0;
    transient boolean flowPaused = false;
    transient int msgsOut = 0;
    transient int prefetch = -1;
    transient SysMessageID creator = null;
    protected String selstr = null;
    protected transient Selector selector = null;
    transient NFLPriorityFifoSet msgs;
    protected transient SubSet parentList = null;
    private transient Object plistener = null;
    private transient Object mlistener = null;
    transient EventListener busylistener = null;
    transient EventListener removeListener = null;
    private transient Object expiredID = null;
    private transient Object purgedID = null;
    private transient Object removedID1 = null;
    private transient Object removedID2 = null;
    private transient Object removedID3 = null;
    private transient Object removedID4 = null;
    transient Object plock = new Object();
    HashSet remotePendingDelivered = new HashSet();
    private static HashMap consumers;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void addRemoveListener(EventBroadcaster eventBroadcaster) {
        this.expiredID = eventBroadcaster.addEventListener(this.removeListener, EventType.SET_CHANGED_REQUEST, RemoveReason.EXPIRED, null);
        this.purgedID = eventBroadcaster.addEventListener(this.removeListener, EventType.SET_CHANGED_REQUEST, RemoveReason.PURGED, null);
        this.removedID1 = eventBroadcaster.addEventListener(this.removeListener, EventType.SET_CHANGED_REQUEST, RemoveReason.REMOVED_OLDEST, null);
        this.removedID2 = eventBroadcaster.addEventListener(this.removeListener, EventType.SET_CHANGED_REQUEST, RemoveReason.REMOVED_LOW_PRIORITY, null);
        this.removedID3 = eventBroadcaster.addEventListener(this.removeListener, EventType.SET_CHANGED_REQUEST, RemoveReason.REMOVED_REJECTED, null);
        this.removedID4 = eventBroadcaster.addEventListener(this.removeListener, EventType.SET_CHANGED_REQUEST, RemoveReason.REMOVED_OTHER, null);
    }

    public void removeRemoveListener(EventBroadcaster eventBroadcaster) {
        eventBroadcaster.removeEventListener(this.expiredID);
        eventBroadcaster.removeEventListener(this.purgedID);
        eventBroadcaster.removeEventListener(this.removedID1);
        eventBroadcaster.removeEventListener(this.removedID2);
        eventBroadcaster.removeEventListener(this.removedID3);
        eventBroadcaster.removeEventListener(this.removedID4);
    }

    private boolean getParentBusy() {
        return this.parentList != null && !this.parentList.isEmpty() || this.parent != null && this.parent.isBusy();
    }

    public void setPrefetch(int n) {
        this.prefetch = n;
        this.useConsumerFlowControl = C_FLOW_CONTROL_ALLOWED;
    }

    public long getLastAckTime() {
        return this.lastAckTime;
    }

    public void setLastAckTime(long l) {
        this.lastAckTime = l;
    }

    public int getPrefetch() {
        return this.prefetch;
    }

    public void setSubscription(Subscription subscription) {
        this.ackMsgsOnDestroy = false;
        this.parent = subscription;
    }

    public SysMessageID getCreator() {
        return this.creator;
    }

    public void setCreator(SysMessageID sysMessageID) {
        this.creator = sysMessageID;
    }

    public String getClientID() {
        ConnectionUID connectionUID = this.getConnectionUID();
        if (connectionUID == null) {
            return "<unknown>";
        }
        Connection connection = Globals.getConnectionManager().getConnection(connectionUID);
        if (connectionUID == null) {
            return "<unknown>";
        }
        return (String)connection.getClientData("client id");
    }

    public boolean isDurableSubscriber() {
        if (this.parent != null) {
            return this.parent.isDurable();
        }
        if (this instanceof Subscription) {
            return ((Subscription)this).isDurable();
        }
        return false;
    }

    public boolean getIsFlowPaused() {
        return this.flowPaused;
    }

    public int totalMsgsDelivered() {
        return this.msgsOut;
    }

    public int numPendingAcks() {
        Session session = Session.getSession(this.sessionuid);
        if (session == null) {
            return 0;
        }
        return session.getNumPendingAcks(this.getConsumerUID());
    }

    public Subscription getSubscription() {
        return this.parent;
    }

    protected static Selector getSelector(String string) throws SelectorFormatException {
        return Selector.compile(string);
    }

    public SubSet getParentList() {
        return this.parentList;
    }

    public void destroyConsumer(Set set, boolean bl) {
        this.destroyConsumer(set, bl, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyConsumer(Set set, boolean bl, boolean bl2) {
        if (DEBUG) {
            this.logger.log(4, "destroyConsumer : " + this);
        }
        Consumer consumer = this;
        synchronized (consumer) {
            if (!this.valid) {
                return;
            }
            this.valid = false;
        }
        consumer = this.parent;
        if (consumer != null) {
            consumer.pause("Consumer.java: destroy " + this);
        }
        this.pause("Consumer.java: destroy ");
        if (this.parentList != null && this.plistener != null) {
            this.parentList.removeEventListener(this.plistener);
            this.plistener = null;
        }
        Destination destination = this.getDestination();
        SubSet subSet = null;
        LinkedHashSet linkedHashSet = this.plock;
        synchronized (linkedHashSet) {
            subSet = this.parentList;
            this.parentList = null;
        }
        if (this.parent != null) {
            this.parent.releaseConsumer(this.uid);
            this.parent = null;
            if (bl2) {
                try {
                    this.sendDestroyConsumerNotification();
                }
                catch (Exception exception) {
                    this.logger.log(8, "Internal Error: sending detach notification for " + this.uid + " from " + this.parent, exception);
                }
            }
        } else if (destination == null && !bl) {
            this.logger.log(4, "Removing consumer from non-existant destination" + this.dest);
        } else if (!bl) {
            try {
                destination.removeConsumer(this.uid, bl2);
            }
            catch (Exception exception) {
                this.logger.logStack(8, "Internal Error: removing consumer " + this.uid + " from " + destination, exception);
            }
        }
        if (DEBUG) {
            this.logger.log(4, "Destroying consumer " + this + "[" + set.size() + ":" + this.msgs.size() + "]" + destination.size());
        }
        linkedHashSet = new LinkedHashSet(this.msgs);
        RemoveReason removeReason = this.ackMsgsOnDestroy ? RemoveReason.ACKNOWLEDGED : RemoveReason.UNLOADED;
        set.addAll(linkedHashSet);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            PacketReference packetReference = (PacketReference)iterator.next();
            if (packetReference == null || !this.ackMsgsOnDestroy && packetReference.isLocal()) continue;
            iterator.remove();
            try {
                if (!packetReference.acknowledged(this.getConsumerUID(), this.getStoredConsumerUID(), !this.uid.isUnsafeAck(), packetReference.isLocal())) continue;
                if (destination == null) {
                    destination = this.getDestination();
                }
                if (destination == null) continue;
                destination.removeMessage(packetReference.getSysMessageID(), RemoveReason.ACKNOWLEDGED);
            }
            catch (Exception exception) {
                this.logger.log(4, "Broker down Unable to acknowlege" + packetReference.getSysMessageID() + ":" + this.uid, exception);
            }
        }
        this.msgs.removeAll(linkedHashSet, removeReason);
        if (!this.ackMsgsOnDestroy && subSet != null) {
            ((Prioritized)((Object)subSet)).addAllToFront(set, 0);
            set.clear();
        }
        this.destroy();
        if (this.msgs != null && this.mlistener != null) {
            this.msgs.removeEventListener(this.mlistener);
            this.mlistener = null;
        }
        if (consumer != null) {
            consumer.resume("Consumer.java: destroyConsumer " + this);
        }
        this.selstr = null;
        this.selector = null;
    }

    public void sendCreateConsumerNotification() throws BrokerException {
        Destination destination = this.getDestination();
        if (!(destination.getIsLocal() || destination.isInternal() || destination.isAdmin() || Globals.getClusterBroadcast() == null)) {
            Globals.getClusterBroadcast().createConsumer(this);
        }
    }

    public void sendDestroyConsumerNotification() throws BrokerException {
        Destination destination = this.getDestination();
        if (!(destination == null || destination.getIsLocal() || destination.isInternal() || destination.isAdmin() || Globals.getClusterBroadcast() == null)) {
            Globals.getClusterBroadcast().destroyConsumer(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        this.valid = false;
        this.pause("Consumer.java: destroy()");
        Object object = consumers;
        synchronized (object) {
            consumers.remove(this.uid);
        }
        this.selector = null;
        object = RemoveReason.UNLOADED;
        if (this.ackMsgsOnDestroy) {
            object = RemoveReason.ACKNOWLEDGED;
        }
        Destination destination = this.getDestination();
        HashSet hashSet = new HashSet(this.msgs);
        try {
            HashSet hashSet2 = hashSet;
            synchronized (hashSet2) {
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    PacketReference packetReference = (PacketReference)iterator.next();
                    if (!this.ackMsgsOnDestroy || !packetReference.acknowledged(this.getConsumerUID(), this.getStoredConsumerUID(), !this.uid.isUnsafeAck(), true)) continue;
                    destination.removeMessage(packetReference.getSysMessageID(), (Reason)object);
                }
            }
            this.msgs.removeAll(hashSet, (Reason)object);
        }
        catch (Exception exception) {
            this.logger.log(16, "Internal Error: Problem cleaning consumer " + this, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParentList(SubSet subSet) {
        this.ackMsgsOnDestroy = false;
        if (this.parentList != null) {
            if (this.plistener != null) {
                this.parentList.removeEventListener(this.plistener);
            }
            this.plistener = null;
        }
        if (!$assertionsDisabled && this.plistener != null) {
            throw new AssertionError();
        }
        Object object = this.plock;
        synchronized (object) {
            this.parentList = subSet;
            if (this.parentList != null) {
                this.plistener = this.parentList.addEventListener(this.busylistener, EventType.EMPTY, null);
            } else if (!$assertionsDisabled && this.plistener != null) {
                throw new AssertionError();
            }
        }
        this.checkState(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getMoreMessages(int n) {
        SubSet subSet = null;
        Object object = this.plock;
        synchronized (object) {
            subSet = this.parentList;
        }
        if (this.paused || subSet == null || subSet.isEmpty() || this.parent != null && this.parent.isPaused()) {
            return;
        }
        int n2 = 0;
        if (subSet.isEmpty()) {
            return;
        }
        while (!(this.isFailover || !this.isActive() || this.isPaused() || !this.isValid() || subSet == null || subSet.isEmpty() || n2 >= n || this.parent != null && this.parent.isPaused())) {
            PacketReference packetReference = (PacketReference)subSet.removeNext();
            if (packetReference == null) continue;
            this.msgs.add(11 - packetReference.getPriority(), packetReference);
            ++n2;
            this.busy = true;
        }
    }

    void setIsActiveConsumer(boolean bl) {
        this.isFailover = !bl;
        this.checkState(null);
    }

    public boolean getIsFailoverConsumer() {
        return this.isFailover;
    }

    public boolean getIsActiveConsumer() {
        return !this.isFailover;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.logger = Globals.getLogger();
        this.parent = null;
        this.busy = false;
        this.paused = false;
        this.flowPaused = false;
        this.flowCount = 0;
        this.active = true;
        this.valid = true;
        this.plock = new Object();
        this.plistener = null;
        this.mlistener = null;
        this.parentList = null;
        this.prefetch = -1;
        this.isFailover = false;
        this.position = 0;
        this.isSpecialRemote = false;
        this.parent = null;
        this.useConsumerFlowControl = false;
        this.stored_uid = null;
        this.active = true;
        this.pauseCnt = 0;
        try {
            this.selector = Consumer.getSelector(this.selstr);
        }
        catch (Exception exception) {
            this.logger.log(32, "Internal Error: bad stored selector[" + this.selstr + "], ignoring", exception);
            this.selector = null;
        }
        this.initInterest();
    }

    public boolean isBusy() {
        return this.busy;
    }

    public DestinationUID getDestinationUID() {
        return this.dest;
    }

    protected Consumer(ConsumerUID consumerUID) {
        this.uid = consumerUID;
    }

    public Consumer(DestinationUID destinationUID, String string, boolean bl, ConnectionUID connectionUID) throws IOException, SelectorFormatException {
        this.dest = destinationUID;
        this.noLocal = bl;
        this.uid = new ConsumerUID();
        this.uid.setConnectionUID(connectionUID);
        this.selstr = string;
        this.selector = Consumer.getSelector(string);
        this.initInterest();
        this.logger.log(4, "Created new consumer " + this.uid + " on destination " + destinationUID + " with selector " + string);
    }

    public Consumer(DestinationUID destinationUID, String string, boolean bl, ConsumerUID consumerUID) throws IOException, SelectorFormatException {
        this.dest = destinationUID;
        this.noLocal = bl;
        this.uid = consumerUID;
        if (consumerUID == null) {
            this.uid = new ConsumerUID();
        }
        this.selstr = string;
        this.selector = Consumer.getSelector(string);
        this.initInterest();
    }

    public boolean isValid() {
        return this.valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initInterest() {
        this.removeListener = new RemoveListener();
        this.busylistener = new BusyListener();
        this.evb = new EventBroadcastHelper();
        this.msgs = new NFLPriorityFifoSet(12, false);
        this.mlistener = this.msgs.addEventListener(this.busylistener, EventType.EMPTY, null);
        HashMap hashMap = consumers;
        synchronized (hashMap) {
            consumers.put(this.uid, this);
        }
    }

    public void setAckMsgsOnDestroy(boolean bl) {
        this.ackMsgsOnDestroy = bl;
    }

    public ConsumerUID getConsumerUID() {
        return this.uid;
    }

    public void setStoredConsumerUID(ConsumerUID consumerUID) {
        this.stored_uid = consumerUID;
    }

    public ConsumerUID getStoredConsumerUID() {
        if (this.stored_uid == null) {
            return this.uid;
        }
        return this.stored_uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean routeMessages(Collection collection, boolean bl) {
        if (bl) {
            if (!this.valid) {
                return false;
            }
            this.msgs.addAllToFront(collection, 0);
            Consumer consumer = this;
            synchronized (consumer) {
                this.msgsToConsumer += collection.size();
            }
            this.checkState(null);
        } else {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.routeMessage((PacketReference)iterator.next(), false);
            }
        }
        return this.valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean routeMessage(PacketReference packetReference, boolean bl) {
        int n = 0;
        if (!bl) {
            n = 11 - packetReference.getPriority();
        }
        if (!this.valid) {
            return false;
        }
        this.msgs.add(n, packetReference);
        Consumer consumer = this;
        synchronized (consumer) {
            ++this.msgsToConsumer;
        }
        if (!this.valid) {
            return false;
        }
        this.checkState(null);
        return true;
    }

    public int size() {
        return this.msgs.size();
    }

    public void attachToConnection(ConnectionUID connectionUID) {
        this.conuid = connectionUID;
        this.uid.setConnectionUID(connectionUID);
    }

    public void attachToSession(SessionUID sessionUID) {
        this.sessionuid = sessionUID;
    }

    public void attachToDestination(Destination destination) {
        this.destination = destination;
    }

    public Destination getDestination() {
        if (this.destination == null) {
            this.destination = Destination.getDestination(this.dest);
        }
        return this.destination;
    }

    public SessionUID getSessionUID() {
        return this.sessionuid;
    }

    public ConnectionUID getConnectionUID() {
        return this.conuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PacketReference getAndFillNextPacket(Packet packet) {
        Object object;
        Object object2;
        Object object3;
        PacketReference packetReference = null;
        if (this.flowPaused || this.paused) {
            this.checkState(null);
            return null;
        }
        if (!this.paused && this.msgs.isEmpty()) {
            this.getMoreMessages(this.prefetch <= 0 ? 1000 : this.prefetch);
        }
        while (this.valid && !this.paused && !this.msgs.isEmpty()) {
            packetReference = (PacketReference)this.msgs.removeNext();
            if (packetReference == null) continue;
            if (!packetReference.isExpired() || packetReference.isLast(this.uid)) break;
            try {
                object3 = new Hashtable();
                object2 = Globals.getBrokerResources().getKString("B0053", packetReference.getDestinationUID().toString());
                object = Globals.getBrokerResources().getKString("B0052", object2);
                ((Hashtable)object3).put("JMS_SUN_DMQ_UNDELIVERED_COMMENT", object);
                this.destination.markDead(packetReference, RemoveReason.EXPIRED, (Hashtable)object3);
            }
            catch (Exception exception) {
                if (exception instanceof BrokerException) {
                    this.logger.log(16, "B2090", exception);
                }
                this.logger.logStack(16, "B2090", exception);
            }
            packetReference.destroy();
            packetReference = null;
        }
        if (!this.valid) {
            return null;
        }
        if (packetReference == null) {
            this.checkState(null);
            return null;
        }
        object3 = packetReference.getPacket();
        if (object3 == null) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
        if (packet != null) {
            try {
                packet.fill((Packet)object3);
            }
            catch (IOException iOException) {
                this.logger.logStack(8, "Internal Exception processing packet ", iOException);
                return null;
            }
            packet.setConsumerID(this.uid.longValue());
            packet.setRedelivered(packetReference.getRedeliverFlag(this.getStoredConsumerUID()));
            if (packetReference.isLast(this.uid)) {
                packetReference.removeIsLast(this.uid);
                packet.setIsLast(true);
            }
            ++this.msgsOut;
        } else {
            ((Packet)object3).setRedelivered(packetReference.getRedeliverFlag(this.getStoredConsumerUID()));
        }
        if (this.useConsumerFlowControl) {
            if (this.prefetch != -1) {
                ++this.flowCount;
            }
            if (!this.flowPaused && packetReference.getMessageDeliveredAck(this.uid)) {
                object2 = packetReference.getAddress();
                if (object2 != null) {
                    object = this.remotePendingDelivered;
                    synchronized (object) {
                        this.remotePendingDelivered.add(packetReference);
                    }
                }
                if (packet != null) {
                    packet.setConsumerFlow(true);
                }
            }
            if (this.prefetch > 0 && this.flowCount >= this.prefetch) {
                if (packet != null) {
                    packet.setConsumerFlow(true);
                }
                packetReference.addMessageDeliveredAck(this.uid);
                object2 = packetReference.getAddress();
                if (object2 != null) {
                    object = this.remotePendingDelivered;
                    synchronized (object) {
                        this.remotePendingDelivered.add(packetReference);
                    }
                }
                ++this.pauseFlowCnt;
                this.flowPaused = true;
            }
        } else if (packetReference.getMessageDeliveredAck(this.uid)) {
            try {
                Globals.getClusterBroadcast().acknowledgeMessage(packetReference.getAddress(), packetReference.getSysMessageID(), this.uid, 0, false, null, null);
            }
            catch (BrokerException brokerException) {
                this.logger.log(4, "Can not send DELIVERED ack  received ", brokerException);
            }
            packetReference.removeMessageDeliveredAck(this.uid);
        }
        return packetReference;
    }

    public void purgeConsumer() throws BrokerException {
        RemoveReason removeReason = RemoveReason.ACKNOWLEDGED;
        HashSet hashSet = new HashSet(this.msgs);
        if (hashSet.isEmpty()) {
            return;
        }
        this.msgs.removeAll(hashSet, removeReason);
        Destination destination = this.getDestination();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            try {
                PacketReference packetReference = (PacketReference)iterator.next();
                if (!packetReference.acknowledged(this.getConsumerUID(), this.getStoredConsumerUID(), !this.uid.isUnsafeAck(), true)) continue;
                destination.removeMessage(packetReference.getSysMessageID(), removeReason);
            }
            catch (IOException iOException) {
                this.logger.log(16, "Internal Error: purging consumer " + this, iOException);
            }
        }
    }

    public void purgeConsumer(Filter filter) throws BrokerException {
        RemoveReason removeReason = RemoveReason.ACKNOWLEDGED;
        Set set = this.msgs.getAll(filter);
        this.msgs.removeAll(set, removeReason);
        Destination destination = this.getDestination();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            try {
                PacketReference packetReference = (PacketReference)iterator.next();
                if (!packetReference.acknowledged(this.getConsumerUID(), this.getStoredConsumerUID(), !this.uid.isUnsafeAck(), true)) continue;
                destination.removeMessage(packetReference.getSysMessageID(), removeReason);
            }
            catch (IOException iOException) {
                this.logger.log(16, "Internal Error: Problem purging consumer " + this, iOException);
            }
        }
    }

    public void activate() {
        this.active = true;
        this.checkState(null);
    }

    public void deactive() {
        this.active = false;
        this.checkState(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause(String string) {
        NFLPriorityFifoSet nFLPriorityFifoSet = this.msgs;
        synchronized (nFLPriorityFifoSet) {
            this.paused = true;
            ++this.pauseCnt;
            if (DEBUG) {
                this.logger.log(4, "Pausing consumer " + this + "[" + this.pauseCnt + "] " + string);
            }
        }
        this.checkState(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume(String string) {
        NFLPriorityFifoSet nFLPriorityFifoSet = this.msgs;
        synchronized (nFLPriorityFifoSet) {
            --this.pauseCnt;
            if (this.pauseCnt <= 0) {
                this.paused = false;
            }
            if (DEBUG) {
                this.logger.log(4, "Pausing consumer " + this + "[" + this.pauseCnt + "] " + string);
            }
        }
        this.checkState(null);
    }

    public void setFalconRemote(boolean bl) {
        this.isSpecialRemote = bl;
    }

    public boolean isFalconRemote() {
        return this.isSpecialRemote;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeFlow() {
        HashSet hashSet = this.remotePendingDelivered;
        synchronized (hashSet) {
            if (!this.remotePendingDelivered.isEmpty()) {
                Iterator iterator = this.remotePendingDelivered.iterator();
                while (iterator.hasNext()) {
                    PacketReference packetReference = (PacketReference)iterator.next();
                    try {
                        Globals.getClusterBroadcast().acknowledgeMessage(packetReference.getAddress(), packetReference.getSysMessageID(), this.uid, 0, false, null, null);
                    }
                    catch (BrokerException brokerException) {
                        this.logger.log(4, "Can not send DELIVERED ack  received ", brokerException);
                    }
                    iterator.remove();
                }
            }
        }
        if (this.flowPaused) {
            ++this.resumeFlowCnt;
            this.flowCount = 0;
            this.flowPaused = false;
            this.checkState(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeFlow(int n) {
        HashSet hashSet = this.remotePendingDelivered;
        synchronized (hashSet) {
            if (!this.remotePendingDelivered.isEmpty()) {
                Iterator iterator = this.remotePendingDelivered.iterator();
                while (iterator.hasNext()) {
                    PacketReference packetReference = (PacketReference)iterator.next();
                    try {
                        Globals.getClusterBroadcast().acknowledgeMessage(packetReference.getAddress(), packetReference.getSysMessageID(), this.uid, 0, false, null, null);
                    }
                    catch (BrokerException brokerException) {
                        this.logger.log(4, "Can not send DELIVERED ack  received ", brokerException);
                    }
                    iterator.remove();
                }
            }
        }
        this.setPrefetch(n);
        if (this.flowPaused) {
            ++this.resumeFlowCnt;
            this.flowCount = 0;
            this.flowPaused = false;
            this.checkState(null);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public String getSelectorStr() {
        return this.selstr;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public boolean getNoLocal() {
        return this.noLocal;
    }

    public Object addEventListener(EventListener eventListener, EventType eventType, Object object) throws UnsupportedOperationException {
        if (eventType != EventType.BUSY_STATE_CHANGED) {
            throw new UnsupportedOperationException("Only Busy State Changed notifications supported on this class");
        }
        return this.evb.addEventListener(eventListener, eventType, object);
    }

    public Object addEventListener(EventListener eventListener, EventType eventType, Reason reason, Object object) throws UnsupportedOperationException {
        if (eventType != EventType.BUSY_STATE_CHANGED) {
            throw new UnsupportedOperationException("Only Busy State Changed notifications supported on this class");
        }
        return this.evb.addEventListener(eventListener, eventType, reason, object);
    }

    public Object removeEventListener(Object object) {
        return this.evb.removeEventListener(object);
    }

    private void notifyChange(EventType eventType, Reason reason, Object object, Object object2, Object object3) {
        this.evb.notifyChange(eventType, reason, object, object2, object3);
    }

    public void dump(String string) {
        if (string == null) {
            string = "";
        }
        this.logger.log(8, string + "Consumer: " + this.uid + " [paused, active," + "flowPaused, parentBusy, hasMessages, parentSize ] = [" + this.paused + "," + this.active + "," + this.flowPaused + "," + this.getParentBusy() + "," + !this.msgs.isEmpty() + "," + (this.parentList == null ? 0 : this.parentList.size()) + "]");
        this.logger.log(8, string + "Busy state [" + this.uid + "] is " + this.busy);
        if (this.msgs == null) {
            this.logger.log(8, "msgs is null");
        } else {
            this.logger.log(8, this.msgs.toDebugString());
        }
        if (this.parentList == null) {
            this.logger.log(8, "parentList is null");
        } else {
            this.logger.log(8, this.parentList.toDebugString());
        }
    }

    public static Hashtable getAllDebugState() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("FlowControlAllowed", String.valueOf(C_FLOW_CONTROL_ALLOWED));
        hashtable.put("ConsumerCnt", String.valueOf(consumers.size()));
        Iterator iterator = Consumer.getAllConsumers();
        while (iterator.hasNext()) {
            Consumer consumer = (Consumer)iterator.next();
            hashtable.put("Consumer[" + consumer.getConsumerUID().longValue() + "]", consumer.getDebugState());
        }
        return hashtable;
    }

    public Hashtable getDebugState() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("ConsumerUID", String.valueOf(this.uid.longValue()));
        hashtable.put("Broker", this.uid.getBrokerAddress() == null ? "NONE" : this.uid.getBrokerAddress().toString());
        hashtable.put("msgsToConsumer", String.valueOf(this.msgsToConsumer));
        hashtable.put("StoredConsumerUID", String.valueOf(this.getStoredConsumerUID().longValue()));
        hashtable.put("ConnectionUID", this.conuid == null ? "none" : String.valueOf(this.conuid.longValue()));
        hashtable.put("type", "CONSUMER");
        hashtable.put("valid", String.valueOf(this.valid));
        hashtable.put("paused", String.valueOf(this.paused));
        hashtable.put("pauseCnt", String.valueOf(this.pauseCnt));
        hashtable.put("noLocal", String.valueOf(this.noLocal));
        hashtable.put("destinationUID", this.dest.toString());
        hashtable.put("busy", String.valueOf(this.busy));
        if (this.parent != null) {
            hashtable.put("Subscription", String.valueOf(this.parent.getConsumerUID().longValue()));
        }
        hashtable.put("isSpecialRemote", String.valueOf(this.isSpecialRemote));
        hashtable.put("ackMsgsOnDestroy", String.valueOf(this.ackMsgsOnDestroy));
        hashtable.put("position", String.valueOf(this.position));
        hashtable.put("active", String.valueOf(this.active));
        hashtable.put("flowCount", String.valueOf(this.flowCount));
        hashtable.put("flowPaused", String.valueOf(this.flowPaused));
        hashtable.put("pauseFlowCnt", String.valueOf(this.pauseFlowCnt));
        hashtable.put("resumeFlowCnt", String.valueOf(this.resumeFlowCnt));
        hashtable.put("useConsumerFlowControl", String.valueOf(this.useConsumerFlowControl));
        hashtable.put("selstr", this.selstr == null ? "none" : this.selstr);
        if (this.parentList == null) {
            hashtable.put("parentList", "null");
        }
        hashtable.put("prefetch", String.valueOf(this.prefetch));
        hashtable.put("parentBusy", String.valueOf(this.getParentBusy()));
        hashtable.put("hasMessages", String.valueOf(!this.msgs.isEmpty()));
        hashtable.put("msgsSize", String.valueOf(this.msgs.size()));
        hashtable.put("isFailover", String.valueOf(this.isFailover));
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getDebugMessages(boolean bl) {
        Vector<String> vector = new Vector<String>();
        NFLPriorityFifoSet nFLPriorityFifoSet = this.msgs;
        synchronized (nFLPriorityFifoSet) {
            Iterator iterator = this.msgs.iterator();
            while (iterator.hasNext()) {
                PacketReference packetReference = (PacketReference)iterator.next();
                vector.add(bl ? packetReference.getPacket().dumpPacketString() : packetReference.getPacket().toString());
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkState(Reason reason) {
        boolean bl = false;
        boolean bl2 = false;
        NFLPriorityFifoSet nFLPriorityFifoSet = this.msgs;
        synchronized (nFLPriorityFifoSet) {
            bl = !this.paused && this.active && !this.flowPaused && (this.getParentBusy() && !this.isFailover || !this.msgs.isEmpty());
            bl2 = bl != this.busy;
            this.busy = bl;
        }
        if (bl2) {
            this.notifyChange(EventType.BUSY_STATE_CHANGED, reason, this, new Boolean(!bl), new Boolean(bl));
        }
    }

    public String toString() {
        String string = "Consumer - " + this.dest + ":" + this.getConsumerUID();
        return string;
    }

    public void debug(String string) {
        if (string == null) {
            string = "";
        }
        this.logger.log(8, string + this.toString());
        String string2 = string + "\t";
        this.logger.log(8, string2 + "Selector = " + this.selector);
        this.logger.log(8, string2 + "msgs = " + this.msgs.size());
        this.logger.log(8, string2 + "parentList = " + (this.parentList == null ? 0 : this.parentList.size()));
        this.logger.log(8, string2 + "parent = " + this.parent);
        this.logger.log(8, string2 + "valid = " + this.valid);
        this.logger.log(8, string2 + "active = " + this.active);
        this.logger.log(8, string2 + "paused = " + this.paused);
        this.logger.log(8, string2 + "pauseCnt = " + this.pauseCnt);
        this.logger.log(8, string2 + "noLocal = " + this.noLocal);
        this.logger.log(8, string2 + "busy = " + this.busy);
        this.logger.log(8, string2 + "flowPaused = " + this.flowPaused);
        this.logger.log(8, string2 + "prefetch = " + this.prefetch);
        this.logger.log(8, string2 + this.msgs.toDebugString());
    }

    public void setCapacity(int n) {
        this.msgs.setCapacity(n);
    }

    public void setByteCapacity(long l) {
        this.msgs.setByteCapacity(l);
    }

    public int capacity() {
        return this.msgs.capacity();
    }

    public long byteCapacity() {
        return this.msgs.byteCapacity();
    }

    public static void clearAllConsumers() {
        consumers.clear();
    }

    public static Iterator getAllConsumers() {
        return new HashSet(consumers.values()).iterator();
    }

    public static int getNumConsumers() {
        return consumers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Consumer getConsumer(ConsumerUID consumerUID) {
        HashMap hashMap = consumers;
        synchronized (hashMap) {
            Consumer consumer = (Consumer)consumers.get(consumerUID);
            return consumer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Consumer getConsumer(SysMessageID sysMessageID) {
        if (sysMessageID == null) {
            return null;
        }
        HashMap hashMap = consumers;
        synchronized (hashMap) {
            Iterator iterator = consumers.values().iterator();
            while (iterator.hasNext()) {
                Consumer consumer = (Consumer)iterator.next();
                if (!sysMessageID.equals(consumer.getCreator())) continue;
                return consumer;
            }
        }
        return null;
    }

    static {
        $assertionsDisabled = !Consumer.class.desiredAssertionStatus();
        DEBUG = false;
        C_FLOW_CONTROL_ALLOWED = Globals.getConfig().getBooleanProperty("imq.destination.flowControlAllowed", true);
        consumers = new HashMap();
    }

    class RemoveListener
    implements EventListener {
        static final /* synthetic */ boolean $assertionsDisabled;

        RemoveListener() {
        }

        public void eventOccured(EventType eventType, Reason reason, Object object, Object object2, Object object3, Object object4) {
            if (!$assertionsDisabled && eventType != EventType.SET_CHANGED_REQUEST) {
                throw new AssertionError();
            }
            if (!(reason instanceof RemoveReason)) {
                return;
            }
            if (!$assertionsDisabled && reason == RemoveReason.UNLOADED) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && reason == RemoveReason.ROLLBACK) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && reason == RemoveReason.DELIVERED) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && reason == RemoveReason.ACKNOWLEDGED) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && reason == RemoveReason.ROLLBACK) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && reason == RemoveReason.OVERFLOW) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && reason == RemoveReason.ERROR) {
                throw new AssertionError();
            }
            PacketReference packetReference = (PacketReference)object2;
            Consumer.this.msgs.remove(packetReference);
        }

        static {
            $assertionsDisabled = !(class$com$sun$messaging$jmq$jmsserver$core$Consumer == null ? (class$com$sun$messaging$jmq$jmsserver$core$Consumer = Consumer.class$("com.sun.messaging.jmq.jmsserver.core.Consumer")) : class$com$sun$messaging$jmq$jmsserver$core$Consumer).desiredAssertionStatus();
        }
    }

    class BusyListener
    implements EventListener {
        static final /* synthetic */ boolean $assertionsDisabled;

        BusyListener() {
        }

        public void eventOccured(EventType eventType, Reason reason, Object object, Object object2, Object object3, Object object4) {
            if (!$assertionsDisabled && eventType != EventType.EMPTY) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !(object3 instanceof Boolean)) {
                throw new AssertionError();
            }
            Consumer.this.checkState(null);
        }

        static {
            $assertionsDisabled = !(class$com$sun$messaging$jmq$jmsserver$core$Consumer == null ? (class$com$sun$messaging$jmq$jmsserver$core$Consumer = Consumer.class$("com.sun.messaging.jmq.jmsserver.core.Consumer")) : class$com$sun$messaging$jmq$jmsserver$core$Consumer).desiredAssertionStatus();
        }
    }
}

