/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import [Ljava.lang.String;;
import [Ljavax.management.openmbean.CompositeData;;
import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.ConfigListener;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.GetClusterHandler;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadWrite;
import com.sun.messaging.jmq.jmsserver.management.util.ClusterUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.openmbean.CompositeData;

public class ClusterConfig
extends MQMBeanReadWrite
implements ConfigListener {
    private Properties brokerProps = null;
    private static MBeanAttributeInfo[] attrs;
    private static MBeanParameterInfo[] getBrokerInfoByAddrSignature;
    private static MBeanParameterInfo[] getBrokerInfoByIdSignature;
    private static MBeanOperationInfo[] ops;
    private static String[] attrChangeTypes;
    private static MBeanNotificationInfo[] notifs;

    public ClusterConfig() {
        this.initProps();
        BrokerConfig brokerConfig = Globals.getConfig();
        brokerConfig.addListener("imq.cluster.url", this);
    }

    public void setConfigFileURL(String string) throws MBeanException {
        Properties properties = new Properties();
        properties.setProperty("imq.cluster.url", string);
        try {
            BrokerConfig brokerConfig = Globals.getConfig();
            brokerConfig.updateProperties(properties, true);
        }
        catch (Exception exception) {
            this.handleSetterException("ConfigFileURL", exception);
        }
    }

    public String getConfigFileURL() {
        return this.brokerProps.getProperty("imq.cluster.url");
    }

    public String getClusterID() {
        return Globals.getClusterID();
    }

    public Boolean isHighlyAvailable() {
        return this.getHighlyAvailable();
    }

    public Boolean getHighlyAvailable() {
        return new Boolean(Globals.getHAEnabled());
    }

    public CompositeData getLocalBrokerInfo() throws MBeanException {
        ClusterManager clusterManager = Globals.getClusterManager();
        CompositeData compositeData = null;
        if (clusterManager == null) {
            return null;
        }
        MQAddress mQAddress = clusterManager.getMQAddress();
        String string = null;
        try {
            string = clusterManager.lookupBrokerID(BrokerMQAddress.createAddress(mQAddress.toString()));
        }
        catch (Exception exception) {
            this.handleGetterException("LocalBrokerInfo", exception);
        }
        if (string == null || string.equals("")) {
            return null;
        }
        try {
            ClusteredBroker clusteredBroker = clusterManager.getBroker(string);
            if (clusteredBroker == null) {
                return null;
            }
            compositeData = ClusterUtil.getConfigCompositeData(clusteredBroker);
        }
        catch (Exception exception) {
            this.handleGetterException("LocalBrokerInfo", exception);
        }
        return compositeData;
    }

    public String getMasterBroker() {
        this.brokerProps = Globals.getConfig().toProperties();
        return this.brokerProps.getProperty("imq.cluster.masterbroker");
    }

    public CompositeData getMasterBrokerInfo() throws MBeanException {
        if (Globals.getHAEnabled()) {
            return null;
        }
        String string = this.getMasterBroker();
        ClusterManager clusterManager = Globals.getClusterManager();
        CompositeData compositeData = null;
        if (clusterManager == null) {
            return null;
        }
        String string2 = null;
        try {
            string2 = clusterManager.lookupBrokerID(BrokerMQAddress.createAddress(string));
        }
        catch (Exception exception) {
            this.handleGetterException("MasterBrokerInfo", exception);
        }
        if (string2 == null || string2.equals("")) {
            return null;
        }
        try {
            ClusteredBroker clusteredBroker = clusterManager.getBroker(string2);
            if (clusteredBroker == null) {
                return null;
            }
            compositeData = ClusterUtil.getConfigCompositeData(clusteredBroker);
        }
        catch (Exception exception) {
            this.handleGetterException("MasterBrokerInfo", exception);
        }
        return compositeData;
    }

    public String[] getBrokerAddresses() {
        return this.getBrokerIDsOrAddresses(false);
    }

    public String[] getBrokerIDs() {
        if (!Globals.getHAEnabled()) {
            return null;
        }
        return this.getBrokerIDsOrAddresses(true);
    }

    private String[] getBrokerIDsOrAddresses(boolean bl) {
        ClusterManager clusterManager = Globals.getClusterManager();
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = null;
        if (clusterManager == null) {
            return null;
        }
        Iterator iterator = clusterManager.getConfigBrokers();
        if (iterator == null) {
            return null;
        }
        while (iterator.hasNext()) {
            ClusteredBroker clusteredBroker = (ClusteredBroker)iterator.next();
            Hashtable hashtable = GetClusterHandler.getBrokerClusterInfo(clusteredBroker, this.logger);
            if (hashtable == null) {
                this.logger.log(16, "MBean: " + this.getMBeanName() + "Problem encountered while constructing list of broker IDs or addresses, continuing...");
                continue;
            }
            String string = bl ? (String)hashtable.get("ID") : (String)hashtable.get("Address");
            if (string == null) {
                this.logger.log(16, "MBean: " + this.getMBeanName() + "Problem encountered while constructing list of broker IDs or addresses, continuing...");
                continue;
            }
            arrayList.add(string);
        }
        stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        return stringArray;
    }

    public CompositeData[] getBrokerInfo() throws MBeanException {
        ClusterManager clusterManager = Globals.getClusterManager();
        CompositeData[] compositeDataArray = null;
        ArrayList<CompositeData> arrayList = new ArrayList<CompositeData>();
        if (clusterManager == null) {
            return null;
        }
        Iterator iterator = clusterManager.getConfigBrokers();
        if (iterator == null) {
            return null;
        }
        while (iterator.hasNext()) {
            ClusteredBroker clusteredBroker = (ClusteredBroker)iterator.next();
            try {
                CompositeData compositeData = ClusterUtil.getConfigCompositeData(clusteredBroker);
                arrayList.add(compositeData);
            }
            catch (Exception exception) {
                this.handleOperationException("getBrokerInfo", exception);
            }
        }
        compositeDataArray = new CompositeData[arrayList.size()];
        compositeDataArray = arrayList.toArray(compositeDataArray);
        return compositeDataArray;
    }

    public CompositeData getBrokerInfoByAddress(String string) throws MBeanException {
        ClusterManager clusterManager = Globals.getClusterManager();
        CompositeData compositeData = null;
        if (clusterManager == null) {
            return null;
        }
        String string2 = null;
        try {
            string2 = clusterManager.lookupBrokerID(BrokerMQAddress.createAddress(string));
        }
        catch (Exception exception) {
            this.handleOperationException("getBrokerInfoByAddress", exception);
        }
        if (string2 == null || string2.equals("")) {
            return null;
        }
        try {
            ClusteredBroker clusteredBroker = clusterManager.getBroker(string2);
            if (clusteredBroker == null) {
                return null;
            }
            compositeData = ClusterUtil.getConfigCompositeData(clusteredBroker);
        }
        catch (Exception exception) {
            this.handleOperationException("getBrokerInfoByAddress", exception);
        }
        return compositeData;
    }

    public CompositeData getBrokerInfoByID(String string) throws MBeanException {
        ClusterManager clusterManager = Globals.getClusterManager();
        CompositeData compositeData = null;
        if (!Globals.getHAEnabled()) {
            return null;
        }
        try {
            if (clusterManager == null) {
                return null;
            }
            ClusteredBroker clusteredBroker = clusterManager.getBroker(string);
            if (clusteredBroker == null) {
                return null;
            }
            compositeData = ClusterUtil.getConfigCompositeData(clusteredBroker);
        }
        catch (Exception exception) {
            this.handleOperationException("getBrokerInfoByID", exception);
        }
        return compositeData;
    }

    public void reload() throws MBeanException {
        try {
            Globals.getClusterBroadcast().reloadCluster();
        }
        catch (Exception exception) {
            this.handleOperationException("reload", exception);
        }
    }

    public String getMBeanName() {
        return "ClusterConfig";
    }

    public String getMBeanDescription() {
        return mbr.getString("MB1000");
    }

    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return attrs;
    }

    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return ops;
    }

    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return notifs;
    }

    public void validate(String string, String string2) throws PropertyUpdateException {
    }

    public boolean update(String string, String string2) {
        if (string.equals("imq.cluster.url")) {
            String string3 = string2;
            String string4 = this.getConfigFileURL();
            this.notifyAttrChange("ConfigFileURL", string3, string4);
        }
        this.initProps();
        return true;
    }

    public void notifyAttrChange(String string, Object object, Object object2) {
        this.sendNotification(new AttributeChangeNotification(this, this.sequenceNumber++, new Date().getTime(), "Attribute change", string, object.getClass().getName(), object2, object));
    }

    private void initProps() {
        this.brokerProps = Globals.getConfig().toProperties();
        Version version = Globals.getVersion();
        this.brokerProps.putAll((Map<?, ?>)version.getProps());
    }

    static {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[5];
        mBeanAttributeInfoArray[0] = new MBeanAttributeInfo("ConfigFileURL", String.class.getName(), mbr.getString("MB1002"), true, true, false);
        Class clazz = String.class;
        mBeanAttributeInfoArray[1] = new MBeanAttributeInfo("ClusterID", clazz.getName(), mbr.getString("MB1003"), true, false, false);
        mBeanAttributeInfoArray[2] = new MBeanAttributeInfo("HighlyAvailable", Boolean.class.getName(), mbr.getString("MB1004"), true, false, true);
        mBeanAttributeInfoArray[3] = new MBeanAttributeInfo("LocalBrokerInfo", CompositeData.class.getName(), mbr.getString("MB1005"), true, false, false);
        Class clazz2 = CompositeData.class;
        mBeanAttributeInfoArray[4] = new MBeanAttributeInfo("MasterBrokerInfo", clazz2.getName(), mbr.getString("MB1006"), true, false, false);
        attrs = mBeanAttributeInfoArray;
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[1];
        Class clazz3 = String.class;
        mBeanParameterInfoArray[0] = new MBeanParameterInfo("BrokerAddress", clazz3.getName(), mbr.getString("MB1011"));
        getBrokerInfoByAddrSignature = mBeanParameterInfoArray;
        MBeanParameterInfo[] mBeanParameterInfoArray2 = new MBeanParameterInfo[1];
        Class clazz4 = String.class;
        mBeanParameterInfoArray2[0] = new MBeanParameterInfo("BrokerID", clazz4.getName(), mbr.getString("MB1013"));
        getBrokerInfoByIdSignature = mBeanParameterInfoArray2;
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[6];
        mBeanOperationInfoArray[0] = new MBeanOperationInfo("getBrokerAddresses", mbr.getString("MB1007"), null, String;.class.getName(), 0);
        mBeanOperationInfoArray[1] = new MBeanOperationInfo("getBrokerIDs", mbr.getString("MB1008"), null, String;.class.getName(), 0);
        mBeanOperationInfoArray[2] = new MBeanOperationInfo("getBrokerInfo", mbr.getString("MB1009"), null, CompositeData;.class.getName(), 0);
        mBeanOperationInfoArray[3] = new MBeanOperationInfo("getBrokerInfoByAddress", mbr.getString("MB1010"), getBrokerInfoByAddrSignature, CompositeData.class.getName(), 0);
        mBeanOperationInfoArray[4] = new MBeanOperationInfo("getBrokerInfoByID", mbr.getString("MB1012"), getBrokerInfoByIdSignature, CompositeData.class.getName(), 0);
        mBeanOperationInfoArray[5] = new MBeanOperationInfo("reload", mbr.getString("MB1014"), null, Void.TYPE.getName(), 1);
        ops = mBeanOperationInfoArray;
        attrChangeTypes = new String[]{"jmx.attribute.change"};
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[1];
        mBeanNotificationInfoArray[0] = new MBeanNotificationInfo(attrChangeTypes, AttributeChangeNotification.class.getName(), mbr.getString("MB1025"));
        notifs = mBeanNotificationInfoArray;
    }
}

