/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.persist.LoadException;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.FileStore;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.PHashMap;
import com.sun.messaging.jmq.util.PHashMapLoadException;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class PropertiesFile {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    BrokerConfig config = Globals.getConfig();
    static final String PROP_FILE_SIZE_PROP = "imq.persist.file.property.file.size";
    static final long DEFAULT_PROP_FILE_SIZE = 1024L;
    static final String BASENAME = "property";
    private PHashMap propMap = null;
    private File backingFile = null;
    private LoadException loadException = null;

    PropertiesFile(File file, boolean bl) throws BrokerException {
        Throwable throwable;
        SizeString sizeString = this.config.getSizeProperty(PROP_FILE_SIZE_PROP, 1024L);
        this.backingFile = new File(file, BASENAME);
        try {
            this.propMap = new PHashMap(this.backingFile, sizeString.getBytes(), false, bl);
        }
        catch (IOException iOException) {
            this.logger.logStack(32, "B4113", iOException);
            throw new BrokerException(this.br.getString("B4113"), iOException);
        }
        try {
            this.propMap.load();
        }
        catch (IOException iOException) {
            this.logger.logStack(32, "B4113", iOException);
            throw new BrokerException(this.br.getString("B4113"), iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logger.logStack(32, "B4113", classNotFoundException);
            throw new BrokerException(this.br.getString("B4113"), classNotFoundException);
        }
        catch (PHashMapLoadException pHashMapLoadException) {
            while (throwable != null) {
                this.logger.log(16, "B4196", throwable);
                LoadException loadException = new LoadException(throwable.getMessage(), throwable.getCause());
                loadException.setKey(((PHashMapLoadException)throwable).getKey());
                loadException.setValue(((PHashMapLoadException)throwable).getValue());
                loadException.setKeyCause(((PHashMapLoadException)throwable).getKeyCause());
                loadException.setValueCause(((PHashMapLoadException)throwable).getValueCause());
                loadException.setNextException(this.loadException);
                this.loadException = loadException;
                throwable = ((PHashMapLoadException)throwable).getNextException();
            }
        }
        throwable = this.propMap.getWarning();
        if (throwable != null) {
            this.logger.log(16, "possible loss of persisted properties", throwable);
        }
        if (bl && Store.DEBUG) {
            this.logger.log(1, "PropertiesFile initialized with clear option");
        }
        if (Store.DEBUG) {
            this.logger.log(4, "PropertiesFile: loaded " + this.propMap.size() + " properties");
        }
    }

    LoadException getLoadException() {
        return this.loadException;
    }

    PropertiesFile(FileStore fileStore, File file, File file2) throws BrokerException {
        Object object;
        Throwable throwable;
        File file3 = new File(file2, BASENAME);
        PHashMap pHashMap = null;
        this.backingFile = new File(file, BASENAME);
        try {
            pHashMap = new PHashMap(file3, false, false);
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4154", file3, this.backingFile, iOException);
            throw new BrokerException(this.br.getString("B4154", file3, this.backingFile), iOException);
        }
        try {
            pHashMap.load();
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4154", file3, this.backingFile, iOException);
            throw new BrokerException(this.br.getString("B4154", file3, this.backingFile), iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logger.log(32, "B4154", file3, this.backingFile, classNotFoundException);
            throw new BrokerException(this.br.getString("B4154", file3, this.backingFile), classNotFoundException);
        }
        catch (PHashMapLoadException pHashMapLoadException) {
            while (throwable != null) {
                this.logger.log(16, "B4201", throwable);
                object = new LoadException(throwable.getMessage(), throwable.getCause());
                ((LoadException)object).setKey(((PHashMapLoadException)throwable).getKey());
                ((LoadException)object).setValue(((PHashMapLoadException)throwable).getValue());
                ((LoadException)object).setKeyCause(((PHashMapLoadException)throwable).getKeyCause());
                ((LoadException)object).setValueCause(((PHashMapLoadException)throwable).getValueCause());
                ((LoadException)object).setNextException(this.loadException);
                this.loadException = object;
                throwable = ((PHashMapLoadException)throwable).getNextException();
            }
        }
        throwable = pHashMap.getWarning();
        if (throwable != null) {
            this.logger.log(16, "possible loss of persisted properties in old store", throwable);
        }
        try {
            this.propMap = new PHashMap(this.backingFile, file3.length(), false, false);
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4158", file3, this.backingFile, iOException);
            throw new BrokerException(this.br.getString("B4158", file3, this.backingFile), iOException);
        }
        try {
            this.propMap.load();
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4154", file3, this.backingFile, iOException);
            throw new BrokerException(this.br.getString("B4154", file3, this.backingFile), iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logger.log(32, "B4154", file3, this.backingFile, classNotFoundException);
            throw new BrokerException(this.br.getString("B4154", file3, this.backingFile), classNotFoundException);
        }
        catch (PHashMapLoadException pHashMapLoadException) {
            this.logger.log(32, "B4154", file3, this.backingFile, pHashMapLoadException);
            throw new BrokerException(this.br.getString("B4154", file3, this.backingFile), pHashMapLoadException);
        }
        throwable = this.propMap.getWarning();
        if (throwable != null) {
            this.logger.log(16, "possible loss of persisted properties", throwable);
        }
        object = pHashMap.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            Object k = entry.getKey();
            Object v = entry.getValue();
            this.propMap.put(k, v);
        }
        pHashMap.close();
        if (fileStore.upgradeNoBackup() && !file3.delete()) {
            this.logger.log(32, "B1044", file3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateProperty(String string, Object object, boolean bl) throws BrokerException {
        PHashMap pHashMap = this.propMap;
        synchronized (pHashMap) {
            Object v = this.propMap.get(string);
            boolean bl2 = false;
            try {
                if (object == null) {
                    if (v != null) {
                        this.propMap.remove(string);
                        bl2 = true;
                    }
                } else {
                    this.propMap.put(string, object);
                    bl2 = true;
                }
                if (bl2 && bl) {
                    this.sync();
                }
            }
            catch (RuntimeException runtimeException) {
                this.logger.log(32, "B4112", string);
                throw new BrokerException(this.br.getString("B4112", string), runtimeException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getProperty(String string) throws BrokerException {
        PHashMap pHashMap = this.propMap;
        synchronized (pHashMap) {
            return this.propMap.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getPropertyNames() throws BrokerException {
        PHashMap pHashMap = this.propMap;
        synchronized (pHashMap) {
            return this.propMap.keySet().toArray(new String[this.propMap.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearAll(boolean bl) {
        if (Store.DEBUG) {
            this.logger.log(1, "PropertiesFile.clearAll() called");
        }
        PHashMap pHashMap = this.propMap;
        synchronized (pHashMap) {
            this.propMap.clear();
            if (bl) {
                try {
                    this.sync();
                }
                catch (BrokerException brokerException) {
                    this.logger.log(32, "Got exception while synchronizing data to disk", brokerException);
                }
            }
        }
    }

    void close(boolean bl) {
        if (Store.DEBUG) {
            this.logger.log(1, "PropertiesFile: closing, " + this.propMap.size() + " properties");
        }
        this.propMap.close();
    }

    Hashtable getDebugState() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("Properties", String.valueOf(this.propMap.size()));
        return hashtable;
    }

    void printInfo(PrintStream printStream) {
        printStream.println("\nProperties");
        printStream.println("----------");
        printStream.println("backing file: " + this.backingFile);
        Set set = this.propMap.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            printStream.println((String)entry.getKey() + "=" + entry.getValue().toString());
        }
    }

    private void sync() throws BrokerException {
        try {
            this.propMap.force();
        }
        catch (IOException iOException) {
            throw new BrokerException("Failed to synchronize file: " + this.backingFile, iOException);
        }
    }
}

