/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.TransactionDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.JMQXid;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class TransactionDAOImpl
extends BaseDAOImpl
implements TransactionDAO {
    protected String tableName;
    protected String insertSQL;
    protected String updateTxnStateSQL;
    protected String updateAccessedTimeSQL;
    protected String updateBrokerSQL;
    protected String deleteSQL;
    protected String deleteNotInStateSQL;
    protected String selectTxnStateSQL;
    protected String selectAccessedTimeSQL;
    protected String selectBrokerSQL;
    protected String selectCountSQL;
    protected String selectAllStatesSQL;
    protected String selectUsageInfoSQL;
    protected String selectTakeoverSQL;
    protected String takeoverSQL;

    TransactionDAOImpl() throws BrokerException {
        DBManager dBManager = DBManager.getDBManager();
        this.tableName = dBManager.getTableName("MQTXN40");
        this.insertSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("ID").append(", ").append("STATE").append(", ").append("TXN_STATE").append(", ").append("AUTO_ROLLBACK").append(", ").append("XID").append(", ").append("BROKER_ID").append(", ").append("EXPIRED_TS").append(", ").append("ACCESSED_TS").append(") VALUES ( ?, ?, ?, ?, ?, ?, ?, ? )").toString();
        this.updateTxnStateSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("STATE").append(" = ?, ").append("TXN_STATE").append(" = ?").append(" WHERE ").append("ID").append(" = ?").toString();
        this.updateAccessedTimeSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("ACCESSED_TS").append(" = ?").append(" WHERE ").append("ID").append(" = ?").toString();
        this.updateBrokerSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("BROKER_ID").append(" = ?").append(" WHERE ").append("ID").append(" = ?").toString();
        this.deleteSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.deleteNotInStateSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("STATE").append(" <> ?").toString();
        this.selectCountSQL = new StringBuffer(128).append("SELECT COUNT(*)").append(" FROM ").append(this.tableName).toString();
        this.selectTxnStateSQL = new StringBuffer(128).append("SELECT ").append("TXN_STATE").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectAccessedTimeSQL = new StringBuffer(128).append("SELECT ").append("ACCESSED_TS").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectBrokerSQL = new StringBuffer(128).append("SELECT ").append("BROKER_ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectAllStatesSQL = new StringBuffer(128).append("SELECT ").append("ID").append(", ").append("STATE").append(", ").append("TXN_STATE").append(" FROM ").append(this.tableName).append(" WHERE ").append("BROKER_ID").append(" = ?").append(" AND ").append("STATE").append(" <> -1").toString();
        this.selectUsageInfoSQL = new StringBuffer(128).append("SELECT MAX(mcount), MAX(scount) FROM (").append("SELECT COUNT(*) mcount, 0 scount FROM ").append(dBManager.getTableName("MQMSG40")).append(" WHERE ").append("TRANSACTION_ID").append(" = ?").append(" UNION ").append("SELECT 0 mcount, COUNT(*) scount FROM ").append(dBManager.getTableName("MQCONSTATE40")).append(" WHERE ").append("TRANSACTION_ID").append(" = ?").append(")").toString();
        this.selectTakeoverSQL = new StringBuffer(128).append("SELECT ").append("ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("BROKER_ID").append(" = ?").toString();
        this.takeoverSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("BROKER_ID").append(" = ?").append(" WHERE ").append("BROKER_ID").append(" = ?").toString();
    }

    public final String getTableNamePrefix() {
        return "MQTXN40";
    }

    public String getTableName() {
        return this.tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(Connection connection, TransactionUID transactionUID, TransactionState transactionState) throws BrokerException {
        block15: {
            PreparedStatement preparedStatement;
            block14: {
                long l = transactionUID.longValue();
                boolean bl = false;
                preparedStatement = null;
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(true);
                        bl = true;
                    }
                    if (this.hasTransaction(connection, l)) {
                        throw new BrokerException(this.br.getKString("B3015", transactionUID.toString()));
                    }
                    try {
                        preparedStatement = connection.prepareStatement(this.insertSQL);
                        preparedStatement.setLong(1, l);
                        preparedStatement.setInt(2, transactionState.getState());
                        ByteArrayInputStream byteArrayInputStream = Util.setObject(preparedStatement, 3, transactionState);
                        preparedStatement.setInt(4, transactionState.getType().intValue());
                        JMQXid jMQXid = transactionState.getXid();
                        if (jMQXid != null) {
                            preparedStatement.setString(5, jMQXid.toString());
                        } else {
                            preparedStatement.setNull(5, 12);
                        }
                        preparedStatement.setString(6, dBManager.getBrokerID());
                        preparedStatement.setLong(7, transactionState.getExpirationTime());
                        preparedStatement.setLong(8, transactionState.getLastAccessTime());
                        preparedStatement.executeUpdate();
                        byteArrayInputStream.close();
                    }
                    catch (Exception exception) {
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080", sQLException);
                        }
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof IOException ? DBManager.wrapIOException("[" + this.insertSQL + "]", (IOException)exception) : (exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.insertSQL + "]", (SQLException)exception) : exception);
                        throw new BrokerException(this.br.getKString("B4019", transactionUID), exception2);
                    }
                    if (!bl) break block14;
                }
                catch (Throwable throwable) {
                    if (bl) {
                        Util.close(null, preparedStatement, connection);
                    } else {
                        Util.close(null, preparedStatement, null);
                    }
                    throw throwable;
                }
                Util.close(null, preparedStatement, connection);
                break block15;
            }
            Util.close(null, preparedStatement, null);
        }
    }

    public void updateTransactionState(Connection connection, TransactionUID transactionUID, TransactionState transactionState) throws BrokerException {
        boolean bl = false;
        boolean bl2 = false;
        PreparedStatement preparedStatement = null;
        try {
            if (connection == null) {
                connection = DBManager.getDBManager().getConnection(true);
                bl2 = true;
            }
            preparedStatement = connection.prepareStatement(this.updateTxnStateSQL);
            preparedStatement.setInt(1, transactionState.getState());
            ByteArrayInputStream byteArrayInputStream = Util.setObject(preparedStatement, 2, transactionState);
            preparedStatement.setLong(3, transactionUID.longValue());
            if (preparedStatement.executeUpdate() == 1) {
                bl = true;
            }
            byteArrayInputStream.close();
        }
        catch (Exception exception) {
            try {
                if (connection != null && !connection.getAutoCommit()) {
                    connection.rollback();
                }
            }
            catch (SQLException sQLException) {
                this.logger.log(32, "B4080", sQLException);
            }
            if (exception instanceof BrokerException) {
                throw (BrokerException)exception;
            }
            Exception exception2 = exception instanceof IOException ? DBManager.wrapIOException("[" + this.updateTxnStateSQL + "]", (IOException)exception) : (exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.updateTxnStateSQL + "]", (SQLException)exception) : exception);
            throw new BrokerException(this.br.getKString("B4137", transactionUID), exception2);
        }
        finally {
            if (bl2) {
                Util.close(null, preparedStatement, connection);
            } else {
                Util.close(null, preparedStatement, null);
            }
        }
        if (!bl) {
            throw new BrokerException(this.br.getKString("B3016", transactionUID), 404);
        }
    }

    public void updateAccessedTime(Connection connection, TransactionUID transactionUID, long l) throws BrokerException {
        boolean bl = false;
        PreparedStatement preparedStatement = null;
        try {
            if (connection == null) {
                connection = DBManager.getDBManager().getConnection(true);
                bl = true;
            }
            preparedStatement = connection.prepareStatement(this.updateAccessedTimeSQL);
            preparedStatement.setLong(1, l);
            preparedStatement.setLong(2, transactionUID.longValue());
            if (preparedStatement.executeUpdate() == 0) {
                throw new BrokerException(this.br.getKString("B3016", transactionUID), 404);
            }
        }
        catch (Exception exception) {
            try {
                if (connection != null && !connection.getAutoCommit()) {
                    connection.rollback();
                }
            }
            catch (SQLException sQLException) {
                this.logger.log(32, "B4080", sQLException);
            }
            if (exception instanceof BrokerException) {
                throw (BrokerException)exception;
            }
            Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.updateAccessedTimeSQL + "]", (SQLException)exception) : exception;
            throw new BrokerException(this.br.getKString("B4019", transactionUID), exception2);
        }
        finally {
            if (bl) {
                Util.close(null, preparedStatement, connection);
            } else {
                Util.close(null, preparedStatement, null);
            }
        }
    }

    public void updateBroker(Connection connection, TransactionUID transactionUID, String string) throws BrokerException {
        boolean bl = false;
        boolean bl2 = false;
        PreparedStatement preparedStatement = null;
        try {
            if (connection == null) {
                connection = DBManager.getDBManager().getConnection(true);
                bl2 = true;
            }
            preparedStatement = connection.prepareStatement(this.updateBrokerSQL);
            preparedStatement.setString(1, string);
            preparedStatement.setLong(2, transactionUID.longValue());
            if (preparedStatement.executeUpdate() > 0) {
                bl = true;
            }
        }
        catch (Exception exception) {
            try {
                if (connection != null && !connection.getAutoCommit()) {
                    connection.rollback();
                }
            }
            catch (SQLException sQLException) {
                this.logger.log(32, "B4080", sQLException);
            }
            if (exception instanceof BrokerException) {
                throw (BrokerException)exception;
            }
            Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.updateBrokerSQL + "]", (SQLException)exception) : exception;
            throw new BrokerException(this.br.getKString("B4019", transactionUID), exception2);
        }
        finally {
            if (bl2) {
                Util.close(null, preparedStatement, connection);
            } else {
                Util.close(null, preparedStatement, null);
            }
        }
        if (!bl) {
            throw new BrokerException(this.br.getKString("B3016", transactionUID), 404);
        }
    }

    public void delete(Connection connection, TransactionUID transactionUID) throws BrokerException {
        boolean bl;
        block15: {
            PreparedStatement preparedStatement;
            block14: {
                bl = false;
                boolean bl2 = false;
                preparedStatement = null;
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(false);
                        bl2 = true;
                    }
                    preparedStatement = connection.prepareStatement(this.deleteSQL);
                    preparedStatement.setLong(1, transactionUID.longValue());
                    if (preparedStatement.executeUpdate() > 0) {
                        bl = true;
                        dBManager.getDAOFactory().getConsumerStateDAO().deleteByTransaction(connection, transactionUID);
                    }
                    if (bl2) {
                        connection.commit();
                    }
                    if (!bl2) break block14;
                }
                catch (Exception exception) {
                    try {
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080", sQLException);
                        }
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.deleteSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4138", transactionUID), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl2) {
                            Util.close(null, preparedStatement, connection);
                        } else {
                            Util.close(null, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, preparedStatement, connection);
                break block15;
            }
            Util.close(null, preparedStatement, null);
        }
        if (!bl) {
            throw new BrokerException(this.br.getKString("B3016", transactionUID), 404);
        }
    }

    public void deleteAll(Connection connection) throws BrokerException {
        String string = null;
        if (Globals.getHAEnabled()) {
            string = new StringBuffer(128).append("BROKER_ID").append(" = '").append(DBManager.getDBManager().getBrokerID()).append("'").toString();
        }
        this.deleteAll(connection, string, null, 0);
    }

    public List takeover(Connection connection, String string, String string2) throws BrokerException {
        ArrayList<TransactionUID> arrayList = new ArrayList<TransactionUID>(100);
        String string3 = null;
        PreparedStatement preparedStatement = null;
        try {
            string3 = this.selectTakeoverSQL;
            preparedStatement = connection.prepareStatement(string3);
            preparedStatement.setString(1, string2);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                arrayList.add(new TransactionUID(resultSet.getLong(1)));
            }
            Util.close(resultSet, preparedStatement, null);
            string3 = this.takeoverSQL;
            preparedStatement = connection.prepareStatement(string3);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            int n = preparedStatement.executeUpdate();
            if (n != arrayList.size()) {
                Object[] objectArray = new String[]{string2, String.valueOf(arrayList.size()), String.valueOf(n)};
                throw new BrokerException(this.br.getKString("B3177", objectArray));
            }
        }
        catch (Exception exception) {
            try {
                try {
                    if (connection != null && !connection.getAutoCommit()) {
                        connection.rollback();
                    }
                }
                catch (SQLException sQLException) {
                    this.logger.log(32, "B4080", sQLException);
                }
                if (exception instanceof BrokerException) {
                    throw (BrokerException)exception;
                }
                Exception exception2 = exception instanceof IOException ? DBManager.wrapIOException("[" + string3 + "]", (IOException)exception) : (exception instanceof SQLException ? DBManager.wrapSQLException("[" + string3 + "]", (SQLException)exception) : exception);
                throw new BrokerException(this.br.getKString("B3178", string2), exception2);
            }
            catch (Throwable throwable) {
                Util.close(null, preparedStatement, null);
                throw throwable;
            }
        }
        Util.close(null, preparedStatement, null);
        return arrayList;
    }

    public TransactionState getTransactionState(Connection connection, TransactionUID transactionUID) throws BrokerException {
        TransactionState transactionState;
        block13: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block12: {
                transactionState = null;
                long l = transactionUID.longValue();
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectTxnStateSQL);
                    preparedStatement.setLong(1, l);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        try {
                            transactionState = (TransactionState)Util.readObject(resultSet, 1);
                        }
                        catch (IOException iOException) {
                            this.logger.logStack(32, "B4128", iOException);
                        }
                    } else {
                        throw new BrokerException(this.br.getKString("B3016", String.valueOf(l)), 404);
                    }
                    if (!bl) break block12;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectTxnStateSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4233", transactionUID), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block13;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return transactionState;
    }

    public long getAccessedTime(Connection connection, TransactionUID transactionUID) throws BrokerException {
        long l;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                l = -1L;
                long l2 = transactionUID.longValue();
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectAccessedTimeSQL);
                    preparedStatement.setLong(1, l2);
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) {
                        throw new BrokerException(this.br.getKString("B3016", String.valueOf(l2)), 404);
                    }
                    l = resultSet.getLong(1);
                    if (!bl) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectAccessedTimeSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4233", transactionUID), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return l;
    }

    public String getBroker(Connection connection, TransactionUID transactionUID) throws BrokerException {
        String string;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                string = null;
                long l = transactionUID.longValue();
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectBrokerSQL);
                    preparedStatement.setLong(1, l);
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) {
                        throw new BrokerException(this.br.getKString("B3016", String.valueOf(l)), 404);
                    }
                    string = resultSet.getString(1);
                    if (!bl) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectBrokerSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4233", transactionUID), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return string;
    }

    public List getTransactionsByBrokerID(Connection connection, String string) throws BrokerException {
        ArrayList<TransactionUID> arrayList;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                arrayList = new ArrayList<TransactionUID>();
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectTakeoverSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        arrayList.add(new TransactionUID(resultSet.getLong(1)));
                    }
                    if (!bl) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectTakeoverSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4235", string), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return arrayList;
    }

    public HashMap getAllTransactionStates(Connection connection) throws BrokerException {
        HashMap<TransactionUID, TransactionState> hashMap;
        block12: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block11: {
                hashMap = new HashMap<TransactionUID, TransactionState>();
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectAllStatesSQL);
                    preparedStatement.setString(1, dBManager.getBrokerID());
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        try {
                            long l = resultSet.getLong(1);
                            int n = resultSet.getInt(2);
                            TransactionState transactionState = (TransactionState)Util.readObject(resultSet, 3);
                            transactionState.setState(n);
                            hashMap.put(new TransactionUID(l), transactionState);
                        }
                        catch (IOException iOException) {
                            this.logger.logStack(32, "B4128", iOException);
                        }
                    }
                    if (!bl) break block11;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectAllStatesSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4032"), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block12;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return hashMap;
    }

    public int[] getTransactionUsageInfo(Connection connection, TransactionUID transactionUID) throws BrokerException {
        int[] nArray;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                nArray = new int[]{0, 0};
                long l = transactionUID.longValue();
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectUsageInfoSQL);
                    preparedStatement.setLong(1, l);
                    preparedStatement.setLong(2, l);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        nArray[0] = resultSet.getInt(1);
                        nArray[1] = resultSet.getInt(2);
                    }
                    if (!bl) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectUsageInfoSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4233", transactionUID), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return nArray;
    }

    public boolean hasTransaction(Connection connection, long l) throws BrokerException {
        boolean bl;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                bl = false;
                boolean bl2 = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl2 = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectAccessedTimeSQL);
                    preparedStatement.setLong(1, l);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        bl = true;
                    }
                    if (!bl2) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectAccessedTimeSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4233", String.valueOf(l)), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl2) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return bl;
    }

    public void checkTransaction(Connection connection, long l) throws BrokerException {
        if (!this.hasTransaction(connection, l)) {
            throw new BrokerException(this.br.getKString("B3016", String.valueOf(l)), 404);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public HashMap getDebugInfo(Connection connection) {
        int n;
        HashMap<String, String> hashMap;
        block16: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            boolean bl;
            block15: {
                hashMap = new HashMap<String, String>();
                n = -1;
                bl = false;
                preparedStatement = null;
                resultSet = null;
                if (connection == null) {
                    connection = DBManager.getDBManager().getConnection(true);
                    bl = true;
                }
                if (!(resultSet = (preparedStatement = connection.prepareStatement(this.selectCountSQL)).executeQuery()).next()) break block15;
                n = resultSet.getInt(1);
            }
            try {
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection);
                    break block16;
                }
                Util.close(resultSet, preparedStatement, null);
            }
            catch (BrokerException brokerException) {
                this.logger.log(32, brokerException.getMessage(), brokerException.getCause());
            }
            break block16;
            catch (Exception exception) {
                try {
                    this.logger.log(32, "B4166", (Object)this.selectCountSQL, (Throwable)exception);
                }
                catch (Throwable throwable) {
                    try {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                    }
                    catch (BrokerException brokerException) {
                        this.logger.log(32, brokerException.getMessage(), brokerException.getCause());
                    }
                    throw throwable;
                }
                try {
                    if (bl) {
                        Util.close(resultSet, preparedStatement, connection);
                    }
                    Util.close(resultSet, preparedStatement, null);
                }
                catch (BrokerException brokerException) {
                    this.logger.log(32, brokerException.getMessage(), brokerException.getCause());
                }
            }
        }
        hashMap.put("Transactions(" + this.tableName + ")", String.valueOf(n));
        return hashMap;
    }
}

