/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BrokerDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.ConsumerDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DAOFactory;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConstants;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBTool;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DestinationDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.MessageDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.TransactionDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.VersionDAO;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.XidImpl;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;

public class UpgradeHAStore
implements DBConstants {
    private BrokerResources br = Globals.getBrokerResources();
    private Logger logger = Globals.getLogger();
    private DBManager dbMgr = DBManager.getDBManager();
    private String brokerID = this.dbMgr.getBrokerID();

    UpgradeHAStore() throws BrokerException {
        if (!Globals.getHAEnabled()) {
            String string = this.br.getKString("B1230", this.brokerID);
            throw new BrokerException(this.br.getKString("B3208", string));
        }
    }

    void upgradeStore(Connection connection) throws BrokerException {
        Object object;
        this.logger.logToAll(8, this.br.getString("B1232", String.valueOf(400), this.brokerID));
        DAOFactory dAOFactory = this.dbMgr.getDAOFactory();
        int n = -1;
        try {
            VersionDAO versionDAO = dAOFactory.getVersionDAO();
            n = versionDAO.getStoreVersion(connection);
        }
        catch (BrokerException brokerException) {
            // empty catch block
        }
        boolean bl = false;
        if (n == 400) {
            BrokerDAO brokerDAO = dAOFactory.getBrokerDAO();
            object = brokerDAO.getBrokerInfo(connection, this.brokerID);
            if (object != null) {
                String string = this.br.getString("B1231", this.brokerID);
                throw new BrokerException(this.br.getKString("B3208", string));
            }
        } else if (n == -1) {
            bl = true;
        } else {
            String string = this.br.getString("B3092", String.valueOf(n), String.valueOf(400));
            throw new BrokerException(this.br.getKString("B3208", string));
        }
        try {
            if (bl) {
                DBTool.createTables(connection);
            }
        }
        catch (Throwable throwable) {
            object = this.dbMgr.getCreateDBURL();
            if (object == null || ((String)object).length() == 0) {
                object = this.dbMgr.getOpenDBURL();
            }
            String string = this.br.getKString("B3073", object);
            this.logger.logToAll(32, string, throwable);
            throw new BrokerException(string, throwable);
        }
        try {
            connection.setAutoCommit(false);
            this.upgradeDestinations(connection);
            this.upgradeInterests(connection);
            this.upgradeMessages(connection);
            this.upgradeTxns(connection);
            this.logger.logToAll(8, this.br.getString("B1106"));
        }
        catch (Exception exception) {
            this.logger.logToAll(32, "B1233", this.brokerID);
            try {
                object = dAOFactory.getDestinationDAO();
                object.deleteAll(connection);
                ConsumerDAO consumerDAO = dAOFactory.getConsumerDAO();
                consumerDAO.deleteAll(connection);
                MessageDAO messageDAO = dAOFactory.getMessageDAO();
                messageDAO.deleteAll(connection);
                TransactionDAO transactionDAO = dAOFactory.getTransactionDAO();
                transactionDAO.deleteAll(connection);
            }
            catch (Exception exception2) {
                this.logger.logStack(32, "B4117", "Failed to clean up after upgrade failed", (Throwable)exception2);
            }
            if (exception instanceof BrokerException) {
                throw (BrokerException)exception;
            }
            throw new BrokerException(this.br.getKString("B3208", exception.getMessage()), exception);
        }
    }

    void upgradeDestinations(Connection connection) throws BrokerException {
        DestinationDAO destinationDAO = this.dbMgr.getDAOFactory().getDestinationDAO();
        String string = "MQDST40S" + this.brokerID;
        String string2 = new StringBuffer(128).append("SELECT ").append("DESTINATION").append(", ").append("CREATED_TS").append(", ").append("CONNECTED_TS").append(", ").append("BROKER_ID").append(", ").append("ID").append(" FROM ").append(string).append(" WHERE ").append("ID").append(" NOT IN (SELECT ").append("ID").append(" FROM ").append(destinationDAO.getTableName()).append(")").toString();
        String string3 = new StringBuffer(128).append("INSERT INTO ").append(destinationDAO.getTableName()).append(" ( ").append("ID").append(", ").append("DESTINATION").append(", ").append("IS_LOCAL").append(", ").append("CONNECTION_ID").append(", ").append("CONNECTED_TS").append(", ").append("BROKER_ID").append(", ").append("CREATED_TS").append(") VALUES ( ?, ?, ?, ?, ?, ?, ? )").toString();
        boolean bl = this.dbMgr.supportsBatchUpdates();
        Statement statement = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Destination destination = null;
        try {
            preparedStatement = connection.prepareStatement(string3);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                Object object;
                Object object2 = Util.readObject(resultSet, 1);
                destination = (Destination)object2;
                long l = resultSet.getLong(2);
                String string4 = destination.getUniqueName();
                int n = destination.getIsLocal() ? 1 : 0;
                long l2 = -1L;
                long l3 = -1L;
                String string5 = null;
                if (n > 0) {
                    object = destination.getConnectionUID();
                    if (object != null) {
                        l3 = resultSet.getLong(3);
                        l2 = ((UID)object).longValue();
                    }
                    string5 = resultSet.getString(4);
                }
                try {
                    preparedStatement.setString(1, string4);
                    object = Util.setObject(preparedStatement, 2, destination);
                    ((ByteArrayInputStream)object).close();
                    preparedStatement.setInt(3, n);
                    Util.setLong(preparedStatement, 4, l2);
                    Util.setLong(preparedStatement, 5, l3);
                    Util.setString(preparedStatement, 6, string5);
                    preparedStatement.setLong(7, l);
                    if (bl) {
                        preparedStatement.addBatch();
                        continue;
                    }
                    preparedStatement.executeUpdate();
                }
                catch (IOException iOException) {
                    IOException iOException2 = DBManager.wrapIOException("[" + string3 + "]", iOException);
                    throw iOException2;
                }
                catch (SQLException sQLException) {
                    SQLException sQLException2 = DBManager.wrapSQLException("[" + string3 + "]", sQLException);
                    throw sQLException2;
                }
            }
            if (bl) {
                preparedStatement.executeBatch();
            }
            connection.commit();
        }
        catch (Exception exception) {
            try {
                String string6 = this.br.getKString("B4162", destination == null ? "loading" : destination.getUniqueName());
                this.logger.logStack(32, string6, exception);
                throw new BrokerException(string6, exception);
            }
            catch (Throwable throwable) {
                Util.close(resultSet, statement, null);
                Util.close(null, preparedStatement, null);
                throw throwable;
            }
        }
        Util.close(resultSet, statement, null);
        Util.close(null, preparedStatement, null);
    }

    private void upgradeInterests(Connection connection) throws BrokerException {
        ConsumerDAO consumerDAO = this.dbMgr.getDAOFactory().getConsumerDAO();
        String string = "MQCON40S" + this.brokerID;
        String string2 = new StringBuffer(128).append("SELECT ").append("CONSUMER").append(", ").append("CREATED_TS").append(", ").append("ID").append(" FROM ").append(string).append(" WHERE ").append("ID").append(" NOT IN (SELECT ").append("ID").append(" FROM ").append(consumerDAO.getTableName()).append(")").toString();
        String string3 = new StringBuffer(128).append("INSERT INTO ").append(consumerDAO.getTableName()).append(" ( ").append("ID").append(", ").append("CONSUMER").append(", ").append("DURABLE_NAME").append(", ").append("CLIENT_ID").append(", ").append("CREATED_TS").append(") VALUES ( ?, ?, ?, ?, ? )").toString();
        boolean bl = this.dbMgr.supportsBatchUpdates();
        PreparedStatement preparedStatement = null;
        Statement statement = null;
        ResultSet resultSet = null;
        Consumer consumer = null;
        try {
            preparedStatement = connection.prepareStatement(string3);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                Object object;
                consumer = (Consumer)Util.readObject(resultSet, 1);
                long l = resultSet.getLong(2);
                String string4 = null;
                String string5 = null;
                if (consumer instanceof Subscription) {
                    object = (Subscription)consumer;
                    string4 = ((Subscription)object).getDurableName();
                    string5 = ((Subscription)object).getClientID();
                }
                try {
                    preparedStatement.setLong(1, consumer.getConsumerUID().longValue());
                    object = Util.setObject(preparedStatement, 2, consumer);
                    Util.setString(preparedStatement, 3, string4);
                    Util.setString(preparedStatement, 4, string5);
                    preparedStatement.setLong(5, l);
                    ((ByteArrayInputStream)object).close();
                    if (bl) {
                        preparedStatement.addBatch();
                        continue;
                    }
                    preparedStatement.executeUpdate();
                }
                catch (IOException iOException) {
                    IOException iOException2 = DBManager.wrapIOException("[" + string3 + "]", iOException);
                    throw iOException2;
                }
                catch (SQLException sQLException) {
                    SQLException sQLException2 = DBManager.wrapSQLException("[" + string3 + "]", sQLException);
                    throw sQLException2;
                }
            }
            if (bl) {
                preparedStatement.executeBatch();
            }
            connection.commit();
        }
        catch (Exception exception) {
            try {
                String string6 = this.br.getKString("B4168", consumer == null ? "loading" : consumer.toString());
                this.logger.logStack(32, string6, exception);
                throw new BrokerException(string6, exception);
            }
            catch (Throwable throwable) {
                Util.close(resultSet, statement, null);
                Util.close(null, preparedStatement, null);
                throw throwable;
            }
        }
        Util.close(resultSet, statement, null);
        Util.close(null, preparedStatement, null);
    }

    private void upgradeMessages(Connection connection) throws BrokerException {
        String string = "MQMSG40S" + this.brokerID;
        String string2 = null;
        int n = 0;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            string2 = "SELECT COUNT(*) FROM " + string;
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string2);
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
        }
        catch (SQLException sQLException) {
            try {
                this.logger.log(32, "B4166", (Object)string2, (Throwable)sQLException);
                throw new BrokerException(this.br.getString("B4166", string2), sQLException);
            }
            catch (Throwable throwable) {
                Util.close(resultSet, statement, null);
                throw throwable;
            }
        }
        Util.close(resultSet, statement, null);
        this.logger.logToAll(8, this.br.getString("B1118", String.valueOf(n)));
        this.doUpgradeMsg(connection);
    }

    private void doUpgradeMsg(Connection connection) throws BrokerException {
        String string;
        Object object;
        Object object2;
        MessageDAO messageDAO = this.dbMgr.getDAOFactory().getMessageDAO();
        String string2 = "MQMSG40S" + this.brokerID;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string3 = new StringBuffer(128).append("SELECT ").append("MESSAGE").append(", ").append("BROKER_ID").append(", ").append("CREATED_TS").append(", ").append("ID").append(" FROM ").append(string2).append(" WHERE ").append("ID").append(" NOT IN (SELECT ").append("ID").append(" FROM ").append(messageDAO.getTableName()).append(")").toString();
        Statement statement = null;
        ResultSet resultSet = null;
        Packet packet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                packet = new Packet(false);
                packet.generateTimestamp(false);
                packet.generateSequenceNumber(false);
                object2 = resultSet.getBinaryStream(1);
                packet.readPacket((InputStream)object2);
                ((InputStream)object2).close();
                object = resultSet.getString(2);
                long l = resultSet.getLong(3);
                messageDAO.insert(connection, packet, null, null, (String)object, l, false);
                string = packet.getSysMessageID().getUniqueName();
                String string4 = DestinationUID.getUniqueString(packet.getDestination(), packet.getIsQueue());
                hashMap.put(string, string4);
            }
        }
        catch (Exception exception) {
            try {
                String string5 = this.br.getKString("B4163", packet == null ? "loading" : packet.getSysMessageID().getUniqueName());
                this.logger.logStack(32, string5, exception);
                throw new BrokerException(string5, exception);
            }
            catch (Throwable throwable) {
                Util.close(resultSet, statement, null);
                throw throwable;
            }
        }
        Util.close(resultSet, statement, null);
        object2 = this.dbMgr.getDAOFactory().getConsumerDAO();
        object = this.dbMgr.getDAOFactory().getConsumerStateDAO();
        String string6 = "MQCONSTATE40S" + this.brokerID;
        String string7 = new StringBuffer(128).append("SELECT ").append("MESSAGE_ID").append(", ").append("CONSUMER_ID").append(", ").append("STATE").append(", ").append("TRANSACTION_ID").append(", ").append("CREATED_TS").append(" FROM ").append(string6).append(" WHERE ").append("STATE").append(" <> ").append(2).toString();
        string = new StringBuffer(128).append("INSERT INTO ").append(object.getTableName()).append(" ( ").append("MESSAGE_ID").append(", ").append("CONSUMER_ID").append(", ").append("STATE").append(", ").append("TRANSACTION_ID").append(", ").append("CREATED_TS").append(") VALUES ( ?, ?, ?, ?, ? )").toString();
        boolean bl = this.dbMgr.supportsBatchUpdates();
        PreparedStatement preparedStatement = null;
        String string8 = null;
        long l = 0L;
        try {
            preparedStatement = connection.prepareStatement(string);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string7);
            while (resultSet.next()) {
                string8 = resultSet.getString(1);
                l = resultSet.getLong(2);
                int n = resultSet.getInt(3);
                long l2 = resultSet.getLong(4);
                long l3 = resultSet.getLong(5);
                String string9 = (String)hashMap.get(string8);
                if (string9 == null) continue;
                try {
                    preparedStatement.setString(1, string8);
                    preparedStatement.setLong(2, l);
                    preparedStatement.setInt(3, n);
                    preparedStatement.setLong(4, l2);
                    preparedStatement.setLong(5, l3);
                    if (bl) {
                        preparedStatement.addBatch();
                        continue;
                    }
                    preparedStatement.executeUpdate();
                }
                catch (SQLException sQLException) {
                    SQLException sQLException2 = DBManager.wrapSQLException("[" + string + "]", sQLException);
                    throw sQLException2;
                }
            }
            hashMap.clear();
            if (bl) {
                preparedStatement.executeBatch();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            String string10 = this.br.getKString("B4163", string8 == null ? "loading" : string8);
            this.logger.logStack(32, string10, sQLException);
            throw new BrokerException(string10, sQLException);
        }
        finally {
            Util.close(resultSet, statement, null);
            Util.close(null, preparedStatement, null);
        }
    }

    private void upgradeTxns(Connection connection) throws BrokerException {
        TransactionDAO transactionDAO = this.dbMgr.getDAOFactory().getTransactionDAO();
        String string = "MQTXN40S" + this.brokerID;
        String string2 = new StringBuffer(128).append("SELECT ID").append(", ").append("TXN_STATE").append(", ").append("BROKER_ID").append(" FROM ").append(string).append(" WHERE ").append("ID").append(" NOT IN (SELECT ").append("ID").append(" FROM ").append(transactionDAO.getTableName()).append(")").toString();
        String string3 = new StringBuffer(128).append("INSERT INTO ").append(transactionDAO.getTableName()).append(" ( ").append("ID").append(", ").append("STATE").append(", ").append("TXN_STATE").append(", ").append("AUTO_ROLLBACK").append(", ").append("XID").append(", ").append("BROKER_ID").append(", ").append("EXPIRED_TS").append(", ").append("ACCESSED_TS").append(") VALUES ( ?, ?, ?, ?, ?, ?, ?, ? )").toString();
        boolean bl = this.dbMgr.supportsBatchUpdates();
        PreparedStatement preparedStatement = null;
        Statement statement = null;
        ResultSet resultSet = null;
        TransactionUID transactionUID = null;
        try {
            preparedStatement = connection.prepareStatement(string3);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                Serializable serializable;
                long l = resultSet.getLong(1);
                transactionUID = new TransactionUID(l);
                TransactionState transactionState = (TransactionState)Util.readObject(resultSet, 2);
                String string4 = resultSet.getString(3);
                try {
                    preparedStatement.setLong(1, l);
                    preparedStatement.setInt(2, transactionState.getState());
                    ByteArrayInputStream byteArrayInputStream = Util.setObject(preparedStatement, 3, transactionState);
                    preparedStatement.setInt(4, transactionState.getType().intValue());
                    serializable = transactionState.getXid();
                    if (serializable != null) {
                        preparedStatement.setString(5, ((XidImpl)serializable).toString());
                    } else {
                        preparedStatement.setNull(5, 12);
                    }
                    preparedStatement.setString(6, string4);
                    preparedStatement.setLong(7, transactionState.getExpirationTime());
                    preparedStatement.setLong(8, transactionState.getLastAccessTime());
                    byteArrayInputStream.close();
                    if (bl) {
                        preparedStatement.addBatch();
                        continue;
                    }
                    preparedStatement.executeUpdate();
                }
                catch (IOException iOException) {
                    serializable = DBManager.wrapIOException("[" + string3 + "]", iOException);
                    throw serializable;
                }
                catch (SQLException sQLException) {
                    serializable = DBManager.wrapSQLException("[" + string3 + "]", sQLException);
                    throw serializable;
                }
            }
            if (bl) {
                preparedStatement.executeBatch();
            }
            connection.commit();
        }
        catch (Exception exception) {
            try {
                String string5 = this.br.getKString("B4172", transactionUID == null ? "loading" : transactionUID.toString());
                this.logger.logStack(32, string5, exception);
                throw new BrokerException(string5, exception);
            }
            catch (Throwable throwable) {
                Util.close(resultSet, statement, null);
                Util.close(null, preparedStatement, null);
                throw throwable;
            }
        }
        Util.close(resultSet, statement, null);
        Util.close(null, preparedStatement, null);
    }
}

