/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.io;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.PacketFlag;
import com.sun.messaging.jmq.io.PacketProperties;
import com.sun.messaging.jmq.io.PacketType;
import com.sun.messaging.jmq.io.SysMessageID;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StreamCorruptedException;
import java.util.Hashtable;

public class ReadOnlyPacket
implements Cloneable {
    public static final int MAGIC = 469754818;
    public static final short VERSION1 = 103;
    public static final short VERSION2 = 200;
    public static final short VERSION3 = 301;
    public static short defaultVersion = (short)301;
    protected static final int HEADER_SIZE = 72;
    protected byte[] headerBuffer = new byte[72];
    protected byte[] ropBuffer = null;
    protected int ropLength = 0;
    protected int version = defaultVersion;
    protected int magic = 469754818;
    protected int packetType = 0;
    protected int packetSize = 0;
    protected long expiration = 0L;
    protected int propertyOffset = 0;
    protected int propertySize = 0;
    protected int encryption = 0;
    protected long transactionID = 0L;
    protected int priority = 5;
    protected int bitFlags = 0;
    protected long consumerID = 0L;
    protected SysMessageID sysMessageID = new SysMessageID();
    protected String destination = null;
    protected String destinationClass = null;
    protected String messageID = null;
    protected String correlationID = null;
    protected String replyTo = null;
    protected String replyToClass = null;
    protected String messageType = null;
    protected long producerID = 0L;
    protected boolean stringsParsed = false;
    protected Hashtable properties = null;

    public ReadOnlyPacket() {
        this.reset();
    }

    public static void setDefaultVersion(short s) {
        defaultVersion = s;
    }

    public void readPacket(InputStream inputStream) throws IOException, EOFException, StreamCorruptedException, IllegalArgumentException {
        this.readFixedHeader(inputStream);
        this.readRestOfPacket(inputStream);
    }

    public void retryReadPacket(InputStream inputStream) throws IOException, EOFException, StreamCorruptedException, IllegalArgumentException {
        if (this.packetSize == 0) {
            this.readPacket(inputStream);
        } else {
            this.readRestOfPacket(inputStream);
        }
    }

    private void readFixedHeader(InputStream inputStream) throws IOException, EOFException, StreamCorruptedException {
        this.reset();
        this.readFully(inputStream, this.headerBuffer, 0, 72, false);
        this.parseHeader(new ByteArrayInputStream(this.headerBuffer));
    }

    private void readRestOfPacket(InputStream inputStream) throws IOException, EOFException, IllegalArgumentException {
        this.ropLength = this.packetSize - 72;
        if (this.ropBuffer == null || this.ropBuffer.length < this.ropLength || this.ropBuffer.length > 2 * this.ropLength) {
            this.ropBuffer = null;
            this.ropBuffer = new byte[this.ropLength];
        }
        this.readFully(inputStream, this.ropBuffer, 0, this.ropLength, true);
        if (this.version != 103 && this.version != 200 && this.version != 301) {
            throw new IllegalArgumentException("Bad packet version number: " + this.version + ". Expecting: " + 103 + " or " + 200 + " or " + 301);
        }
        if (this.propertyOffset != 72) {
            this.parseVariableFields(new ByteArrayInputStream(this.ropBuffer));
        }
    }

    private void readFully(InputStream inputStream, byte[] byArray, int n, int n2, boolean bl) throws IOException, EOFException, InterruptedIOException {
        int n3;
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < n2; i += n3) {
            n3 = 0;
            try {
                n3 = inputStream.read(byArray, n + i, n2 - i);
            }
            catch (InterruptedIOException interruptedIOException) {
                if (!bl && i == 0 && n3 == 0 && interruptedIOException.bytesTransferred == 0) {
                    throw new InterruptedIOException("no data available");
                }
                n3 = interruptedIOException.bytesTransferred;
                Thread.currentThread();
                Thread.yield();
            }
            if (n3 >= 0) continue;
            throw new EOFException();
        }
    }

    private void parseHeader(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        this.magic = dataInputStream.readInt();
        if (this.magic != 469754818) {
            throw new StreamCorruptedException("Bad packet magic number: " + this.magic + ". Expecting: " + 469754818);
        }
        this.version = dataInputStream.readShort();
        this.packetType = dataInputStream.readShort();
        this.packetSize = dataInputStream.readInt();
        if (this.version == 103) {
            this.transactionID = dataInputStream.readInt();
        }
        this.expiration = dataInputStream.readLong();
        this.sysMessageID.readID(dataInputStream);
        this.propertyOffset = dataInputStream.readInt();
        this.propertySize = dataInputStream.readInt();
        this.priority = dataInputStream.readByte();
        this.encryption = dataInputStream.readUnsignedByte();
        this.bitFlags = dataInputStream.readUnsignedShort();
        this.consumerID = this.version == 103 ? (long)dataInputStream.readInt() : dataInputStream.readLong();
    }

    public boolean getFlag(int n) {
        return (this.bitFlags & n) == n;
    }

    private void parseVariableFields(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        short s = dataInputStream.readShort();
        while (s != 0) {
            switch (s) {
                case 1: {
                    String string;
                    this.destination = string = dataInputStream.readUTF();
                    break;
                }
                case 8: {
                    int n = dataInputStream.readUnsignedShort();
                    this.transactionID = dataInputStream.readLong();
                    break;
                }
                case 9: {
                    int n = dataInputStream.readUnsignedShort();
                    this.producerID = dataInputStream.readLong();
                    break;
                }
                case 2: {
                    String string;
                    this.messageID = string = dataInputStream.readUTF();
                    break;
                }
                case 3: {
                    String string;
                    this.correlationID = string = dataInputStream.readUTF();
                    break;
                }
                case 4: {
                    String string;
                    this.replyTo = string = dataInputStream.readUTF();
                    break;
                }
                case 5: {
                    String string;
                    this.messageType = string = dataInputStream.readUTF();
                    break;
                }
                case 6: {
                    String string;
                    this.destinationClass = string = dataInputStream.readUTF();
                    break;
                }
                case 7: {
                    String string;
                    this.replyToClass = string = dataInputStream.readUTF();
                    break;
                }
                default: {
                    dataInputStream.skipBytes(dataInputStream.readUnsignedShort());
                }
            }
            s = dataInputStream.readShort();
        }
        this.stringsParsed = true;
    }

    private void parseProperties(InputStream inputStream) throws IOException, ClassNotFoundException {
        if (this.version == 301) {
            this.properties = PacketProperties.parseProperties(inputStream);
        } else {
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            this.properties = (Hashtable)objectInputStream.readObject();
        }
    }

    public void writePacket(OutputStream outputStream) throws IOException {
        outputStream.write(this.headerBuffer, 0, 72);
        if (this.ropBuffer != null) {
            outputStream.write(this.ropBuffer, 0, this.ropLength);
        }
        outputStream.flush();
    }

    public void writePacket(OutputStream outputStream, int n) throws IOException {
        if (n == this.version) {
            this.writePacket(outputStream);
        } else {
            this.writePacket(outputStream, n, this.consumerID, this.getFlag(4), this.getFlag(2), this.getFlag(32));
        }
    }

    public void writePacket(OutputStream outputStream, long l, boolean bl, boolean bl2, boolean bl3) throws IOException {
        this.writePacket(outputStream, this.version, l, bl, bl2, bl3);
    }

    public void writePacket(OutputStream outputStream, int n, long l, boolean bl, boolean bl2, boolean bl3) throws IOException {
        if (this.headerBuffer == null) {
            throw new IOException("No buffer to write");
        }
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        if (n == this.version) {
            if (n == 103) {
                dataOutputStream.write(this.headerBuffer, 0, 66);
            } else {
                dataOutputStream.write(this.headerBuffer, 0, 62);
            }
        } else {
            this.version = n;
            dataOutputStream.writeInt(469754818);
            dataOutputStream.writeShort(this.version);
            dataOutputStream.writeShort(this.packetType);
            dataOutputStream.writeInt(this.packetSize);
            if (this.version == 103) {
                dataOutputStream.writeInt((int)this.transactionID);
            }
            dataOutputStream.writeLong(this.expiration);
            this.sysMessageID.writeID(dataOutputStream);
            dataOutputStream.writeInt(this.propertyOffset);
            dataOutputStream.writeInt(this.propertySize);
            dataOutputStream.writeByte(this.priority);
            dataOutputStream.writeByte(this.encryption);
        }
        int n2 = this.bitFlags;
        n2 = bl2 ? (n2 |= 2) : (n2 &= 0xFFFFFFFD);
        n2 = bl3 ? (n2 |= 0x20) : (n2 &= 0xFFFFFFDF);
        n2 = bl ? (n2 |= 0x40) : (n2 &= 0xFFFFFFBF);
        dataOutputStream.writeShort(n2);
        if (n == 103) {
            dataOutputStream.writeInt((int)l);
        } else {
            dataOutputStream.writeLong(l);
        }
        if (this.ropBuffer != null) {
            dataOutputStream.write(this.ropBuffer, 0, this.ropLength);
        }
        dataOutputStream.flush();
    }

    public boolean isEqual(SysMessageID sysMessageID) {
        return this.sysMessageID.equals(sysMessageID);
    }

    public int getVersion() {
        return this.version;
    }

    public int getMagic() {
        return this.magic;
    }

    public int getPacketType() {
        return this.packetType;
    }

    public int getPacketSize() {
        return this.packetSize;
    }

    public long getTimestamp() {
        return this.sysMessageID.timestamp;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public int getPort() {
        return this.sysMessageID.port;
    }

    public String getIPString() {
        return this.sysMessageID.toString();
    }

    public byte[] getIP() {
        return this.sysMessageID.getIPAddress();
    }

    public int getSequence() {
        return this.sysMessageID.sequence;
    }

    public int getPropertyOffset() {
        return this.propertyOffset;
    }

    public int getPropertySize() {
        return this.propertySize;
    }

    public int getEncryption() {
        return this.encryption;
    }

    public int getPriority() {
        return this.priority;
    }

    public long getTransactionID() {
        return this.transactionID;
    }

    public long getProducerID() {
        return this.producerID;
    }

    public long getConsumerID() {
        return this.consumerID;
    }

    public int getInterestID() {
        return (int)this.getConsumerID();
    }

    public boolean getPersistent() {
        return this.getFlag(4);
    }

    public boolean getRedelivered() {
        return this.getFlag(2);
    }

    public boolean getIsQueue() {
        return this.getFlag(1);
    }

    public boolean getSelectorsProcessed() {
        return this.getFlag(8);
    }

    public boolean getSendAcknowledge() {
        return this.getFlag(16);
    }

    public boolean getIsLast() {
        return this.getFlag(32);
    }

    public boolean getFlowPaused() {
        return this.getFlag(64);
    }

    public boolean getIsTransacted() {
        return this.getFlag(128);
    }

    public boolean getConsumerFlow() {
        return this.getFlag(256);
    }

    public boolean getIndempotent() {
        return this.getFlag(2048);
    }

    public String getDestination() {
        return this.destination;
    }

    public String getDestinationClass() {
        return this.destinationClass;
    }

    public String getMessageID() {
        if (this.messageID == null) {
            return this.sysMessageID.toString();
        }
        return this.messageID;
    }

    public String getCorrelationID() {
        return this.correlationID;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public String getReplyToClass() {
        return this.replyToClass;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public SysMessageID getSysMessageID() {
        return this.sysMessageID;
    }

    public int getMessageBodySize() {
        return this.packetSize - this.propertyOffset - this.propertySize;
    }

    public InputStream getMessageBodyStream() {
        int n = this.propertyOffset - 72 + this.propertySize;
        int n2 = this.ropLength - n;
        if (this.ropBuffer == null || n2 <= 0) {
            return null;
        }
        return new ByteArrayInputStream(this.ropBuffer, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getProperties() throws IOException, ClassNotFoundException {
        if (this.properties == null && this.propertySize > 0) {
            ReadOnlyPacket readOnlyPacket = this;
            synchronized (readOnlyPacket) {
                if (this.properties == null) {
                    this.parseProperties(new ByteArrayInputStream(this.ropBuffer, this.propertyOffset - 72, this.propertySize));
                }
            }
        }
        return this.properties;
    }

    protected void reset() {
        this.version = defaultVersion;
        this.magic = 469754818;
        this.ropLength = 0;
        this.packetType = 0;
        this.packetSize = 0;
        this.expiration = 0L;
        this.propertyOffset = 0;
        this.propertySize = 0;
        this.encryption = 0;
        this.priority = 5;
        this.bitFlags = 0;
        this.consumerID = 0L;
        this.producerID = 0L;
        this.transactionID = 0L;
        this.sysMessageID.clear();
        this.destination = null;
        this.destinationClass = null;
        this.messageID = null;
        this.correlationID = null;
        this.replyTo = null;
        this.replyToClass = null;
        this.messageType = null;
        this.stringsParsed = false;
        this.properties = null;
    }

    public Object cloneShallow() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println("ReadOnlyPacket: Could not clone: " + cloneNotSupportedException);
            return null;
        }
    }

    public Object clone() {
        ReadOnlyPacket readOnlyPacket = (ReadOnlyPacket)this.cloneShallow();
        if (this.headerBuffer != null) {
            readOnlyPacket.headerBuffer = (byte[])this.headerBuffer.clone();
        }
        if (this.ropBuffer != null) {
            readOnlyPacket.ropBuffer = (byte[])this.ropBuffer.clone();
        }
        if (this.properties != null) {
            readOnlyPacket.properties = (Hashtable)this.properties.clone();
        }
        readOnlyPacket.sysMessageID = (SysMessageID)this.sysMessageID.clone();
        return readOnlyPacket;
    }

    public String toString() {
        return PacketType.getString(this.packetType) + ":" + this.sysMessageID.toString();
    }

    public String toVerboseString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.dump(new PrintStream(byteArrayOutputStream));
        return byteArrayOutputStream.toString();
    }

    public void dump(PrintStream printStream) {
        printStream.println("******** Packet: " + this.toString() + "\n" + "  Magic/Version: " + this.magic + "/" + this.version + "\tSize: " + this.packetSize + "\t Type: " + PacketType.getString(this.packetType) + "\n" + "     Expiration: " + this.expiration + (this.version == 103 ? "   TransactionID: " + this.transactionID : "\t") + "       Timestamp: " + this.sysMessageID.timestamp + "\n" + "      Source IP: " + this.sysMessageID.ip.toString() + "\t  Source Port: " + this.sysMessageID.port + "\tSequence: " + this.sysMessageID.sequence + "\n" + "Property Offset: " + this.propertyOffset + "\t\t\tProperty Size: " + this.propertySize + "\n" + "     Encryption: " + this.encryption + "\tPriority: " + this.priority + "\n" + "          Flags: " + PacketFlag.getString(this.bitFlags) + "\t\t\t   consumerID: " + this.consumerID);
        if (this.version >= 200) {
            printStream.println("  TransactionID: " + this.getTransactionID());
        }
        if (this.getProducerID() != 0L) {
            printStream.println("      ProducerID: " + this.getProducerID());
        }
        if (this.destination != null) {
            printStream.println("     Destination: " + this.destination);
        }
        if (this.destinationClass != null) {
            printStream.println("DestinationClass: " + this.destinationClass);
        }
        if (this.messageID != null) {
            printStream.println("       MessageID: " + this.messageID);
        }
        if (this.correlationID != null) {
            printStream.println("   CorrelationID: " + this.correlationID);
        }
        if (this.replyTo != null) {
            printStream.println("         ReplyTo: " + this.replyTo);
        }
        if (this.replyToClass != null) {
            printStream.println("    ReplyToClass: " + this.replyToClass);
        }
        if (this.messageType != null) {
            printStream.println("     MessageType: " + this.messageType);
        }
        Hashtable hashtable = null;
        try {
            hashtable = this.getProperties();
        }
        catch (Exception exception) {
            printStream.println("Exception getting properties: " + exception.getMessage());
        }
        if (hashtable == null) {
            printStream.println("     Properties: null");
        } else {
            printStream.println("     Properties: " + hashtable);
        }
        Packet.dumpBody(printStream, this.packetType, this.getMessageBodyStream(), this.getMessageBodySize(), hashtable);
        printStream.println("Internal headerBuffer: " + this.headerBuffer + " " + this.headerBuffer.length + " bytes");
        if (this.ropBuffer != null) {
            printStream.println("   Internal ropBuffer: " + this.ropBuffer + " " + this.ropBuffer.length + " bytes" + ", content: " + this.ropLength + " bytes");
        } else {
            printStream.println("   Internal ropBuffer: null");
        }
    }
}

