/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import javax.net.ServerSocketFactory;

public class MQServerSocketFactory
extends ServerSocketFactory {
    boolean reuseAddr = true;
    ServerSocketFactory ssf = null;

    protected MQServerSocketFactory() {
        this.ssf = null;
    }

    protected MQServerSocketFactory(ServerSocketFactory serverSocketFactory) {
        this.ssf = serverSocketFactory;
    }

    public ServerSocket createServerSocket() throws IOException {
        ServerSocket serverSocket = this.ssf != null ? this.ssf.createServerSocket() : new ServerSocket();
        serverSocket.setReuseAddress(this.reuseAddr);
        return serverSocket;
    }

    public ServerSocket createServerSocket(int n) throws IOException {
        ServerSocket serverSocket = this.createServerSocket();
        serverSocket.bind(new InetSocketAddress(n));
        return serverSocket;
    }

    public ServerSocket createServerSocket(int n, int n2) throws IOException {
        ServerSocket serverSocket = this.createServerSocket();
        serverSocket.bind(new InetSocketAddress(n), n2);
        return serverSocket;
    }

    public ServerSocket createServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        ServerSocket serverSocket = this.createServerSocket();
        serverSocket.bind(new InetSocketAddress(inetAddress, n), n2);
        return serverSocket;
    }

    public static ServerSocketFactory getDefault() {
        return new MQServerSocketFactory();
    }

    public static ServerSocketFactory wrapFactory(ServerSocketFactory serverSocketFactory) {
        return new MQServerSocketFactory(serverSocketFactory);
    }

    public static String serverSocketToString(ServerSocket serverSocket) {
        try {
            return "SO_RCVBUF=" + serverSocket.getReceiveBufferSize() + ", SO_REUSEADDR=" + serverSocket.getReuseAddress() + ", SO_TIMEOUT=" + serverSocket.getSoTimeout();
        }
        catch (IOException iOException) {
            return "Bad serverSocket: " + iOException;
        }
    }
}

