/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.io.MetricData;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.Monitor;
import com.sun.messaging.jmq.jmsserver.util.MetricManager;
import java.util.Hashtable;
import java.util.Iterator;

class BrokerMetricsMonitor
extends Monitor {
    public BrokerMetricsMonitor(Destination destination) {
        super(destination);
    }

    protected Hashtable getMonitorData() {
        Hashtable<String, Long> hashtable = new Hashtable<String, Long>();
        MetricManager metricManager = Globals.getMetricManager();
        MetricData metricData = metricManager.getMetrics();
        hashtable.put("numConnections", new Long(metricData.nConnections));
        hashtable.put("numMsgsIn", new Long(metricData.totals.messagesIn));
        hashtable.put("numMsgsOut", new Long(metricData.totals.messagesOut));
        hashtable.put("numMsgs", new Long(Destination.totalCount()));
        hashtable.put("msgBytesIn", new Long(metricData.totals.messageBytesIn));
        hashtable.put("msgBytesOut", new Long(metricData.totals.messageBytesOut));
        hashtable.put("numPktsIn", new Long(metricData.totals.packetsIn));
        hashtable.put("numPktsOut", new Long(metricData.totals.packetsOut));
        hashtable.put("pktBytesIn", new Long(metricData.totals.packetBytesIn));
        hashtable.put("pktBytesOut", new Long(metricData.totals.packetBytesOut));
        hashtable.put("totalMsgBytes", new Long(Destination.totalBytes()));
        Iterator iterator = Destination.getAllDestinations();
        long l = 0L;
        while (iterator.hasNext()) {
            Destination destination = (Destination)iterator.next();
            if (destination.isInternal() || destination.isAdmin() || destination.getDestinationName().equals("__JMQAdmin")) continue;
            ++l;
        }
        hashtable.put("numDestinations", new Long(l));
        return hashtable;
    }
}

