/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.AccessController;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.license.LicenseBase;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.Hashtable;

public class ClientIDHandler
extends PacketHandler {
    private Logger logger = Globals.getLogger();
    public static boolean DEBUG;
    public static boolean CAN_USE_SHARED_CONSUMERS;
    static final /* synthetic */ boolean $assertionsDisabled;

    public boolean handle(IMQConnection iMQConnection, Packet packet) throws BrokerException {
        Hashtable<String, Object> hashtable;
        Packet packet2;
        block31: {
            block30: {
                Boolean bl;
                Hashtable hashtable2;
                String string;
                int n;
                block29: {
                    boolean bl2 = packet.getIndempontent();
                    packet2 = new Packet(iMQConnection.useDirectBuffers());
                    packet2.setConsumerID(packet.getConsumerID());
                    packet2.setPacketType(51);
                    hashtable = new Hashtable<String, Object>();
                    n = 200;
                    string = null;
                    hashtable2 = null;
                    try {
                        hashtable2 = packet.getProperties();
                    }
                    catch (Exception exception) {
                        this.logger.log(8, "Internal Error: unable to retrieve  properties from clientID message " + packet, exception);
                        hashtable2 = new Hashtable();
                        if ($assertionsDisabled) break block29;
                        throw new AssertionError();
                    }
                }
                String string2 = null;
                boolean bl3 = false;
                String string3 = null;
                if (hashtable2 != null) {
                    string2 = (String)hashtable2.get("JMQClientID");
                    string3 = (String)hashtable2.get("JMQNamespace");
                    bl = (Boolean)hashtable2.get("JMQShare");
                    bl3 = bl == null ? string3 != null : bl;
                } else if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                this.logger.log(4, "ClientID[" + string3 + "," + string2 + "," + bl3 + "] ");
                if (DEBUG) {
                    this.logger.log(4, "ClientIDHandler: registering clientID " + string2);
                }
                try {
                    Boolean bl4 = bl = string2 == null ? null : this.validate(string2, iMQConnection);
                    if (bl3 && !CAN_USE_SHARED_CONSUMERS) {
                        this.logger.log(16, "B4180", (Object)Globals.getBrokerResources().getKString("B0072"), bl);
                        throw new BrokerException(Globals.getBrokerResources().getKString("B4180", Globals.getBrokerResources().getKString("B0072"), bl), "B4180", null, 405);
                    }
                    String string4 = (String)iMQConnection.getClientData("client id");
                    if (DEBUG && string4 != null) {
                        this.logger.log(4, "ClientIDHandler: replacing clientID " + string4 + " with " + (String)((Object)bl));
                    }
                    if (!(bl == null || string4 != null && string4.equals(bl))) {
                        Connection connection;
                        String string5;
                        String string6 = string5 = string3 == null ? null : string3.toString() + "${%%}" + string2;
                        if (string5 != null && !Globals.getClusterBroadcast().lockClientID(string5, iMQConnection.getConnectionUID(), false)) {
                            this.logger.log(8, "B1033", (Object)iMQConnection.getRemoteConnectionString(), string5);
                            connection = Globals.getConnectionManager().matchProperty("client id", string5);
                            if (!$assertionsDisabled && connection != null && !(connection instanceof IMQConnection)) {
                                throw new AssertionError();
                            }
                            if (connection == null) {
                                this.logger.log(8, "B1135", string5);
                            } else {
                                this.logger.log(8, "B1134", (Object)string5, ((IMQConnection)connection).getRemoteConnectionString());
                            }
                            string = "conflict w/ clientID";
                            n = 409;
                        }
                        if (n != 409 && !Globals.getClusterBroadcast().lockClientID((String)((Object)bl), iMQConnection.getConnectionUID(), bl3)) {
                            this.logger.log(8, "B1033", (Object)iMQConnection.getRemoteConnectionString(), bl);
                            connection = Globals.getConnectionManager().matchProperty("client id", bl);
                            if (!$assertionsDisabled && connection != null && !(connection instanceof IMQConnection)) {
                                throw new AssertionError();
                            }
                            if (connection == null) {
                                this.logger.log(8, "B1135", bl);
                            } else {
                                this.logger.log(8, "B1134", (Object)bl, ((IMQConnection)connection).getRemoteConnectionString());
                            }
                            string = "conflict w/ clientID";
                            n = 409;
                        }
                    } else if (string4 != null && !string4.equals(bl)) {
                        this.logger.log(4, "ClientIDHandler: removing old clientID " + string4);
                        Globals.getClusterBroadcast().unlockClientID(string4, iMQConnection.getConnectionUID());
                        iMQConnection.removeClientData("client id");
                    }
                    if (bl != null && n != 409) {
                        iMQConnection.addClientData("client id", bl);
                    }
                }
                catch (BrokerException brokerException) {
                    this.logger.log(16, "B2024", string2, iMQConnection.toString(), brokerException);
                    n = 400;
                    string = brokerException.getMessage();
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    throw outOfMemoryError;
                }
                catch (Throwable throwable) {
                    this.logger.log(16, "B3100", (Object)"unexpected error processing clientid ", throwable);
                    string = throwable.getMessage();
                    n = 500;
                }
                hashtable.put("JMQStatus", new Integer(n));
                if (string != null) {
                    hashtable.put("JMQReason", string);
                }
                if (IMQConnection.DUMP_PACKET) break block30;
                if (!IMQConnection.OUT_DUMP_PACKET) break block31;
            }
            hashtable.put("JMQReqID", packet.getSysMessageID().toString());
        }
        packet2.setProperties(hashtable);
        iMQConnection.sendControlMessage(packet2);
        return true;
    }

    private String validate(String string, Connection connection) throws BrokerException {
        String string2 = string;
        if (string != null) {
            if (string.startsWith("${u}")) {
                AccessController accessController = connection.getAccessController();
                String string3 = accessController.getAuthenticatedName().getName();
                string2 = "${u:" + string3 + "}" + string.substring(4);
            } else if (string.startsWith("${u:")) {
                string2 = null;
            } else if (string.indexOf("${%%}") != -1) {
                this.logger.log(4, "bad client id ${%%}");
                string2 = null;
            }
        }
        if (string2 == null) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4109", string == null ? "null" : string));
        }
        if (DEBUG) {
            this.logger.log(4, "ClientIDHandler:validated client ID:" + string2 + ":");
        }
        return string2;
    }

    static {
        $assertionsDisabled = !ClientIDHandler.class.desiredAssertionStatus();
        DEBUG = false;
        CAN_USE_SHARED_CONSUMERS = false;
        try {
            LicenseBase licenseBase = Globals.getCurrentLicense(null);
            CAN_USE_SHARED_CONSUMERS = licenseBase.getBooleanProperty("imq.enable_shared_sub", false);
        }
        catch (BrokerException brokerException) {
            CAN_USE_SHARED_CONSUMERS = false;
        }
    }
}

