/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.io.JMQByteBufferInputStream;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.PacketType;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.core.SessionUID;
import com.sun.messaging.jmq.jmsserver.data.AutoRollbackType;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.handlers.RefCompare;
import com.sun.messaging.jmq.jmsserver.management.agent.Agent;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.PacketUtil;
import com.sun.messaging.jmq.jmsserver.util.lists.RemoveReason;
import com.sun.messaging.jmq.util.CacheHashMap;
import com.sun.messaging.jmq.util.JMQXid;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;

public class TransactionHandler
extends PacketHandler {
    private TransactionList translist = null;
    public static boolean DEBUG = false;
    FaultInjection fi = FaultInjection.getInjection();
    static boolean useNewProtocol = Globals.useNewTxnProtocol();

    public TransactionHandler(TransactionList transactionList) {
        this.translist = transactionList;
    }

    static boolean useNewProtocol() {
        return useNewProtocol;
    }

    public void sendReply(IMQConnection iMQConnection, Packet packet, int n, int n2, long l, String string) {
        if (FaultInjection.FAULT_INJECTION) {
            this.checkFIAfterProcess(packet.getPacketType());
        }
        Packet packet2 = new Packet(iMQConnection.useDirectBuffers());
        packet2.setPacketType(n);
        packet2.setConsumerID(packet.getConsumerID());
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("JMQStatus", new Integer(n2));
        if (string != null) {
            hashtable.put("JMQReason", string);
        }
        if (l != 0L) {
            hashtable.put("JMQTransactionID", new Long(l));
        }
        packet2.setProperties(hashtable);
        iMQConnection.sendControlMessage(packet2);
        if (FaultInjection.FAULT_INJECTION) {
            this.checkFIAfterReply(packet.getPacketType());
        }
    }

    public void sendReplyBody(IMQConnection iMQConnection, Packet packet, int n, int n2, Hashtable hashtable, byte[] byArray) {
        Packet packet2;
        block6: {
            block5: {
                packet2 = new Packet(iMQConnection.useDirectBuffers());
                packet2.setPacketType(n);
                packet2.setConsumerID(packet.getConsumerID());
                if (hashtable == null) {
                    hashtable = new Hashtable<String, Integer>();
                }
                hashtable.put("JMQStatus", new Integer(n2));
                if (IMQConnection.DUMP_PACKET) break block5;
                if (!IMQConnection.OUT_DUMP_PACKET) break block6;
            }
            hashtable.put("JMQReqID", (Integer)((Object)packet.getSysMessageID().toString()));
        }
        packet2.setProperties(hashtable);
        if (byArray != null) {
            packet2.setMessageBody(byArray);
        }
        iMQConnection.sendControlMessage(packet2);
    }

    public long getJMQTransactionID(Hashtable hashtable) {
        if (hashtable != null) {
            Object v = hashtable.get("JMQTransactionID");
            if (v != null && v instanceof Integer) {
                return ((Integer)v).intValue();
            }
            if (v != null) {
                return (Long)v;
            }
        }
        return 0L;
    }

    public static void convertPacketTid(IMQConnection iMQConnection, Packet packet) {
        long l = packet.getTransactionID();
        HashMap hashMap = (HashMap)iMQConnection.getClientData("tidmap");
        if (hashMap == null) {
            return;
        }
        TransactionUID transactionUID = (TransactionUID)hashMap.get(new Long(l));
        if (transactionUID == null) {
            return;
        }
        packet.setTransactionID(transactionUID.longValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public boolean handle(IMQConnection var1_1, Packet var2_2) throws BrokerException {
        block93: {
            block94: {
                block92: {
                    var3_3 = 0L;
                    var5_4 = null;
                    var6_5 = null;
                    var7_6 = null;
                    var8_7 = null;
                    var9_8 = false;
                    var10_9 = true;
                    var11_10 = var2_2.getIndempontent();
                    var12_11 = false;
                    var13_12 = null;
                    var14_13 = null;
                    try {
                        var13_12 = var2_2.getProperties();
                        if (var13_12 == null) {
                            var13_12 = new Hashtable<K, V>();
                        }
                    }
                    catch (Exception var15_14) {
                        this.logger.log(8, "Internal Error: unable to retrieve  properties from transaction message " + var2_2, var15_14);
                        var13_12 = new Hashtable<K, V>();
                    }
                    var15_15 = (Boolean)var13_12.get("JMQRedeliver");
                    var9_8 = var15_15 == null ? false : var15_15;
                    var16_16 = (Boolean)var13_12.get("JMQSetRedelivered");
                    v0 = var10_9 = var16_16 == null ? true : var16_16;
                    if (TransactionHandler.DEBUG) {
                        this.logger.log(4, "JMQRedeliver flag is " + var15_15);
                    }
                    if ((var17_17 = (ArrayList<TransactionUID>)var1_1.getClientData("transaction")) == null) {
                        var17_17 = new ArrayList<TransactionUID>();
                        var1_1.addClientData("transaction", var17_17);
                    }
                    if ((var18_18 = var2_2.getMessageBody()) != null) {
                        var19_19 = new JMQByteBufferInputStream(var18_18);
                        try {
                            var7_6 = JMQXid.read(new DataInputStream((InputStream)var19_19));
                        }
                        catch (IOException var20_20) {
                            this.logger.log(32, "B3100", "Could not decode xid from packet: " + var20_20 + " Ignoring " + PacketType.getString(var2_2.getPacketType()));
                            var14_13 = var20_20.getMessage();
                            this.sendReply(var1_1, var2_2, var2_2.getPacketType() + 1, 400, 0L, var14_13);
                            return true;
                        }
                    }
                    if (var13_12 != null) {
                        var8_7 = (Integer)var13_12.get("JMQXAFlags");
                    }
                    var19_19 = null;
                    var20_21 = var1_1;
                    synchronized (var20_21) {
                        var19_19 = (HashMap)var1_1.getClientData("tidmap");
                        if (var19_19 == null) {
                            var19_19 = new HashMap<Long, TransactionUID>();
                            var1_1.addClientData("tidmap", var19_19);
                        }
                    }
                    var3_3 = this.getJMQTransactionID(var13_12);
                    if (FaultInjection.FAULT_INJECTION) {
                        this.checkFIBeforeProcess(var2_2.getPacketType());
                    }
                    if (var2_2.getPacketType() != 44 || var8_7 != null && !TransactionState.isFlagSet(0, var8_7)) break block92;
                    if (var11_10) {
                        var5_4 = this.translist.getTransaction(var2_2.getSysMessageID());
                        if (var5_4 != null) {
                            var12_11 = true;
                        } else {
                            var5_4 = new TransactionUID();
                        }
                    } else {
                        var5_4 = new TransactionUID();
                    }
                    break block93;
                }
                if (var2_2.getPacketType() != 60) break block94;
                if (var3_3 != 0L) {
                    var5_4 = new TransactionUID(var3_3);
                }
                var7_6 = null;
                break block93;
            }
            if (var3_3 != 0L || var7_6 == null) ** GOTO lbl83
            var5_4 = this.translist.xidToUID(var7_6);
            if (var5_4 != null) {
                var3_3 = var5_4.longValue();
            } else {
                this.logger.log(16, PacketType.getString(var2_2.getPacketType()) + ": Ignoring unknown XID=" + var7_6 + " broker will " + (var2_2.getSendAcknowledge() != false ? "notify the client" : " not notify the client"));
                if (var2_2.getSendAcknowledge()) {
                    var14_13 = "Uknown XID " + var7_6;
                    this.sendReply(var1_1, var2_2, var2_2.getPacketType() + 1, 404, 0L, var14_13);
                }
                return true;
lbl83:
                // 1 sources

                if (var3_3 != 0L) {
                    if (var1_1.getClientProtocolVersion() == 100) {
                        var20_21 = var19_19;
                        synchronized (var20_21) {
                            var5_4 = (TransactionUID)var19_19.get(new Long(var3_3));
                        }
                    } else {
                        var5_4 = new TransactionUID(var3_3);
                    }
                }
            }
            if (var5_4 == null) {
                this.logger.log(8, "InternalError: Transaction ID was not passed by the jms api on a method that reqires an existing transaction ");
                this.sendReply(var1_1, var2_2, var2_2.getPacketType() + 1, 500, 0L, "Internal Error: bad MQ protocol, missing TransactionID");
                return true;
            }
            var6_5 = this.translist.retrieveState(var5_4);
            if (var6_5 == null) {
                if (var11_10 && (var2_2.getPacketType() == 48 || var2_2.getPacketType() == 46)) {
                    if (var2_2.getSendAcknowledge()) {
                        this.sendReply(var1_1, var2_2, var2_2.getPacketType() + 1, 200, var5_4.longValue(), var14_13);
                        return true;
                    }
                    if (FaultInjection.FAULT_INJECTION) {
                        this.checkFIAfterProcess(var2_2.getPacketType());
                        this.checkFIAfterReply(var2_2.getPacketType());
                    }
                } else {
                    var6_5 = this.cacheGetState(var5_4, var1_1);
                    if (var6_5 != null) {
                        this.logger.log(32, "Transaction ID " + var5_4 + " has already been resolved. Ignoring request: " + PacketType.getString(var2_2.getPacketType()) + ". Last state of this transaction: " + var6_5.toString() + " broker will " + (var2_2.getSendAcknowledge() != false ? "notify the client" : " not notify the client"));
                    } else {
                        this.logger.log(BrokerStateHandler.shuttingDown != false ? 4 : 32, "B3100", "Unknown transaction: " + var5_4 + "(" + var3_3 + ")" + " broker will " + (var2_2.getSendAcknowledge() != false ? "notify the client" : " not notify the client") + " Ignoring " + PacketType.getString(var2_2.getPacketType()) + "\n" + PacketUtil.dumpPacket(var2_2));
                    }
                    if (var2_2.getSendAcknowledge()) {
                        var14_13 = "Unknown transaction " + var5_4;
                        this.sendReply(var1_1, var2_2, var2_2.getPacketType() + 1, 404, var5_4.longValue(), var14_13);
                    }
                    return true;
                }
            }
        }
        if (TransactionHandler.DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": " + PacketType.getString(var2_2.getPacketType()) + ": " + "TUID=" + var5_4 + " XAFLAGS=" + TransactionState.xaFlagToString(var8_7) + " State=" + var6_5 + " Xid=" + var7_6);
        }
        if (!(var7_6 == null || var6_5 == null || var6_5.getXid() != null && var7_6.equals(var6_5.getXid()))) {
            this.logger.log(32, "B3100", "Transaction Xid mismatch. " + PacketType.getString(var2_2.getPacketType()) + " Packet has tuid=" + var5_4 + " xid=" + var7_6 + ", transaction table has tuid=" + var5_4 + " xid=" + var6_5.getXid() + ". Using values from table.");
            var7_6 = var6_5.getXid();
        }
        if (var7_6 == null && var6_5 != null && var6_5.getXid() != null && var2_2.getPacketType() != 60) {
            var7_6 = var6_5.getXid();
            this.logger.log(16, "B3100", "Transaction Xid not found in " + PacketType.getString(var2_2.getPacketType()) + " packet for tuid " + var5_4 + ". Will use " + var7_6);
        }
        var20_22 = 200;
        var21_24 = null;
        var22_26 = 0L;
        var24_27 = false;
        var25_28 = (Integer)var13_12.get("JMQAutoRollback");
        var26_29 = (Long)var13_12.get("JMQLifetime");
        var27_30 = (Boolean)var13_12.get("JMQSessionLess");
        if (var25_28 != null) {
            var21_24 = AutoRollbackType.getType(var25_28);
        }
        if (var26_29 != null) {
            var22_26 = var26_29;
        }
        var24_27 = var27_30 != null ? var27_30 : var7_6 != null;
        switch (var2_2.getPacketType()) {
            case 44: {
                var28_31 = null;
                var29_35 = (Long)var13_12.get("JMQSessionID");
                if (var29_35 != null) {
                    var28_31 = new SessionUID(var29_35);
                }
                if (var21_24 == AutoRollbackType.NEVER || var22_26 > 0L) {
                    var20_22 = 501;
                    var14_13 = "AutoRollbackType of NEVER not supported";
                } else if (var7_6 != null && !var24_27) {
                    var20_22 = 501;
                    var14_13 = "XA transactions only supported on sessionless connections";
                } else if (var7_6 == null && var24_27) {
                    var20_22 = 500;
                    var14_13 = "non-XA transactions only supported on  non-sessionless connections";
                } else if (!var12_11) {
                    if (var8_7 != null && !TransactionState.isFlagSet(0, var8_7)) {
                        try {
                            var30_39 = var6_5.nextState(var2_2.getPacketType(), var8_7);
                            this.translist.updateState(var5_4, var30_39, true);
                        }
                        catch (BrokerException var30_40) {
                            this.logger.log(32, "B3100", var30_40.toString() + ": TUID=" + var5_4 + " Xid=" + var7_6);
                            var14_13 = var30_40.getMessage();
                            var20_22 = var30_40.getStatusCode();
                        }
                    } else {
                        try {
                            if (var1_1.getClientProtocolVersion() == 100) {
                                var19_19.put(new Long(var3_3), var5_4);
                            }
                            var6_5 = new TransactionState(var21_24, var22_26, var24_27);
                            var6_5.setState(1);
                            var6_5.setUser(var1_1.getUserName());
                            var6_5.setCreator((SysMessageID)var2_2.getSysMessageID().clone());
                            var6_5.setClientID((String)var1_1.getClientData("client id"));
                            var6_5.setXid(var7_6);
                            if (var1_1 instanceof IMQConnection) {
                                var6_5.setConnectionString(var1_1.userReadableString());
                            }
                            this.translist.addTransactionID(var5_4, var6_5);
                            var17_17.add(var5_4);
                        }
                        catch (BrokerException var30_41) {
                            this.logger.log(16, "Exception starting new transaction: " + var30_41.toString());
                            var14_13 = var30_41.getMessage();
                            var20_22 = var30_41.getStatusCode();
                        }
                    }
                }
                this.sendReply(var1_1, var2_2, 45, var20_22, var5_4.longValue(), var14_13);
                break;
            }
            case 56: 
            case 58: {
                try {
                    var28_32 = var6_5.nextState(var2_2.getPacketType(), var8_7);
                    this.translist.updateState(var5_4, var28_32, true);
                    if (var2_2.getPacketType() == 56) {
                        var29_36 = null;
                        var29_36 = this.translist.retrieveConsumedMessages(var5_4);
                        var30_42 = new HashSet<BrokerAddress>();
                        if (var29_36 != null && var29_36.size() > 0) {
                            var31_44 = var29_36.keySet().iterator();
                            while (var31_44.hasNext()) {
                                var32_46 = (SysMessageID)var31_44.next();
                                if (var32_46 == null) continue;
                                var33_48 = Destination.get(var32_46);
                                var34_51 = (List)var29_36.get(var32_46);
                                for (var35_57 = 0; var35_57 < var34_51.size(); ++var35_57) {
                                    if (!var33_48.isLocal() && TransactionHandler.useNewProtocol()) {
                                        var36_59 /* !! */  = var33_48.getAddress();
                                        if (var30_42.contains(var36_59 /* !! */ )) continue;
                                        var30_42.add(var36_59 /* !! */ );
                                    }
                                    var36_59 /* !! */  = (ConsumerUID)var34_51.get(var35_57);
                                    var33_48.prepare((ConsumerUID)var36_59 /* !! */ , var5_4, TransactionHandler.useNewProtocol());
                                }
                            }
                        }
                        if ((var31_44 = Globals.getAgent()) != null) {
                            var31_44.notifyTransactionPrepare(var5_4);
                        }
                    }
                }
                catch (Exception var28_33) {
                    this.logger.logStack(32, "B3100", var28_33.toString() + ": TUID=" + var5_4 + " Xid=" + var7_6, (Throwable)var28_33);
                    var14_13 = var28_33.getMessage();
                    if (!(var28_33 instanceof BrokerException)) ** GOTO lbl224
                    var20_22 = ((BrokerException)var28_33).getStatusCode();
                }
lbl224:
                // 3 sources

                this.sendReply(var1_1, var2_2, var2_2.getPacketType() + 1, var20_22, var5_4.longValue(), var14_13);
                break;
            }
            case 60: {
                var28_34 = null;
                if (var5_4 != null) {
                    var28_34 = new Vector();
                    var6_5 = this.translist.retrieveState(var5_4);
                    if (var6_5.getState() == 5) {
                        var28_34.add(var5_4);
                    }
                } else {
                    if (var8_7 == null || !TransactionState.isFlagSet(0x1000000, var8_7)) {
                        var29_37 = new Hashtable<String, Integer>();
                        var29_37.put("JMQQuantity", new Integer(0));
                        this.sendReplyBody(var1_1, var2_2, 61, 200, var29_37, null);
                        break;
                    }
                    var28_34 = this.translist.getTransactions(5);
                }
                var29_38 = var28_34.size();
                var30_43 = 0;
                var31_45 = new ByteArrayOutputStream(var29_38 * JMQXid.size());
                var32_47 = new DataOutputStream(var31_45);
                for (var33_49 = 0; var33_49 < var29_38; ++var33_49) {
                    var34_52 = (TransactionUID)var28_34.get(var33_49);
                    var35_58 = this.translist.retrieveState(var34_52);
                    if (var35_58 == null) {
                        this.logger.log(32, "B3100", "Could not find state for TUID " + var34_52);
                        continue;
                    }
                    var36_60 = var35_58.getXid();
                    if (var36_60 == null) continue;
                    try {
                        var36_60.write(var32_47);
                        ++var30_43;
                        continue;
                    }
                    catch (Exception var37_61) {
                        this.logger.log(32, "B3100", "Could not write Xid " + var36_60 + " to message body: " + var37_61.toString());
                    }
                }
                var33_50 = new Hashtable<String, Number>();
                var33_50.put("JMQQuantity", new Integer(var30_43));
                if (var5_4 != null) {
                    var33_50.put("JMQTransactionID", new Long(var5_4.longValue()));
                }
                this.sendReplyBody(var1_1, var2_2, 61, 200, var33_50, var31_45.toByteArray());
                break;
            }
            case 46: {
                try {
                    this.doCommit(var5_4, var7_6, var8_7, var6_5, var17_17, true, var1_1, var2_2);
                }
                catch (BrokerException var34_53) {
                    var20_22 = var34_53.getStatusCode();
                    var14_13 = var34_53.getMessage();
                    if (var2_2.getSendAcknowledge()) {
                        this.sendReply(var1_1, var2_2, var2_2.getPacketType() + 1, var20_22, var5_4.longValue(), var14_13);
                        break;
                    }
                    if (!FaultInjection.FAULT_INJECTION) break;
                    this.checkFIAfterProcess(var2_2.getPacketType());
                    this.checkFIAfterReply(var2_2.getPacketType());
                }
                break;
            }
            case 48: {
                try {
                    if (var9_8) {
                        if (TransactionHandler.DEBUG) {
                            this.logger.log(8, "Redelivering msgs for " + var5_4);
                        }
                        var34_54 = var9_8;
                        this.redeliverUnacked(var5_4, var34_54, var10_9);
                    }
                }
                catch (BrokerException var34_55) {
                    this.logger.logStack(32, "B3100", "REDELIVER: " + var34_55.toString() + ": TUID=" + var5_4 + " Xid=" + var7_6, (Throwable)var34_55);
                    var14_13 = var34_55.getMessage();
                    var20_22 = var34_55.getStatusCode();
                }
                try {
                    this.doRollback(var5_4, var7_6, var8_7, var6_5, var17_17, var1_1);
                }
                catch (BrokerException var34_56) {
                    var14_13 = var34_56.getMessage();
                    var20_22 = var34_56.getStatusCode();
                }
                if (var2_2.getSendAcknowledge()) {
                    this.sendReply(var1_1, var2_2, var2_2.getPacketType() + 1, var20_22, var5_4.longValue(), var14_13);
                    break;
                }
                if (!FaultInjection.FAULT_INJECTION) break;
                this.checkFIAfterProcess(var2_2.getPacketType());
                this.checkFIAfterReply(var2_2.getPacketType());
            }
        }
        return true;
    }

    public void checkFIBeforeProcess(int n) {
        switch (n) {
            case 44: {
                this.fi.checkFaultAndExit(FaultInjection.FAULT_TXN_START_1, null, 2, false);
                break;
            }
            case 58: {
                this.fi.checkFaultAndExit(FaultInjection.FAULT_TXN_END_1, null, 2, false);
                break;
            }
            case 56: {
                this.fi.checkFaultAndExit(FaultInjection.FAULT_TXN_PREPARE_1, null, 2, false);
                break;
            }
            case 48: {
                this.fi.checkFaultAndExit(FaultInjection.FAULT_TXN_ROLLBACK_1, null, 2, false);
                break;
            }
            case 46: {
                this.fi.checkFaultAndExit(FaultInjection.FAULT_TXN_COMMIT_1, null, 2, false);
            }
        }
    }

    public void checkFIAfterProcess(int n) {
        switch (n) {
            case 44: {
                this.fi.checkFaultAndExit(FaultInjection.FAULT_TXN_START_2, null, 2, false);
                break;
            }
            case 58: {
                this.fi.checkFaultAndExit(FaultInjection.FAULT_TXN_END_2, null, 2, false);
                break;
            }
            case 56: {
                this.fi.checkFaultAndExit(FaultInjection.FAULT_TXN_PREPARE_2, null, 2, false);
                break;
            }
            case 48: {
                this.fi.checkFaultAndExit(FaultInjection.FAULT_TXN_ROLLBACK_2, null, 2, false);
                break;
            }
            case 46: {
                this.fi.checkFaultAndExit(FaultInjection.FAULT_TXN_COMMIT_2, null, 2, false);
            }
        }
    }

    public void checkFIAfterDB(int n) {
        switch (n) {
            case 48: {
                this.fi.checkFaultAndExit(FaultInjection.FAULT_TXN_ROLLBACK_4, null, 2, false);
                break;
            }
            case 46: {
                this.fi.checkFaultAndExit(FaultInjection.FAULT_TXN_COMMIT_4, null, 2, false);
            }
        }
    }

    public void checkFIAfterReply(int n) {
        switch (n) {
            case 44: {
                this.fi.checkFaultAndExit(FaultInjection.FAULT_TXN_START_3, null, 2, false);
                break;
            }
            case 58: {
                this.fi.checkFaultAndExit(FaultInjection.FAULT_TXN_END_3, null, 2, false);
                break;
            }
            case 56: {
                this.fi.checkFaultAndExit(FaultInjection.FAULT_TXN_PREPARE_3, null, 2, false);
                break;
            }
            case 48: {
                this.fi.checkFaultAndExit(FaultInjection.FAULT_TXN_ROLLBACK_3, null, 2, false);
                break;
            }
            case 46: {
                this.fi.checkFaultAndExit(FaultInjection.FAULT_TXN_COMMIT_3, null, 2, false);
            }
        }
    }

    private void cacheSetState(TransactionUID transactionUID, TransactionState transactionState, IMQConnection iMQConnection) {
        if (iMQConnection == null) {
            return;
        }
        CacheHashMap cacheHashMap = (CacheHashMap)iMQConnection.getClientData("txncache");
        if (cacheHashMap == null) {
            cacheHashMap = new CacheHashMap(4);
            iMQConnection.addClientData("txncache", cacheHashMap);
        }
        cacheHashMap.put(transactionUID, transactionState);
    }

    private TransactionState cacheGetState(TransactionUID transactionUID, IMQConnection iMQConnection) {
        CacheHashMap cacheHashMap = (CacheHashMap)iMQConnection.getClientData("txncache");
        if (cacheHashMap == null) {
            return null;
        }
        return (TransactionState)cacheHashMap.get(transactionUID);
    }

    public void doCommit(TransactionUID transactionUID, JMQXid jMQXid, Integer n, TransactionState transactionState, List list, boolean bl, IMQConnection iMQConnection, Packet packet) throws BrokerException {
        Serializable serializable;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Cloneable cloneable;
        int n2;
        int n3 = 200;
        HashMap hashMap = null;
        HashMap hashMap2 = null;
        Object var12_12 = null;
        List list2 = null;
        list2 = this.translist.retrieveSentMessages(transactionUID);
        hashMap = this.translist.retrieveConsumedMessages(transactionUID);
        hashMap2 = this.translist.retrieveStoredConsumerUIDs(transactionUID);
        this.cacheSetState(transactionUID, transactionState, iMQConnection);
        if (list != null) {
            list.remove(transactionUID);
        }
        try {
            n2 = jMQXid == null ? 6 : transactionState.nextState(46, n);
            transactionState = this.translist.updateState(transactionUID, n2, true);
            if (FaultInjection.FAULT_INJECTION) {
                this.checkFIAfterDB(46);
            }
            cloneable = new HashSet();
            if (hashMap != null && hashMap.size() > 0) {
                object5 = hashMap.keySet().iterator();
                while (object5.hasNext()) {
                    object4 = (SysMessageID)object5.next();
                    if (object4 == null || (object3 = Destination.get((SysMessageID)object4)) == null) continue;
                    object2 = (List)hashMap.get(object4);
                    for (int i = 0; i < object2.size(); ++i) {
                        object = (ConsumerUID)object2.get(i);
                        if (!((PacketReference)object3).isLocal() && TransactionHandler.useNewProtocol()) {
                            serializable = ((PacketReference)object3).getAddress();
                            if (((HashSet)cloneable).contains(serializable)) continue;
                            ((HashSet)cloneable).add(serializable);
                        }
                        ((PacketReference)object3).commit((ConsumerUID)object, transactionUID, TransactionHandler.useNewProtocol());
                    }
                }
            }
            if ((object5 = Globals.getAgent()) != null) {
                ((Agent)object5).notifyTransactionCommit(transactionUID);
            }
        }
        catch (BrokerException brokerException) {
            this.logger.logStack(32, "B3100", brokerException.toString() + ": TUID=" + transactionUID + " Xid=" + jMQXid, (Throwable)brokerException);
            throw brokerException;
        }
        catch (IOException iOException) {
            this.logger.logStack(32, "B3100", iOException.toString() + ": TUID=" + transactionUID + " Xid=" + jMQXid, (Throwable)iOException);
            throw new BrokerException("Error on commit", iOException);
        }
        if (n3 != 200) {
            throw var12_12;
        }
        if (bl) {
            this.sendReply(iMQConnection, packet, 47, n3, transactionUID.longValue(), null);
        }
        for (n2 = 0; list2 != null && n2 < list2.size(); ++n2) {
            cloneable = (SysMessageID)list2.get(n2);
            object5 = Destination.get(cloneable);
            if (object5 == null) {
                this.logger.log(32, "B3100", "transacted message removed too early " + cloneable);
                continue;
            }
            try {
                object4 = Destination.getDestination(((PacketReference)object5).getDestinationUID());
                object3 = ((Destination)object4).routeNewMessage((PacketReference)object5);
                ((Destination)object4).forwardMessage((Set)object3, (PacketReference)object5);
                continue;
            }
            catch (Exception exception) {
                this.logger.logStack(BrokerStateHandler.shuttingDown ? 4 : 32, "B3100", "unable to route/send transaction message " + cloneable, (Throwable)exception);
            }
        }
        if (hashMap != null && hashMap.size() > 0) {
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                cloneable = (SysMessageID)iterator.next();
                if (cloneable == null || (object5 = Destination.get(cloneable)) == null) continue;
                if (!((PacketReference)object5).isLocal()) {
                    // empty if block
                }
                object4 = (List)hashMap.get(cloneable);
                for (int i = 0; i < object4.size(); ++i) {
                    object2 = (ConsumerUID)object4.get(i);
                    try {
                        if (object5 == null || ((PacketReference)object5).isDestroyed() || ((PacketReference)object5).isInvalid()) continue;
                        Session session = Session.getSession((ConsumerUID)object2);
                        if (session != null) {
                            object = session.ackMessage((ConsumerUID)object2, (SysMessageID)cloneable, TransactionHandler.useNewProtocol() ? transactionUID : null);
                            if (object == null) continue;
                            serializable = Destination.getDestination(((PacketReference)object5).getDestinationUID());
                            ((Destination)serializable).removeMessage(((PacketReference)object5).getSysMessageID(), RemoveReason.ACKNOWLEDGED);
                            continue;
                        }
                        object = (ConsumerUID)hashMap2.get(object2);
                        if (object == null) {
                            object = object2;
                        }
                        try {
                            if (!((PacketReference)object5).acknowledged((ConsumerUID)object2, (ConsumerUID)object, true, true, transactionUID)) continue;
                            serializable = Destination.getDestination(((PacketReference)object5).getDestinationUID());
                            ((Destination)serializable).removeMessage(((PacketReference)object5).getSysMessageID(), RemoveReason.ACKNOWLEDGED);
                        }
                        catch (BrokerException brokerException) {
                            this.logger.log(16, "Internal error", brokerException);
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        this.logger.logStack(32, "B3100", "-------------------------------------------Processing Acknowledgement during committ [" + cloneable + ":" + object2 + ":" + iMQConnection.getConnectionUID() + "]\nReference is " + (object5 == null ? null : ((PacketReference)object5).getSysMessageID()) + "\n" + PacketUtil.dumpPacket(packet) + "--------------------------------------------", (Throwable)exception);
                    }
                }
            }
        }
        this.translist.removeTransactionAck(transactionUID);
        this.translist.removeTransactionID(transactionUID);
    }

    public void doRollback(TransactionUID transactionUID, JMQXid jMQXid, Integer n, TransactionState transactionState, List list, IMQConnection iMQConnection) throws BrokerException {
        Serializable serializable;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Cloneable cloneable;
        int n2;
        int n3 = 200;
        try {
            n2 = jMQXid == null ? 7 : transactionState.nextState(48, n);
        }
        catch (BrokerException brokerException) {
            this.logger.log(32, "B3100", brokerException.toString() + ": TUID=" + transactionUID + " Xid=" + jMQXid);
            throw brokerException;
        }
        transactionState = this.translist.updateState(transactionUID, n2, true);
        if (FaultInjection.FAULT_INJECTION) {
            this.checkFIAfterDB(48);
        }
        try {
            cloneable = null;
            cloneable = this.translist.retrieveConsumedMessages(transactionUID);
            HashSet<BrokerAddress> hashSet = new HashSet<BrokerAddress>();
            if (cloneable != null && ((HashMap)cloneable).size() > 0) {
                object5 = ((HashMap)cloneable).keySet().iterator();
                while (object5.hasNext()) {
                    object4 = (SysMessageID)object5.next();
                    if (object4 == null) continue;
                    object3 = Destination.get((SysMessageID)object4);
                    object2 = (List)((HashMap)cloneable).get(object4);
                    for (int i = 0; i < object2.size(); ++i) {
                        object = (ConsumerUID)object2.get(i);
                        if (!((PacketReference)object3).isLocal() && TransactionHandler.useNewProtocol()) {
                            serializable = ((PacketReference)object3).getAddress();
                            if (hashSet.contains(serializable)) continue;
                            hashSet.add((BrokerAddress)serializable);
                        }
                        ((PacketReference)object3).rollback((ConsumerUID)object, transactionUID, TransactionHandler.useNewProtocol());
                    }
                }
            }
        }
        catch (Exception exception) {
            this.logger.logStack(32, "B3100", exception.toString() + ": TUID=" + transactionUID + " Xid=" + jMQXid, (Throwable)exception);
        }
        cloneable = new ArrayList(this.translist.retrieveSentMessages(transactionUID));
        for (int i = 0; cloneable != null && i < cloneable.size(); ++i) {
            object5 = (SysMessageID)cloneable.get(i);
            if (DEBUG) {
                this.logger.log(4, "Removing " + object5 + " because of rollback");
            }
            if ((object4 = Destination.get(object5)) == null) continue;
            object3 = ((PacketReference)object4).getDestinationUID();
            object2 = Destination.getDestination((DestinationUID)object3);
            ((Destination)object2).removeMessage((SysMessageID)object5, RemoveReason.ROLLBACK);
            if (list == null) continue;
            list.remove(transactionUID);
        }
        Map map = this.translist.getOrphanAck(transactionUID);
        if (map != null) {
            object5 = map.entrySet().iterator();
            while (object5.hasNext()) {
                object4 = (Map.Entry)object5.next();
                object3 = (SysMessageID)object4.getKey();
                object2 = Destination.get((SysMessageID)object3);
                if (object2 == null) {
                    this.logger.log(4, transactionUID + ":Unknown orphan " + object3);
                    continue;
                }
                List list2 = (List)object4.getValue();
                object = list2.iterator();
                while (object.hasNext()) {
                    serializable = (ConsumerUID)object.next();
                    ((PacketReference)object2).getDestination().forwardOrphanMessage((PacketReference)object2, (ConsumerUID)serializable);
                }
            }
        }
        this.translist.removeTransactionAck(transactionUID);
        object5 = Globals.getAgent();
        if (object5 != null) {
            ((Agent)object5).notifyTransactionRollback(transactionUID);
        }
        try {
            transactionState.setState(n2);
            this.cacheSetState(transactionUID, transactionState, iMQConnection);
            this.translist.removeTransactionID(transactionUID);
        }
        catch (BrokerException brokerException) {
            this.logger.logStack(32, "B3100", "exception removing transaction", (Throwable)brokerException);
            throw brokerException;
        }
    }

    void redeliverUnacked(TransactionUID transactionUID, boolean bl, boolean bl2) throws BrokerException {
        Set<Object> set;
        Object object;
        Serializable serializable;
        Object object2;
        Object object3;
        Object object4;
        Iterator iterator;
        Object var4_4 = null;
        HashMap hashMap = null;
        HashMap hashMap2 = null;
        Object var7_7 = null;
        hashMap = this.translist.retrieveConsumedMessages(transactionUID);
        hashMap2 = this.translist.retrieveStoredConsumerUIDs(transactionUID);
        HashMap hashMap3 = new HashMap();
        if (hashMap != null && hashMap.size() > 0) {
            iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                object4 = (SysMessageID)iterator.next();
                if (object4 == null || (object3 = Destination.get((SysMessageID)object4)) == null || ((PacketReference)object3).isDestroyed() || ((PacketReference)object3).isInvalid()) continue;
                object2 = (List)hashMap.get(object4);
                for (int i = 0; i < object2.size(); ++i) {
                    serializable = (ConsumerUID)object2.get(i);
                    object = (ConsumerUID)hashMap2.get(serializable);
                    if (object == null) {
                        object = serializable;
                    }
                    if ((set = (TreeSet<Object>)hashMap3.get(serializable)) == null) {
                        set = new TreeSet<Object>(new RefCompare());
                        hashMap3.put(serializable, set);
                    }
                    try {
                        if (bl2) {
                            ((PacketReference)object3).consumed((ConsumerUID)object, false, false);
                        } else {
                            ((PacketReference)object3).removeDelivered((ConsumerUID)object, true);
                        }
                    }
                    catch (IOException iOException) {
                        this.logger.log(16, "Internal error", iOException);
                    }
                    set.add(object3);
                }
            }
        }
        iterator = hashMap3.keySet().iterator();
        while (iterator.hasNext()) {
            object4 = (ConsumerUID)iterator.next();
            object3 = Consumer.getConsumer((ConsumerUID)object4);
            if (object3 == null) {
                if (!DEBUG) continue;
                this.logger.log(8, transactionUID + ":Can not redeliver messages to " + object4 + " consumer is gone");
                continue;
            }
            object2 = (SortedSet)hashMap3.get(object4);
            if (DEBUG) {
                this.logger.log(8, transactionUID + ":Redelivering " + object2.size() + " msgs to " + object4);
            }
            if (!bl) {
                iterator.remove();
                continue;
            }
            if (((Consumer)object3).routeMessages((Collection)object2, true)) {
                if (DEBUG) {
                    this.logger.log(8, "Sucessfully routed msgs to " + object3);
                }
                iterator.remove();
                continue;
            }
            if (!DEBUG) continue;
            this.logger.log(8, "Could not route messages to " + object3);
        }
        if (DEBUG) {
            this.logger.log(8, transactionUID + ":after redeliver, " + hashMap3.size() + " inactive consumers remaining");
        }
        iterator = hashMap3.keySet().iterator();
        while (iterator.hasNext()) {
            Object object5;
            object4 = (ConsumerUID)iterator.next();
            object3 = (ConsumerUID)hashMap2.get(object4);
            if (object3 == null || object4 == object3) {
                iterator.remove();
                continue;
            }
            if (object3 == PacketReference.queueUID) {
                object2 = (SortedSet)hashMap3.get(object4);
                if (object2.isEmpty()) {
                    if (!DEBUG) continue;
                    this.logger.log(8, "Internal Error:  empty set");
                    continue;
                }
                object5 = (PacketReference)object2.first();
                if (object5 == null) {
                    if (!DEBUG) continue;
                    this.logger.log(8, "Internal Error:  null reterence");
                    continue;
                }
                try {
                    if (bl2) {
                        ((PacketReference)object5).consumed((ConsumerUID)object3, false, false);
                    } else {
                        ((PacketReference)object5).removeDelivered((ConsumerUID)object3, false);
                    }
                }
                catch (IOException iOException) {
                    this.logger.log(16, "Internal error", iOException);
                }
                serializable = ((PacketReference)object5).getDestination();
                if (serializable == null) {
                    if (!DEBUG) continue;
                    this.logger.log(8, "Internal Error:  unknown destination for reference: " + object5);
                    continue;
                }
                object = object2.iterator();
                while (object.hasNext()) {
                    object5 = (PacketReference)object.next();
                    try {
                        set = ((Destination)serializable).routeNewMessage((PacketReference)object5);
                        ((Destination)serializable).forwardMessage(set, (PacketReference)object5);
                    }
                    catch (Exception exception) {
                        this.logger.log(8, "Internal Error: Unable to re-queue message  to queue " + serializable, exception);
                    }
                }
                continue;
            }
            object2 = Consumer.getConsumer((ConsumerUID)object3);
            if (object2 == null) {
                if (!DEBUG) continue;
                this.logger.log(8, "Internal Error:  unknown consumer " + object3);
                continue;
            }
            object5 = (SortedSet)hashMap3.get(object4);
            if (object5 == null || object5.isEmpty() || !((Consumer)object2).routeMessages((Collection)object5, true)) continue;
            iterator.remove();
        }
        if (DEBUG && hashMap3.size() > 0) {
            this.logger.log(8, transactionUID + ":after all processing, " + hashMap3.size() + " inactive consumers remaining");
        }
    }
}

