/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.admin.DestinationInfo;
import java.util.Hashtable;
import java.util.Vector;

public class GetDestinationsHandler
extends AdminCmdHandler {
    static final /* synthetic */ boolean $assertionsDisabled;

    public GetDestinationsHandler(AdminDataHandler adminDataHandler) {
        super(adminDataHandler);
    }

    public boolean handle(IMQConnection iMQConnection, Packet packet, Hashtable hashtable) {
        Object object;
        if (DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": " + "Getting destinations: " + hashtable);
        }
        Vector<DestinationInfo> vector = new Vector<DestinationInfo>();
        int n = 200;
        String string = null;
        String string2 = (String)hashtable.get("JMQDestination");
        Integer n2 = (Integer)hashtable.get("JMQDestType");
        if (!$assertionsDisabled && string2 != null && n2 == null) {
            throw new AssertionError();
        }
        if (string2 != null) {
            try {
                object = Destination.getDestination(string2, DestType.isQueue(n2));
                if (object != null) {
                    if (DEBUG) {
                        ((Destination)object).debug();
                    }
                    vector.add(GetDestinationsHandler.getDestinationInfo((Destination)object));
                }
                string = this.rb.getString("B4017", string2);
                n = 404;
            }
            catch (Exception exception) {
                this.logger.log(32, "Internal Error ", exception);
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
        } else {
            object = Destination.getAllDestinations();
            while (object.hasNext()) {
                Destination destination = (Destination)object.next();
                DestinationInfo destinationInfo = GetDestinationsHandler.getDestinationInfo(destination);
                vector.add(destinationInfo);
            }
        }
        object = new Packet(iMQConnection.useDirectBuffers());
        ((Packet)object).setPacketType(5);
        GetDestinationsHandler.setProperties((Packet)object, 21, n, string);
        this.setBodyObject((Packet)object, vector);
        this.parent.sendReply(iMQConnection, packet, (Packet)object);
        return true;
    }

    public static DestinationInfo getDestinationInfo(Destination destination) {
        SizeString sizeString;
        DestinationInfo destinationInfo = new DestinationInfo();
        destinationInfo.nMessages = destination.size();
        destinationInfo.nMessageBytes = destination.byteSize();
        destinationInfo.nConsumers = destination.getConsumerCount();
        destinationInfo.nfConsumers = destination.getFailoverConsumerCount();
        destinationInfo.naConsumers = destination.getActiveConsumerCount();
        destinationInfo.nProducers = destination.getProducerCount();
        destinationInfo.autocreated = destination.isAutoCreated() || destination.isInternal() || destination.isDMQ() || destination.isAdmin();
        destinationInfo.destState = destination.getState();
        destinationInfo.name = destination.getDestinationName();
        destinationInfo.type = destination.getType() & 0xFFFFFF1F;
        destinationInfo.fulltype = destination.getType();
        destinationInfo.maxMessages = destination.getCapacity();
        if (destinationInfo.maxMessages < 0) {
            destinationInfo.maxMessages = 0;
        }
        long l = destinationInfo.maxMessageBytes = (sizeString = destination.getByteCapacity()) == null ? 0L : sizeString.getBytes();
        if (destinationInfo.maxMessageBytes < 0L) {
            destinationInfo.maxMessageBytes = 0L;
        }
        long l2 = destinationInfo.maxMessageSize = (sizeString = destination.getMaxByteSize()) == null ? 0L : sizeString.getBytes();
        if (destinationInfo.maxMessageSize < 0L) {
            destinationInfo.maxMessageSize = 0L;
        }
        destinationInfo.destScope = destination.getScope();
        destinationInfo.destLimitBehavior = destination.getLimitBehavior();
        destinationInfo.maxPrefetch = destination.getMaxPrefetch();
        destinationInfo.destCDP = destination.getClusterDeliveryPolicy();
        destinationInfo.maxActiveConsumers = destination.getMaxActiveConsumers();
        destinationInfo.maxFailoverConsumers = destination.getMaxFailoverConsumers();
        destinationInfo.maxProducers = destination.getMaxProducers();
        destinationInfo.maxNumSharedConsumers = destination.getMaxNumSharedConsumers();
        destinationInfo.sharedConsumerFlowLimit = destination.getSharedConsumerFlowLimit();
        destinationInfo.useDMQ = destination.getUseDMQ();
        destinationInfo.nUnackMessages = destination.getUnackSize();
        destinationInfo.nTxnMessages = destination.txnSize();
        destinationInfo.nTxnMessageBytes = destination.txnByteSize();
        return destinationInfo;
    }

    static {
        $assertionsDisabled = !GetDestinationsHandler.class.desiredAssertionStatus();
    }
}

