/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.util;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.util.GoodbyeReason;
import com.sun.messaging.jmq.util.admin.ConnectionInfo;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.ArrayList;
import java.util.List;

public class ConnectionUtil {
    public static List getConnections() {
        List list = ConnectionUtil.getConnections(null);
        return list;
    }

    public static List getConnections(String string) {
        ConnectionManager connectionManager = Globals.getConnectionManager();
        List list = null;
        try {
            Service service = null;
            if (string != null && (service = Globals.getServiceManager().getService(string)) == null) {
                return list;
            }
            list = connectionManager.getConnectionList(service);
        }
        catch (Exception exception) {
            BrokerResources brokerResources = Globals.getBrokerResources();
            Logger logger = Globals.getLogger();
            logger.log(16, brokerResources.getString("B2175"), exception);
        }
        return list;
    }

    public static List getConnectionInfoList(String string) {
        List list;
        Object object;
        ConnectionManager connectionManager = Globals.getConnectionManager();
        ArrayList<ConnectionInfo> arrayList = new ArrayList<ConnectionInfo>();
        try {
            object = null;
            if (string != null && (object = Globals.getServiceManager().getService(string)) == null) {
                return arrayList;
            }
            list = connectionManager.getConnectionList((Service)object);
        }
        catch (Exception exception) {
            BrokerResources brokerResources = Globals.getBrokerResources();
            Logger logger = Globals.getLogger();
            logger.log(16, brokerResources.getString("B2175"), exception);
            return arrayList;
        }
        if (list.size() == 0) {
            return arrayList;
        }
        object = list.iterator();
        while (object.hasNext()) {
            IMQConnection iMQConnection = (IMQConnection)object.next();
            ConnectionInfo connectionInfo = iMQConnection.getConnectionInfo();
            arrayList.add(connectionInfo);
        }
        return arrayList;
    }

    public static ConnectionInfo getConnectionInfo(long l) {
        ConnectionManager connectionManager = Globals.getConnectionManager();
        ConnectionInfo connectionInfo = null;
        IMQConnection iMQConnection = null;
        iMQConnection = (IMQConnection)connectionManager.getConnection(new ConnectionUID(l));
        if (iMQConnection == null) {
            return null;
        }
        connectionInfo = iMQConnection.getConnectionInfo();
        return connectionInfo;
    }

    public static String getServiceOfConnection(long l) {
        ConnectionInfo connectionInfo = ConnectionUtil.getConnectionInfo(l);
        if (connectionInfo == null) {
            return null;
        }
        return connectionInfo.service;
    }

    public static List getConsumerIDs(long l) {
        ConnectionManager connectionManager = Globals.getConnectionManager();
        Object var3_2 = null;
        IMQConnection iMQConnection = null;
        iMQConnection = (IMQConnection)connectionManager.getConnection(new ConnectionUID(l));
        List list = iMQConnection.getConsumersIDs();
        return list;
    }

    public static List getProducerIDs(long l) {
        ConnectionManager connectionManager = Globals.getConnectionManager();
        Object var3_2 = null;
        IMQConnection iMQConnection = null;
        iMQConnection = (IMQConnection)connectionManager.getConnection(new ConnectionUID(l));
        List list = iMQConnection.getProducerIDs();
        return list;
    }

    public static void destroyConnection(long l, String string) {
        ConnectionManager connectionManager = Globals.getConnectionManager();
        IMQConnection iMQConnection = null;
        iMQConnection = (IMQConnection)connectionManager.getConnection(new ConnectionUID(l));
        if (iMQConnection != null) {
            iMQConnection.destroyConnection(true, GoodbyeReason.ADMIN_KILLED_CON, string);
        }
    }
}

