/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerState;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.LoadException;
import com.sun.messaging.jmq.jmsserver.persist.TakeoverLockException;
import com.sun.messaging.jmq.jmsserver.persist.TakeoverStoreInfo;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;

public abstract class Store {
    public static final String STORE_PROP_PREFIX = "imq.persist.store";
    public static final String CREATE_STORE_PROP = "imq.persist.storecreate.all";
    public static final String REMOVE_STORE_PROP = "imq.persist.storeremove.all";
    public static final String RESET_STORE_PROP = "imq.persist.storereset.all";
    public static final String RESET_MESSAGE_PROP = "imq.persist.storereset.messages";
    public static final String RESET_INTEREST_PROP = "imq.persist.storereset.durables";
    public static final String UPGRADE_NOBACKUP_PROP = "imq.persist.storeupgrade.nobackup";
    public static final String FILE_STORE_TYPE = "file";
    public static final String JDBC_STORE_TYPE = "jdbc";
    public static boolean DEBUG = false;
    public static final int INTEREST_STATE_ROUTED = 0;
    public static final int INTEREST_STATE_DELIVERED = 1;
    public static final int INTEREST_STATE_ACKNOWLEDGED = 2;
    public Logger logger = Globals.getLogger();
    public BrokerResources br = Globals.getBrokerResources();
    public BrokerConfig config = Globals.getConfig();
    private boolean closed = false;
    private Object closedLock = new Object();
    private int inprogressCount = 0;
    private Object inprogressLock = new Object();
    protected boolean createStore = this.config.getBooleanProperty("imq.persist.storecreate.all", false);
    protected boolean resetStore = false;
    protected boolean resetMessage = false;
    protected boolean resetInterest = false;
    protected boolean removeStore = this.config.getBooleanProperty("imq.persist.storeremove.all", false);
    protected boolean upgradeNoBackup = false;

    protected Store() {
        this.resetStore = this.config.getBooleanProperty(RESET_STORE_PROP, false);
        this.resetMessage = this.config.getBooleanProperty(RESET_MESSAGE_PROP, false);
        this.resetInterest = this.config.getBooleanProperty(RESET_INTEREST_PROP, false);
        this.upgradeNoBackup = this.config.getBooleanProperty(UPGRADE_NOBACKUP_PROP, false);
        if (this.removeStore) {
            this.logger.logToAll(8, "B1095");
        } else {
            if (this.resetStore) {
                this.logger.logToAll(8, "B1059");
            } else {
                if (this.resetMessage) {
                    this.logger.logToAll(8, "B1083");
                }
                if (this.resetInterest) {
                    this.logger.logToAll(8, "B1084");
                }
            }
            if (!this.resetStore && (this.resetMessage || this.resetInterest)) {
                this.logger.logToAll(8, "B1085");
            } else if (!this.resetStore) {
                this.logger.logToAll(8, "B1060");
            }
        }
    }

    public abstract int getStoreVersion();

    public abstract void storeMessage(DestinationUID var1, Packet var2, ConsumerUID[] var3, int[] var4, boolean var5) throws IOException, BrokerException;

    public abstract void storeMessage(DestinationUID var1, Packet var2, boolean var3) throws IOException, BrokerException;

    public abstract void removeMessage(DestinationUID var1, SysMessageID var2, boolean var3) throws IOException, BrokerException;

    public abstract void moveMessage(Packet var1, DestinationUID var2, DestinationUID var3, ConsumerUID[] var4, int[] var5, boolean var6) throws IOException, BrokerException;

    public abstract void removeAllMessages(Destination var1, boolean var2) throws IOException, BrokerException;

    public abstract Enumeration messageEnumeration(Destination var1) throws BrokerException;

    public boolean hasMessageBeenAcked(SysMessageID sysMessageID) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public int getMessageCount(String string) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public abstract HashMap getMessageStorageInfo(Destination var1) throws BrokerException;

    public abstract Packet getMessage(DestinationUID var1, SysMessageID var2) throws BrokerException;

    public abstract void storeInterestStates(DestinationUID var1, SysMessageID var2, ConsumerUID[] var3, int[] var4, boolean var5) throws BrokerException;

    public abstract void updateInterestState(DestinationUID var1, SysMessageID var2, ConsumerUID var3, int var4, boolean var5) throws BrokerException;

    public void updateInterestState(DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID consumerUID, int n, int n2) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public abstract int getInterestState(DestinationUID var1, SysMessageID var2, ConsumerUID var3) throws IOException, BrokerException;

    public abstract ConsumerUID[] getConsumerUIDs(DestinationUID var1, SysMessageID var2) throws BrokerException;

    public abstract void storeInterest(Consumer var1, boolean var2) throws IOException, BrokerException;

    public abstract void removeInterest(Consumer var1, boolean var2) throws IOException, BrokerException;

    public abstract Consumer[] getAllInterests() throws IOException, BrokerException;

    public abstract void storeDestination(Destination var1, boolean var2) throws IOException, BrokerException;

    public abstract void updateDestination(Destination var1, boolean var2) throws BrokerException;

    public void updateDestinationConnectedTime(Destination destination, long l) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public abstract void removeDestination(Destination var1, boolean var2) throws IOException, BrokerException;

    public long getDestinationConnectedTime(Destination destination) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public Destination getDestination(DestinationUID destinationUID) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public abstract Destination[] getAllDestinations() throws IOException, BrokerException;

    public abstract void storeTransaction(TransactionUID var1, TransactionState var2, boolean var3) throws IOException, BrokerException;

    public abstract void removeTransaction(TransactionUID var1, boolean var2) throws IOException, BrokerException;

    public abstract void updateTransactionState(TransactionUID var1, TransactionState var2, boolean var3) throws IOException, BrokerException;

    public TransactionState getTransactionState(TransactionUID transactionUID) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public void updateTransactionAccessedTime(TransactionUID transactionUID, long l) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public long getTransactionAccessedTime(TransactionUID transactionUID) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public void updateTransactionBroker(TransactionUID transactionUID, String string) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public String getTransactionBroker(TransactionUID transactionUID) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public List getTransactions(String string) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public int[] getTransactionUsageInfo(TransactionUID transactionUID) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public abstract HashMap getAllTransactionStates() throws IOException, BrokerException;

    public void close() {
        this.close(true);
    }

    public abstract void close(boolean var1);

    public abstract void storeTransactionAck(TransactionUID var1, TransactionAcknowledgement var2, boolean var3) throws BrokerException;

    public abstract void removeTransactionAck(TransactionUID var1, boolean var2) throws BrokerException;

    public abstract TransactionAcknowledgement[] getTransactionAcks(TransactionUID var1) throws BrokerException;

    public abstract HashMap getAllTransactionAcks() throws BrokerException;

    public abstract void updateProperty(String var1, Object var2, boolean var3) throws BrokerException;

    public abstract Object getProperty(String var1) throws BrokerException;

    public abstract String[] getPropertyNames() throws BrokerException;

    public abstract void storeConfigChangeRecord(long var1, byte[] var3, boolean var4) throws BrokerException;

    public abstract ArrayList getConfigChangeRecordsSince(long var1) throws BrokerException;

    public abstract Object[] getAllConfigRecords() throws BrokerException;

    public abstract void clearAllConfigChangeRecords(boolean var1) throws BrokerException;

    public abstract void clearAll(boolean var1) throws BrokerException;

    public abstract void compactDestination(Destination var1) throws BrokerException;

    public abstract HashMap getStorageInfo(Destination var1) throws BrokerException;

    public abstract String getStoreType();

    public boolean isJDBCStore() {
        return true;
    }

    public abstract Hashtable getDebugState() throws BrokerException;

    public long getBrokerHeartbeat(String string) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public HashMap getAllBrokerHeartbeats() throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public boolean updateBrokerHeartbeat(String string, long l) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public boolean updateBrokerHeartbeat(String string, long l, long l2, BrokerState brokerState) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public void addBrokerInfo(String string, String string2, BrokerState brokerState, int n, long l, long l2) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public void addBrokerInfo(String string, String string2, String string3, BrokerState brokerState, int n, long l, long l2) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public void updateBrokerInfo(String string, String string2, String string3, int n, BrokerState brokerState, long l) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public HashMap getAllBrokerInfos() throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public HABrokerInfo getBrokerInfo(String string) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public HashMap getAllBrokerInfoByState(BrokerState brokerState) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public boolean updateBrokerState(String string, BrokerState brokerState, BrokerState brokerState2) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public BrokerState getBrokerState(String string) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public Object[] getAllBrokerStates() throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public void getTakeOverLock(String string, String string2, long l, BrokerState brokerState, long l2, BrokerState brokerState2) throws TakeoverLockException, BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public TakeoverStoreInfo takeOverBrokerStore(String string, String string2) throws TakeoverLockException, BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public void syncDestination(Destination destination) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public void syncInterest(Consumer consumer) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public void syncTransaction(TransactionUID transactionUID) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public void syncConfigRecord() throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public void sync() throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public LoadException getLoadDestinationException() {
        return null;
    }

    public LoadException getLoadConsumerException() {
        return null;
    }

    public LoadException getLoadPropertyException() {
        return null;
    }

    public LoadException getLoadTransactionException() {
        return null;
    }

    public LoadException getLoadTransactionAckException() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setClosedAndWait() {
        Object object = this.closedLock;
        synchronized (object) {
            this.closed = true;
        }
        object = this.inprogressLock;
        synchronized (object) {
            while (this.inprogressCount > 0) {
                try {
                    this.inprogressLock.wait();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkClosedAndSetInProgress() throws BrokerException {
        Object object = this.closedLock;
        synchronized (object) {
            if (this.closed) {
                this.logger.log(32, "B3102");
                throw new BrokerException(this.br.getString("B3102"));
            }
            this.setInProgress(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setInProgress(boolean bl) {
        Object object = this.inprogressLock;
        synchronized (object) {
            this.inprogressCount = bl ? ++this.inprogressCount : --this.inprogressCount;
            if (this.inprogressCount == 0) {
                this.inprogressLock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean closed() {
        Object object = this.closedLock;
        synchronized (object) {
            return this.closed;
        }
    }

    public boolean upgradeNoBackup() {
        return this.upgradeNoBackup;
    }

    protected boolean getConfirmation() throws BrokerException {
        try {
            String string = this.br.getString("B0029");
            String string2 = this.br.getString("B0026");
            String string3 = this.br.getString("B0027");
            Object[] objectArray = new String[]{string2, string3};
            System.out.print(this.br.getString("B0040", objectArray));
            System.out.flush();
            String string4 = new BufferedReader(new InputStreamReader(System.in)).readLine();
            if (!string2.equalsIgnoreCase(string4) && !string.equalsIgnoreCase(string4)) {
                System.err.println(this.br.getString("B1108"));
                Broker.getBroker().exit(1, this.br.getString("B1108"), 2);
            }
            return true;
        }
        catch (IOException iOException) {
            this.logger.log(32, iOException.toString());
            throw new BrokerException(iOException.toString(), iOException);
        }
    }
}

