/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerState;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.TakeoverLockException;
import com.sun.messaging.jmq.jmsserver.persist.TakeoverStoreInfo;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BrokerDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DAOFactory;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConstants;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBTool;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.MessageDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.TransactionDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.UpgradeStore;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.VersionDAO;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class JDBCStore
extends Store
implements DBConstants {
    public static final String LOCK_STORE_PROP = "imq.persist.jdbc.lockstore.enabled";
    public static final int OLD_STORE_VERSION_350 = 350;
    public static final int OLD_STORE_VERSION = 370;
    public static final int STORE_VERSION = 400;
    DBManager dbmgr;
    DAOFactory daoFactory;
    String brokerID;
    private HashMap takeoverLockMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JDBCStore() throws BrokerException {
        String string;
        this.dbmgr = DBManager.getDBManager();
        this.daoFactory = this.dbmgr.getDAOFactory();
        this.brokerID = this.dbmgr.getBrokerID();
        String string2 = this.dbmgr.getOpenDBURL();
        if (string2 == null) {
            string2 = "not specified";
        }
        if ((string = this.dbmgr.getUser()) == null) {
            string = "not specified";
        }
        Object[] objectArray = new String[]{String.valueOf(400), this.brokerID, string2, string};
        this.logger.logToAll(8, this.br.getString("B1067", objectArray));
        if (this.createStore) {
            this.logger.log(8, "B1170");
        } else {
            this.logger.log(8, "B1171");
        }
        Connection connection = null;
        try {
            connection = this.dbmgr.getConnection(true);
            if (!this.checkStore(connection)) {
                this.closeDB(false);
                return;
            }
            if (!Globals.getHAEnabled() && this.config.getBooleanProperty(LOCK_STORE_PROP, true)) {
                DBManager.lockTables(connection, true);
            }
        }
        finally {
            Util.close(null, null, connection);
        }
        if (DEBUG) {
            this.logger.log(4, "JDBCStore instantiated.");
        }
    }

    public final int getStoreVersion() {
        return 400;
    }

    public void storeMessage(DestinationUID destinationUID, Packet packet, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws BrokerException {
        if (packet == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.storeMessage() called with message: " + packet.getSysMessageID().getUniqueName());
        }
        if (consumerUIDArray.length == 0 || consumerUIDArray.length != nArray.length) {
            throw new BrokerException(this.br.getKString("B3085"));
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getMessageDAO().insert(null, packet, consumerUIDArray, nArray, null, System.currentTimeMillis(), true);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void storeMessage(DestinationUID destinationUID, Packet packet, boolean bl) throws BrokerException {
        if (packet == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.storeMessage() called with message: " + packet.getSysMessageID().getUniqueName());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getMessageDAO().insert(null, packet, null, null, null, System.currentTimeMillis(), true);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void moveMessage(Packet packet, DestinationUID destinationUID, DestinationUID destinationUID2, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws IOException, BrokerException {
        if (packet == null || destinationUID == null || destinationUID2 == null) {
            throw new NullPointerException();
        }
        if (Store.DEBUG) {
            this.logger.log(4, "JDBCStore.moveMessage() called for message: " + packet.getSysMessageID().getUniqueName() + " from " + destinationUID + " to " + destinationUID2);
        }
        super.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getMessageDAO().moveMessage(null, packet, destinationUID, destinationUID2, consumerUIDArray, nArray);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            super.setInProgress(false);
        }
    }

    public void removeMessage(DestinationUID destinationUID, SysMessageID sysMessageID, boolean bl) throws BrokerException {
        if (sysMessageID == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.removeMessage() called with message: " + sysMessageID.getUniqueName());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getMessageDAO().delete(null, sysMessageID, destinationUID);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void removeAllMessages(Destination destination, boolean bl) throws IOException, BrokerException {
        if (destination == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.removeAllMessages() for destination: " + destination.getUniqueName());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getMessageDAO().deleteByDestination(null, destination);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public Enumeration messageEnumeration(Destination destination) throws BrokerException {
        if (destination == null) {
            throw new NullPointerException();
        }
        if (Store.DEBUG) {
            this.logger.log(4, "JDBCStore.messageEnumeration() called for destination: " + destination.getUniqueName());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    Enumeration enumeration = this.daoFactory.getMessageDAO().messageEnumeration(destination);
                    return enumeration;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public int getMessageCount(String string) throws BrokerException {
        if (string == null) {
            throw new NullPointerException();
        }
        if (Store.DEBUG) {
            this.logger.log(4, "JDBCStore.getMessageCount() called for broker: " + string);
        }
        super.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    int n = this.daoFactory.getMessageDAO().getMessageCount(null, string);
                    return n;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public HashMap getMessageStorageInfo(Destination destination) throws BrokerException {
        if (destination == null) {
            throw new NullPointerException();
        }
        if (Store.DEBUG) {
            this.logger.log(4, "JDBCStore.getMessageStorageInfo() called for destination: " + destination.getUniqueName());
        }
        super.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    HashMap hashMap = this.daoFactory.getMessageDAO().getMessageStorageInfo(null, destination);
                    return hashMap;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public Packet getMessage(DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        if (sysMessageID == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.getMessage() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    Packet packet = this.daoFactory.getMessageDAO().getMessage(null, sysMessageID);
                    return packet;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void storeInterestStates(DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws BrokerException {
        if (sysMessageID == null || consumerUIDArray == null || nArray == null) {
            throw new NullPointerException();
        }
        if (consumerUIDArray.length == 0 || consumerUIDArray.length != nArray.length) {
            throw new BrokerException(this.br.getKString("B3085"));
        }
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.storeInterestStates() called with message: " + sysMessageID.getUniqueName());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getConsumerStateDAO().insert(null, sysMessageID, consumerUIDArray, nArray, true);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void updateInterestState(DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID consumerUID, int n, boolean bl) throws BrokerException {
        if (sysMessageID == null || consumerUID == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.updateInterestState() called with message: " + sysMessageID.getUniqueName() + ", consumer: " + consumerUID.getUniqueName() + ", state=" + n);
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getConsumerStateDAO().updateState(null, sysMessageID, consumerUID, n);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void updateInterestState(DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID consumerUID, int n, int n2) throws BrokerException {
        if (sysMessageID == null || consumerUID == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.updateInterestState() called with message: " + sysMessageID.getUniqueName() + ", consumer: " + consumerUID.getUniqueName() + ", state=" + n + ", expected: " + n2);
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getConsumerStateDAO().updateState(null, sysMessageID, consumerUID, n, n2);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInterestState(DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID consumerUID) throws BrokerException {
        if (sysMessageID == null || destinationUID == null || consumerUID == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.getInterestState() called with message: " + sysMessageID.getUniqueName());
        }
        this.checkClosedAndSetInProgress();
        Connection connection = null;
        try {
            connection = this.dbmgr.getConnection(true);
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getMessageDAO().checkMessage(connection, sysMessageID.getUniqueName());
                    int n = this.daoFactory.getConsumerStateDAO().getState(connection, sysMessageID, consumerUID);
                    return n;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            try {
                Util.close(null, null, connection);
            }
            finally {
                this.setInProgress(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsumerUID[] getConsumerUIDs(DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        if (sysMessageID == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.getConsumerUIDs() called with message: " + sysMessageID.getUniqueName());
        }
        this.checkClosedAndSetInProgress();
        Connection connection = null;
        try {
            connection = this.dbmgr.getConnection(true);
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getMessageDAO().checkMessage(connection, sysMessageID.getUniqueName());
                    ConsumerUID[] consumerUIDArray = this.daoFactory.getConsumerStateDAO().getConsumerUIDs(connection, sysMessageID).toArray(new ConsumerUID[0]);
                    return consumerUIDArray;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            try {
                Util.close(null, null, connection);
            }
            finally {
                this.setInProgress(false);
            }
        }
    }

    public void storeInterest(Consumer consumer, boolean bl) throws IOException, BrokerException {
        if (consumer == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.storeInterest() called with interest: " + consumer.getConsumerUID().getUniqueName());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getConsumerDAO().insert(null, consumer, System.currentTimeMillis());
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void removeInterest(Consumer consumer, boolean bl) throws IOException, BrokerException {
        if (consumer == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.removeInterest() called with interest: " + consumer.getConsumerUID().getUniqueName());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getConsumerDAO().delete(null, consumer);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public Consumer[] getAllInterests() throws IOException, BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.getAllInterests() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    Consumer[] consumerArray = this.daoFactory.getConsumerDAO().getAllConsumers(null).toArray(new Consumer[0]);
                    return consumerArray;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void storeDestination(Destination destination, boolean bl) throws IOException, BrokerException {
        if (destination == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.storeDestination() called with destination: " + destination.getUniqueName());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getDestinationDAO().insert(null, destination, null, 0L, System.currentTimeMillis());
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void updateDestination(Destination destination, boolean bl) throws BrokerException {
        if (destination == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.updateDestination() called with destination: " + destination.getUniqueName());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getDestinationDAO().update(null, destination);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void removeDestination(Destination destination, boolean bl) throws IOException, BrokerException {
        if (destination == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.removeDestination() called with destination: " + destination.getUniqueName());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getDestinationDAO().delete(null, destination);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public Destination getDestination(DestinationUID destinationUID) throws BrokerException {
        if (destinationUID == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.getDestination() called with destination ID: " + destinationUID.toString());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    Destination destination = this.daoFactory.getDestinationDAO().getDestination(null, destinationUID.toString());
                    return destination;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public Destination[] getAllDestinations() throws IOException, BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.getAllDestinations() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    Destination[] destinationArray = this.daoFactory.getDestinationDAO().getAllDestinations(null, null).toArray(new Destination[0]);
                    return destinationArray;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void storeTransaction(TransactionUID transactionUID, TransactionState transactionState, boolean bl) throws IOException, BrokerException {
        if (transactionUID == null || transactionState == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.storeTransaction() called with txn: " + transactionUID.longValue());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getTransactionDAO().insert(null, transactionUID, transactionState);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void removeTransaction(TransactionUID transactionUID, boolean bl) throws IOException, BrokerException {
        if (transactionUID == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.removeTransaction() called with txn: " + transactionUID.longValue());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getTransactionDAO().delete(null, transactionUID);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void updateTransactionState(TransactionUID transactionUID, TransactionState transactionState, boolean bl) throws IOException, BrokerException {
        if (transactionUID == null || transactionState == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.updateTransactionState called with id=" + transactionUID.longValue() + ", ts=" + transactionState.getState());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getTransactionDAO().updateTransactionState(null, transactionUID, transactionState);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public HashMap getAllTransactionStates() throws IOException, BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.getAllTransactionStates() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    HashMap hashMap = this.daoFactory.getTransactionDAO().getAllTransactionStates(null);
                    return hashMap;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void storeTransactionAck(TransactionUID transactionUID, TransactionAcknowledgement transactionAcknowledgement, boolean bl) throws BrokerException {
        if (transactionUID == null || transactionAcknowledgement == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.storeTransactionAck() called with txn: " + transactionUID.longValue());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getConsumerStateDAO().updateTransaction(null, transactionAcknowledgement.getSysMessageID(), transactionAcknowledgement.getStoredConsumerUID(), transactionUID);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void removeTransactionAck(TransactionUID transactionUID, boolean bl) throws BrokerException {
        if (transactionUID == null) {
            throw new NullPointerException();
        }
        if (DEBUG && DEBUG) {
            this.logger.log(4, "JDBCStore.removeTransactionAck() called with txn: " + transactionUID.longValue());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getConsumerStateDAO().clearTransaction(null, transactionUID);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public HashMap getAllTransactionAcks() throws BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.getAllTransactionAcks() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    HashMap hashMap = this.daoFactory.getConsumerStateDAO().getAllTransactionAcks(null);
                    return hashMap;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public TransactionAcknowledgement[] getTransactionAcks(TransactionUID transactionUID) throws BrokerException {
        if (transactionUID == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.getTransactionAcks() called with txn: " + transactionUID.longValue());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    TransactionAcknowledgement[] transactionAcknowledgementArray = this.daoFactory.getConsumerStateDAO().getTransactionAcks(null, transactionUID).toArray(new TransactionAcknowledgement[0]);
                    return transactionAcknowledgementArray;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void updateProperty(String string, Object object, boolean bl) throws BrokerException {
        if (string == null) {
            throw new NullPointerException();
        }
        if (Store.DEBUG) {
            this.logger.log(4, "JDBCStore.updateProperty() called with name: " + string);
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getPropertyDAO().update(null, string, object);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public Object getProperty(String string) throws BrokerException {
        if (string == null) {
            throw new NullPointerException();
        }
        if (Store.DEBUG) {
            this.logger.log(4, "JDBCStore.getProperty() called with name: " + string);
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    Object object = this.daoFactory.getPropertyDAO().getProperty(null, string);
                    return object;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public String[] getPropertyNames() throws BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "JDBCStore.getPropertyNames() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    String[] stringArray = this.daoFactory.getPropertyDAO().getPropertyNames(null).toArray(new String[0]);
                    return stringArray;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void storeConfigChangeRecord(long l, byte[] byArray, boolean bl) throws BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.storeConfigChangeRecord() called");
        }
        if (l <= 0L) {
            String string = String.valueOf(l);
            this.logger.log(32, "B3074", string);
            throw new BrokerException(this.br.getKString("B3074", string));
        }
        if (byArray == null) {
            throw new NullPointerException();
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getConfigRecordDAO().insert(null, byArray, l);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public ArrayList getConfigChangeRecordsSince(long l) throws BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.getConfigChangeRecordsSince() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    ArrayList arrayList = (ArrayList)this.daoFactory.getConfigRecordDAO().getRecordsSince(null, l);
                    return arrayList;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public Object[] getAllConfigRecords() throws BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "JDBCStore.getAllConfigRecords() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    Object[] objectArray = this.daoFactory.getConfigRecordDAO().getAllRecords(null);
                    return objectArray;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void clearAllConfigChangeRecords(boolean bl) throws BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.clearAllConfigChangeRecords() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getConfigRecordDAO().deleteAll(null);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll(boolean bl) throws BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.clearAll() called");
        }
        this.checkClosedAndSetInProgress();
        Connection connection = null;
        try {
            connection = this.dbmgr.getConnection(false);
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    if (Globals.getHAEnabled()) {
                        this.daoFactory.getTransactionDAO().deleteAll(connection);
                        this.daoFactory.getDestinationDAO().deleteAll(connection);
                        this.daoFactory.getConsumerStateDAO().deleteAll(connection);
                        this.daoFactory.getMessageDAO().deleteAll(connection);
                    } else {
                        List list = this.daoFactory.getAllDAOs();
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            BaseDAO baseDAO = (BaseDAO)iterator.next();
                            if (baseDAO instanceof VersionDAO || baseDAO instanceof BrokerDAO) continue;
                            baseDAO.deleteAll(connection);
                        }
                    }
                    connection.commit();
                    return;
                }
                catch (Exception exception) {
                    try {
                        if (retryStrategy == null) {
                            retryStrategy = new Util.RetryStrategy();
                        }
                        retryStrategy.assertShouldRetry(exception);
                        continue;
                    }
                    catch (Exception exception2) {
                        throw new BrokerException(this.br.getKString("B4081"), exception2);
                    }
                }
                break;
            }
        }
        finally {
            try {
                Util.close(null, null, connection);
            }
            finally {
                this.setInProgress(false);
            }
        }
    }

    public void close(boolean bl) {
        this.setClosedAndWait();
        this.closeDB(true);
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.close(" + bl + ") done.");
        }
    }

    public long getBrokerHeartbeat(String string) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    long l = this.daoFactory.getBrokerDAO().getHeartbeat(null, string);
                    return l;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public HashMap getAllBrokerHeartbeats() throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    HashMap hashMap = this.daoFactory.getBrokerDAO().getAllHeartbeats(null);
                    return hashMap;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public boolean updateBrokerHeartbeat(String string, long l) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    boolean bl = this.daoFactory.getBrokerDAO().updateHeartbeat(null, string, l);
                    return bl;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public boolean updateBrokerHeartbeat(String string, long l, long l2, BrokerState brokerState) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    boolean bl = this.daoFactory.getBrokerDAO().updateHeartbeat(null, string, l, l2, brokerState);
                    return bl;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void addBrokerInfo(String string, String string2, BrokerState brokerState, int n, long l, long l2) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getBrokerDAO().insert(null, string, string2, n, brokerState, l, l2);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void updateBrokerInfo(String string, String string2, String string3, int n, BrokerState brokerState, long l) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getBrokerDAO().update(null, string, string2, string3, n, brokerState, l);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public HABrokerInfo getBrokerInfo(String string) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    HABrokerInfo hABrokerInfo = this.daoFactory.getBrokerDAO().getBrokerInfo(null, string);
                    return hABrokerInfo;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public HashMap getAllBrokerInfoByState(BrokerState brokerState) throws BrokerException {
        if (brokerState == null) {
            throw new NullPointerException();
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    HashMap hashMap = this.daoFactory.getBrokerDAO().getAllBrokerInfosByState(null, brokerState);
                    return hashMap;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public boolean updateBrokerState(String string, BrokerState brokerState, BrokerState brokerState2) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    boolean bl = this.daoFactory.getBrokerDAO().updateState(null, string, brokerState, brokerState2);
                    return bl;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public BrokerState getBrokerState(String string) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    BrokerState brokerState = this.daoFactory.getBrokerDAO().getState(null, string);
                    return brokerState;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public Object[] getAllBrokerStates() throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    Object[] objectArray = this.daoFactory.getBrokerDAO().getAllStates(null);
                    return objectArray;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void getTakeOverLock(String string, String string2, long l, BrokerState brokerState, long l2, BrokerState brokerState2) throws TakeoverLockException, BrokerException {
        TakeoverStoreInfo takeoverStoreInfo;
        Connection connection;
        block20: {
            this.checkClosedAndSetInProgress();
            connection = null;
            HashMap hashMap = this.takeoverLockMap;
            // MONITORENTER : hashMap
            takeoverStoreInfo = (TakeoverStoreInfo)this.takeoverLockMap.get(string2);
            if (takeoverStoreInfo == null) break block20;
            this.logger.logToAll(16, "B2109", string2);
            // MONITOREXIT : hashMap
            try {
                Util.close(null, null, connection);
                return;
            }
            finally {
                this.setInProgress(false);
            }
        }
        connection = this.dbmgr.getConnection(true);
        Util.RetryStrategy retryStrategy = null;
        while (true) {
            try {
                HABrokerInfo hABrokerInfo = this.daoFactory.getBrokerDAO().takeover(connection, string, string2, l, brokerState, l2, brokerState2);
                long l3 = System.currentTimeMillis();
                this.logger.logToAll(8, "B1168", string2, String.valueOf(l3));
                takeoverStoreInfo = new TakeoverStoreInfo(string2, hABrokerInfo, l3);
                this.takeoverLockMap.put(string2, takeoverStoreInfo);
                // MONITOREXIT : hashMap
            }
            catch (Exception exception) {
                try {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                catch (Throwable throwable) {
                    try {
                        Util.close(null, null, connection);
                        throw throwable;
                    }
                    finally {
                        this.setInProgress(false);
                    }
                }
            }
            try {
                Util.close(null, null, connection);
                return;
            }
            finally {
                this.setInProgress(false);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TakeoverStoreInfo takeOverBrokerStore(String string, String string2) throws BrokerException {
        this.checkClosedAndSetInProgress();
        Connection connection = null;
        try {
            connection = this.dbmgr.getConnection(false);
            BrokerDAO brokerDAO = this.daoFactory.getBrokerDAO();
            HABrokerInfo hABrokerInfo = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    hABrokerInfo = brokerDAO.getBrokerInfo(connection, string2);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
            if (hABrokerInfo == null) {
                String string3 = this.br.getKString("B3169", string2);
                this.logger.log(32, "B3100", string3);
                throw new BrokerException(this.br.getKString("B3100", string3));
            }
            TakeoverStoreInfo takeoverStoreInfo = null;
            Object object = this.takeoverLockMap;
            synchronized (object) {
                takeoverStoreInfo = (TakeoverStoreInfo)this.takeoverLockMap.get(string2);
            }
            if (takeoverStoreInfo == null || !string.equals(hABrokerInfo.getTakeoverBrokerID())) {
                this.logger.log(32, "B3179", string2);
                throw new BrokerException(this.br.getKString("B3179", string2));
            }
            retryStrategy = null;
            while (true) {
                try {
                    object = this.daoFactory.getDestinationDAO();
                    List list = object.takeover(connection, string, string2);
                    takeoverStoreInfo.setDestinationList(list);
                    MessageDAO messageDAO = this.daoFactory.getMessageDAO();
                    List list2 = messageDAO.takeover(connection, string, string2);
                    takeoverStoreInfo.setMessageList(list2);
                    TransactionDAO transactionDAO = this.daoFactory.getTransactionDAO();
                    List list3 = transactionDAO.takeover(connection, string, string2);
                    takeoverStoreInfo.setTransactionList(list3);
                    connection.commit();
                    Object object2 = this.takeoverLockMap;
                    synchronized (object2) {
                        this.takeoverLockMap.remove(string2);
                    }
                    object2 = takeoverStoreInfo;
                    return object2;
                }
                catch (Exception exception) {
                    try {
                        if (retryStrategy == null) {
                            retryStrategy = new Util.RetryStrategy();
                        }
                        retryStrategy.assertShouldRetry(exception);
                        continue;
                    }
                    catch (Throwable throwable) {
                        this.logger.logToAll(8, "B1169", string2);
                        HABrokerInfo hABrokerInfo2 = takeoverStoreInfo.getSavedBrokerInfo();
                        try {
                            retryStrategy = null;
                            while (true) {
                                try {
                                    brokerDAO.updateHeartbeat(connection, string2, hABrokerInfo2.getHeartbeat());
                                    brokerDAO.update(connection, string2, null, hABrokerInfo2.getUrl(), hABrokerInfo2.getVersion(), BrokerState.getState(hABrokerInfo2.getState()), hABrokerInfo2.getSessionID());
                                    connection.commit();
                                    HashMap hashMap = this.takeoverLockMap;
                                    synchronized (hashMap) {
                                        this.takeoverLockMap.remove(string2);
                                    }
                                }
                                catch (Exception exception2) {
                                    if (retryStrategy == null) {
                                        retryStrategy = new Util.RetryStrategy();
                                    }
                                    retryStrategy.assertShouldRetry(exception2);
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (Exception exception3) {
                            this.logger.logStack(32, "B3171", string2, (Throwable)exception3);
                        }
                        throw new BrokerException(this.br.getKString("B3172", string2), throwable);
                    }
                }
                break;
            }
        }
        finally {
            try {
                Util.close(null, null, connection);
            }
            finally {
                this.setInProgress(false);
            }
        }
    }

    public void updateTransactionAccessedTime(TransactionUID transactionUID, long l) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getTransactionDAO().updateAccessedTime(null, transactionUID, l);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public TransactionState getTransactionState(TransactionUID transactionUID) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    TransactionState transactionState = this.daoFactory.getTransactionDAO().getTransactionState(null, transactionUID);
                    return transactionState;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public long getTransactionAccessedTime(TransactionUID transactionUID) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    long l = this.daoFactory.getTransactionDAO().getAccessedTime(null, transactionUID);
                    return l;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void updateTransactionBroker(TransactionUID transactionUID, String string) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getTransactionDAO().updateBroker(null, transactionUID, string);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public String getTransactionBroker(TransactionUID transactionUID) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    String string = this.daoFactory.getTransactionDAO().getBroker(null, transactionUID);
                    return string;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public List getTransactions(String string) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    List list = this.daoFactory.getTransactionDAO().getTransactionsByBrokerID(null, string);
                    return list;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public int[] getTransactionUsageInfo(TransactionUID transactionUID) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    int[] nArray = this.daoFactory.getTransactionDAO().getTransactionUsageInfo(null, transactionUID);
                    return nArray;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public long getDestinationConnectedTime(Destination destination) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    long l = this.daoFactory.getDestinationDAO().getDestinationConnectedTime(null, destination.getUniqueName());
                    return l;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public boolean hasMessageBeenAcked(SysMessageID sysMessageID) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    boolean bl = this.daoFactory.getMessageDAO().hasMessageBeenAcked(null, sysMessageID);
                    return bl;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void updateDestinationConnectedTime(Destination destination, long l) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getDestinationDAO().updateConnectedTime(null, destination, l);
                    return;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeDB(boolean bl) {
        Connection connection = null;
        try {
            if (bl) {
                connection = this.dbmgr.getConnection(true);
                if (!Globals.getHAEnabled() && this.config.getBooleanProperty(LOCK_STORE_PROP, true)) {
                    DBManager.lockTables(connection, false);
                }
            }
        }
        catch (Exception exception) {
            this.logger.log(16, "B4103", exception);
        }
        finally {
            try {
                Util.close(null, null, connection);
            }
            catch (Exception exception) {}
        }
        this.dbmgr.close();
    }

    public String getStoreType() {
        return "jdbc";
    }

    public HashMap getStorageInfo(Destination destination) throws BrokerException {
        throw new BrokerException(this.br.getKString("B3136"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDebugState() throws BrokerException {
        String string = this.dbmgr.getOpenDBURL();
        String string2 = "(" + this.dbmgr.getBrokerID() + ")";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("JDBC-based store", string + string2);
        hashtable.put("Store version", String.valueOf(400));
        Connection connection = null;
        try {
            connection = this.dbmgr.getConnection(true);
            Iterator iterator = this.daoFactory.getAllDAOs().iterator();
            while (iterator.hasNext()) {
                hashtable.putAll(((BaseDAO)iterator.next()).getDebugInfo(connection));
            }
        }
        finally {
            Util.close(null, null, connection);
        }
        return hashtable;
    }

    public void compactDestination(Destination destination) throws BrokerException {
        throw new BrokerException(this.br.getKString("B3136"));
    }

    private boolean checkStore(Connection connection) throws BrokerException {
        boolean bl = true;
        int n = -1;
        if (this.checkOldStoreVersion(connection, "IMQSV37" + this.dbmgr.getBrokerID(), "STOREVERSION", 370)) {
            n = 370;
        } else if (this.checkOldStoreVersion(connection, "IMQSV35" + this.dbmgr.getBrokerID(), "STOREVERSION", 350)) {
            n = 350;
        }
        boolean bl2 = false;
        int n2 = 0;
        try {
            n2 = this.daoFactory.getVersionDAO().getStoreVersion(connection);
        }
        catch (BrokerException brokerException) {
            this.logger.log(16, brokerException.getMessage(), brokerException.getCause());
        }
        if (n2 > 0) {
            boolean bl3 = bl2 = n2 == 400;
            if (bl2) {
                if (this.dbmgr.checkStoreExists(connection) == -1) {
                    this.logger.log(32, "B3213");
                    throw new BrokerException(this.br.getKString("B3213"));
                }
            } else {
                String string = String.valueOf(n2);
                String string2 = String.valueOf(400);
                this.logger.log(32, "B3092", (Object)string, string2);
                throw new BrokerException(this.br.getKString("B3092", string, string2));
            }
            if (n > 0 && !this.removeStore) {
                this.logger.logToAll(8, "B1111");
            }
        }
        if (bl2) {
            if (this.removeStore) {
                try {
                    DBTool.dropTables(connection, null);
                }
                catch (SQLException sQLException) {
                    throw new BrokerException(this.br.getKString("B3121", this.dbmgr.getOpenDBURL()), sQLException);
                }
                bl = false;
            } else if (this.resetStore) {
                this.clearAll(true);
            }
        } else {
            boolean bl4 = false;
            if (this.createStore) {
                bl4 = true;
            }
            boolean bl5 = false;
            String string = null;
            if (n > 0) {
                if (this.removeStore) {
                    bl5 = true;
                    string = "B1112";
                } else if (this.resetStore) {
                    bl4 = true;
                    bl5 = true;
                    string = "B1113";
                } else {
                    this.logger.logToAll(8, "B1109", n);
                    if (this.upgradeNoBackup && !Broker.getBroker().force) {
                        this.getConfirmation();
                    }
                    if (!Globals.getHAEnabled()) {
                        new UpgradeStore(this, n).upgradeStore(connection);
                        return bl;
                    }
                }
            }
            if (!bl4) {
                this.logger.log(32, "B3132");
                throw new BrokerException(this.br.getKString("B3132"));
            }
            if (bl5) {
                this.logger.logToAll(8, string);
                try {
                    DBTool.dropTables(connection, this.dbmgr.getTableNames(n));
                }
                catch (Exception exception) {
                    this.logger.logToAll(32, "B3133", exception);
                    throw new BrokerException(this.br.getKString("B3133"), exception);
                }
            }
            if (bl4) {
                this.logger.logToAll(8, "B1114");
                try {
                    DBTool.createTables(connection);
                }
                catch (Exception exception) {
                    String string3 = this.dbmgr.getCreateDBURL();
                    if (string3 == null || string3.length() == 0) {
                        string3 = this.dbmgr.getOpenDBURL();
                    }
                    String string4 = this.br.getKString("B3073", string3);
                    this.logger.logToAll(32, string4, exception);
                    throw new BrokerException(string4, exception);
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkOldStoreVersion(Connection var1_1, String var2_2, String var3_3, int var4_4) throws BrokerException {
        try {
            var5_5 = "SELECT " + var3_3 + " FROM " + var2_2;
            var6_7 = null;
            var7_8 = null;
            try {
                var6_7 = var1_1.createStatement();
                var7_8 = var6_7.executeQuery(var5_5);
                if (!var7_8.next()) ** GOTO lbl27
                var8_9 = var7_8.getInt(1);
                if (var8_9 == var4_4) {
                    var9_11 = true;
                }
                ** GOTO lbl-1000
            }
            catch (SQLException var8_10) {
                this.logger.log(4, "Assume old store does not exist because : " + var8_10.getMessage());
                Util.close(var7_8, var6_7, null);
                return false;
            }
            catch (Throwable var11_14) {
                Util.close(var7_8, var6_7, null);
                throw var11_14;
            }
            Util.close(var7_8, var6_7, null);
            return var9_11;
lbl-1000:
            // 1 sources

            {
                var9_12 = String.valueOf(var8_9);
                var10_13 = String.valueOf(var4_4);
                this.logger.log(32, "B3125", (Object)var9_12, var10_13);
                throw new BrokerException(this.br.getKString("B3125", var9_12, var10_13));
lbl27:
                // 1 sources

                this.logger.log(32, "B3131", var2_2);
                throw new BrokerException(this.br.getKString("B3131", var2_2));
            }
        }
        catch (Exception var5_6) {
            this.logger.log(32, "B4114", var5_6);
            throw new BrokerException(this.br.getKString("B4114"), var5_6);
        }
    }

    boolean resetMessage() {
        return this.resetMessage;
    }

    boolean resetInterest() {
        return this.resetInterest;
    }
}

